/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineLinearLayout;

public class IcsLinearLayout
extends NineLinearLayout {
    private static final int[] LinearLayout = new int[]{16843049, 16843561, 16843562};
    private static final int LinearLayout_divider = 0;
    private static final int LinearLayout_showDividers = 1;
    private static final int LinearLayout_dividerPadding = 2;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;

    public IcsLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, LinearLayout);
        this.setDividerDrawable(a.getDrawable(0));
        this.mShowDividers = a.getInt(1, 0);
        this.mDividerPadding = a.getDimensionPixelSize(2, 0);
        a.recycle();
    }

    public void setShowDividers(int showDividers) {
        if (showDividers != this.mShowDividers) {
            this.requestLayout();
            this.invalidate();
        }
        this.mShowDividers = showDividers;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    public void setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(divider == null);
        this.requestLayout();
    }

    public void setDividerPadding(int padding) {
        this.mDividerPadding = padding;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        int count;
        int index = this.indexOfChild(child);
        int orientation = this.getOrientation();
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)child.getLayoutParams();
        if (this.hasDividerBeforeChildAt(index)) {
            if (orientation == 1) {
                params.topMargin = this.mDividerHeight;
            } else {
                params.leftMargin = this.mDividerWidth;
            }
        }
        if (index == (count = this.getChildCount()) - 1 && this.hasDividerBeforeChildAt(count)) {
            if (orientation == 1) {
                params.bottomMargin = this.mDividerHeight;
            } else {
                params.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDivider != null) {
            if (this.getOrientation() == 1) {
                this.drawDividersVertical(canvas);
            } else {
                this.drawDividersHorizontal(canvas);
            }
        }
        super.onDraw(canvas);
    }

    void drawDividersVertical(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View child = this.getChildAt(i);
            if (child != null && child.getVisibility() != 8 && this.hasDividerBeforeChildAt(i)) {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                int top = child.getTop() - lp.topMargin;
                this.drawHorizontalDivider(canvas, top);
            }
            ++i;
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                bottom = child.getBottom();
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    void drawDividersHorizontal(Canvas canvas) {
        LinearLayout.LayoutParams lp;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View child = this.getChildAt(i);
            if (child != null && child.getVisibility() != 8 && this.hasDividerBeforeChildAt(i)) {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                int left = child.getLeft() - lp.leftMargin;
                this.drawVerticalDivider(canvas, left);
            }
            ++i;
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getChildAt(count - 1);
            int right = 0;
            if (child == null) {
                right = this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LinearLayout.LayoutParams)child.getLayoutParams();
                right = child.getRight();
            }
            this.drawVerticalDivider(canvas, right);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (childIndex == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            boolean hasVisibleViewBefore = false;
            int i = childIndex - 1;
            while (i >= 0) {
                if (this.getChildAt(i).getVisibility() != 8) {
                    hasVisibleViewBefore = true;
                    break;
                }
                --i;
            }
            return hasVisibleViewBefore;
        }
        return false;
    }
}

