/*
 * Copyright (C) 2010 František Hejl
 *
 * This file is part of Chesswalk.
 *
 * Chesswalk is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Chesswalk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "Zobrist.h"

unsigned long long Zobrist::pieces[6][2][120] = { {
		{ 6704186230732861427ULL, 10175694016679745966ULL,
				11392801900192159255ULL, 2341415805983308808ULL,
				17048653540167941635ULL, 13734573940376158162ULL,
				1743463309126833494ULL, 5865169712166737063ULL,
				6108454989520805413ULL, 5324043709641150515ULL,
				8815509099843716150ULL, 1800150969038375515ULL,
				5539117905334868741ULL, 4526715391802526174ULL,
				13026138329606404023ULL, 818603298596137234ULL,
				7491679875830520563ULL, 6233223121781529207ULL,
				14574928504902162333ULL, 2600269759455856474ULL,
				5975255237296201152ULL, 15407742758341440788ULL,
				10127664673971022271ULL, 17455594025336356553ULL,
				9945487349123669718ULL, 16587634886579643078ULL,
				10099254299075379096ULL, 5258127520038692469ULL,
				3165174866493072943ULL, 15210750148745319767ULL,
				15263535604623327917ULL, 4967394711094549146ULL,
				5645221436954727201ULL, 12410987826289809460ULL,
				17027810102113696511ULL, 7173731649998470077ULL,
				7542272522868087092ULL, 1356267765796734271ULL,
				10957565860371120102ULL, 10171802562210485014ULL,
				10533185376766824003ULL, 8450412055260977494ULL,
				15437956544208202770ULL, 16275622701339771541ULL,
				13560174723637808761ULL, 13546499657628720461ULL,
				17894298478314430884ULL, 17775770416900669902ULL,
				7586298997465074348ULL, 5486586836815781963ULL,
				9812373476025589041ULL, 9022052228987119009ULL,
				12466151094074920148ULL, 17820132460518097356ULL,
				16597420768606200756ULL, 3873457970056489972ULL,
				15039718362797972057ULL, 14174936329466229488ULL,
				1998496985341974393ULL, 239114696259147424ULL,
				224765194340863366ULL, 16405098634555239383ULL,
				15893150916929687680ULL, 787322997070453639ULL,
				10864697820236758911ULL, 11289256619628912633ULL,
				806848333144713802ULL, 3086018352641704614ULL,
				11514503691452081467ULL, 11456299004889638732ULL,
				741836824022888568ULL, 11467864604372327195ULL,
				10988598792727348819ULL, 5944623743232867570ULL,
				17559050188203245000ULL, 5335532763931109824ULL,
				1342119145543044267ULL, 4670499466652280457ULL,
				15760878449465177296ULL, 4787461890064765486ULL,
				5402863040854576682ULL, 17884585582835297137ULL,
				16768873805223272808ULL, 9360383718771452257ULL,
				3290770073845037225ULL, 1941340513833374750ULL,
				6094737539434074967ULL, 13438480110170047629ULL,
				9516216842143070722ULL, 4959128996022657213ULL,
				4195928949542145327ULL, 10126106885801626552ULL,
				3950746748070355052ULL, 16691184833900050230ULL,
				16779499286423056148ULL, 4917373160065852201ULL,
				14236324789805607407ULL, 15254735344032222602ULL,
				10878707477313169228ULL, 15210013231784757622ULL,
				13577077279112583977ULL, 4017775153035407511ULL,
				16018985192323926401ULL, 10169277745356280243ULL,
				298575600911623227ULL, 17069168855015226180ULL,
				10301659937345022216ULL, 11610371924004431424ULL,
				5571882595401525003ULL, 11892142790094190765ULL,
				1251369257897748459ULL, 17402370881761167501ULL,
				2922818049761820197ULL, 5961346116893932300ULL,
				16046846196867333055ULL, 13683393441205771995ULL,
				13129064157730386278ULL, 2330746437620624581ULL,
				9233333069917391171ULL, 17638489011907056126ULL }, {
				4933759563249732033ULL, 5344274075676597653ULL,
				2292808642583250665ULL, 9358948452394930662ULL,
				14642301318386906232ULL, 18276774944632532688ULL,
				14773827687091296906ULL, 1059877338693296878ULL,
				8809736699423525820ULL, 389435143617213666ULL,
				9035404615344127048ULL, 6698132853543676046ULL,
				12203215410996353959ULL, 11159129758342191003ULL,
				7603479914701991079ULL, 15034285722165591824ULL,
				5281156713952773150ULL, 11289024851666628957ULL,
				16883171809047604597ULL, 11781187774508220215ULL,
				9945562304480653383ULL, 18176391490773949261ULL,
				9762066988892701197ULL, 4648652818315228362ULL,
				8271097332624361610ULL, 14122353952170690838ULL,
				2806766248001548835ULL, 3040049223686406311ULL,
				1877651477849856487ULL, 13634698408457352630ULL,
				5026879841576263765ULL, 7681722235396859350ULL,
				12205935100903124085ULL, 8293587719552276350ULL,
				7463489357323362566ULL, 12679799812299568531ULL,
				4009075385796585097ULL, 2484142745602586713ULL,
				15475309637780254173ULL, 17598094697726900470ULL,
				12155567577643565966ULL, 12085988581235365925ULL,
				12720008782136328857ULL, 10223855091614849157ULL,
				15803744705962799397ULL, 16871930010615105713ULL,
				1563423234943848744ULL, 1886328975011678812ULL,
				3554698328525077246ULL, 18420438377686528089ULL,
				3511989531720429245ULL, 10594466627107145657ULL,
				6525884533405018779ULL, 279519632290359887ULL,
				16998372757143794138ULL, 4085321541970088582ULL,
				77427397220838617ULL, 7758699183501904283ULL,
				12024617558008750849ULL, 912052373153258412ULL,
				1763459557083842877ULL, 15519898036994503258ULL,
				17084508505553667988ULL, 13753670889378701851ULL,
				6122052691334601144ULL, 16873229107606981816ULL,
				2494623178887556914ULL, 7973809496930462124ULL,
				8575688241101542420ULL, 2836453664192884337ULL,
				5121398481874420577ULL, 1398214857089308698ULL,
				13485461216423081932ULL, 17634100482585255621ULL,
				6438198729254351902ULL, 6938632777017150937ULL,
				5488137572173009518ULL, 11531326021135914641ULL,
				15005454426721654774ULL, 12814304383954156000ULL,
				13091681530191128669ULL, 7614022302559670363ULL,
				6239381629195771844ULL, 12159181767688998854ULL,
				5254649564759050902ULL, 13505544974396660762ULL,
				10656139064037621717ULL, 9684379005819013430ULL,
				11351113369267231984ULL, 12133131576384079107ULL,
				13567599824163050265ULL, 13931946670456250334ULL,
				14603987920773659001ULL, 1367800083867469966ULL,
				4627031412505590388ULL, 4272531194760335907ULL,
				5131605766716337257ULL, 13127526198867115437ULL,
				14014220939147247012ULL, 1949915902576537475ULL,
				13622093120883969328ULL, 763410879049045988ULL,
				5696564879877116193ULL, 18154704470186713949ULL,
				15699183705579226997ULL, 680024726514818799ULL,
				17726776453340410001ULL, 15295896829273364775ULL,
				6551154465392435430ULL, 9634047295662088956ULL,
				23056360933021946ULL, 5092303387353844282ULL,
				3449167314667974582ULL, 10136088935958918565ULL,
				15384271885013567611ULL, 8307397480926803275ULL,
				14731477812504356392ULL, 7870710842120090560ULL,
				1737092904935238906ULL, 108775765361657423ULL } }, { {
		13880680633775641909ULL, 4888512142224660172ULL,
		10612164222384215997ULL, 1049821101278772736ULL,
		7140487700496954380ULL, 17588237606880006941ULL,
		9255536679664001103ULL, 17333166121891363991ULL, 981205018459964275ULL,
		2100434245436009391ULL, 11525454224413157922ULL,
		8919003741364724269ULL, 1366270400201104407ULL, 8457683058962159450ULL,
		13042406238489275621ULL, 8352893807426398381ULL,
		14051434115738829972ULL, 17839727330205081097ULL,
		9596310157277054509ULL, 14672508530447030379ULL,
		6045222344726155646ULL, 8566144219257373559ULL, 2803723278284156171ULL,
		8210459897261536337ULL, 8434468553939846189ULL, 7632224982694186691ULL,
		6260643503515035865ULL, 15955964788336504627ULL,
		15942815111283540719ULL, 10053489364853683102ULL,
		17702812811558561663ULL, 14352754485577928381ULL,
		17771218066121294765ULL, 11312525210274138702ULL,
		7217367070465419734ULL, 18056861078320106251ULL, 35210080730105191ULL,
		15257108242872534344ULL, 8451566307562559999ULL,
		13542386545496354696ULL, 15390174103144261304ULL,
		9659909108296440971ULL, 6531674931809595495ULL, 5421735307623603373ULL,
		15659796058579780127ULL, 8495621400985434734ULL,
		4461494704839931936ULL, 837361525233837882ULL, 9796570515442953680ULL,
		8920561850138515033ULL, 11894336822284996824ULL,
		13093294029655932201ULL, 3216668407175460282ULL,
		12206047665843666199ULL, 8368585744083927042ULL,
		12679619352726927180ULL, 16750844975227279163ULL,
		6126263857809705413ULL, 6704311897662646323ULL, 3487101884579654276ULL,
		9512095968584943903ULL, 12244772024751862148ULL,
		7922546383348817783ULL, 4188650719072966011ULL, 5162701919717703023ULL,
		7710556640878631696ULL, 15340736633965026707ULL,
		8720081920074292119ULL, 3631356504328197370ULL, 8025997414102263048ULL,
		2541677820799001168ULL, 1068846273310029383ULL,
		11492743888677330174ULL, 5123935094505909441ULL,
		3405128378211005043ULL, 12411181937881830881ULL, 244674049523835904ULL,
		13384881604227787755ULL, 14180384945983108062ULL,
		17584809205976047956ULL, 90276170549032615ULL, 12508707179379696761ULL,
		12578287160539639291ULL, 2722959041517537529ULL,
		7182016554723296609ULL, 10675494280569005047ULL,
		1000004772256323850ULL, 12017158920995351904ULL,
		6706333001842805062ULL, 6493255552800614599ULL, 6744862293612372475ULL,
		18196607962289260297ULL, 7170962758217557628ULL,
		3890165067492666447ULL, 13170497303703096764ULL,
		6030255645864130163ULL, 8758298376560232180ULL,
		17826940183851231323ULL, 977538624825164503ULL,
		16717974315163227910ULL, 1392629207215662496ULL,
		12817384621346655776ULL, 6560371418121038997ULL, 252123633460181722ULL,
		7918968221925526985ULL, 1941843261749716668ULL,
		14278497418798466551ULL, 11269088623369106461ULL,
		1031927165933704289ULL, 9812286991503247255ULL, 3077030875058576182ULL,
		924549060177667995ULL, 14395844952055563948ULL, 6802338154612357834ULL,
		11761464660679244486ULL, 9338964113464269359ULL,
		2102188336456223480ULL, 16210542775652911408ULL,
		5491739633464203754ULL, 12767168865636134100ULL }, {
		14693347920656498762ULL, 1832371636478442564ULL,
		11081441409005172503ULL, 6086783817706344748ULL,
		13176881009571046500ULL, 6702595112864737806ULL,
		14205957594647959821ULL, 11169734554538307516ULL,
		13114865139672285489ULL, 10748521399813478148ULL,
		18378029777168126397ULL, 5865286959261107142ULL,
		10541264067877873532ULL, 15522063065239547491ULL,
		14021933331788793566ULL, 12028805638047347796ULL,
		16307424994913943542ULL, 10874664852139952131ULL,
		7346154272278975776ULL, 1810001682699748190ULL,
		10603973390518787528ULL, 12951100151871877090ULL,
		1765108367636499755ULL, 8028264459206884074ULL, 2105290294588328980ULL,
		16193154644120697941ULL, 6149307748315215492ULL,
		15996588617523012114ULL, 15814428107044461378ULL,
		11930108238972462829ULL, 7377674507896793635ULL,
		12788678303775393684ULL, 4616104748099594704ULL,
		17580276108075539564ULL, 4896670341389880354ULL,
		9183392765055851937ULL, 736465268355608370ULL, 4546567417428123068ULL,
		11895553899119817286ULL, 3743872139774331887ULL,
		15244359884323046861ULL, 18098802269017330278ULL,
		3198451790956090209ULL, 9473214734015968156ULL, 7112771819074727630ULL,
		3124895395038626908ULL, 7768617084168021482ULL, 2858836221209015573ULL,
		9062781020617792942ULL, 16838072309313722443ULL,
		7010143334253028921ULL, 1070468083701134245ULL,
		12036153159626434692ULL, 16721915083044641777ULL,
		12145781983441790201ULL, 18080819871655432488ULL,
		7525530009575063277ULL, 4840955102986890819ULL, 8548779364355499688ULL,
		13983141890031373699ULL, 17959127669441835458ULL,
		16962125927686258282ULL, 17723176720080796932ULL,
		18319677483690824079ULL, 18220843450099780313ULL,
		6781803345901690619ULL, 14767687875130398175ULL,
		16074530409470500745ULL, 17849909594625673181ULL,
		7327280882354848377ULL, 14185696731698518214ULL,
		16035992160042667932ULL, 11454698366186005748ULL,
		14106167023970369329ULL, 2872473646571805247ULL,
		2785009883731479250ULL, 4683163167130225757ULL, 2373240273017545030ULL,
		3127649748999047616ULL, 13857408628038219244ULL,
		3088428639385090778ULL, 111234226509240945ULL, 5404632713018878425ULL,
		166257915828162493ULL, 11433778391563597669ULL, 724415268625093388ULL,
		5867393078626159538ULL, 10510501059783247148ULL,
		6807187832244750465ULL, 13958588837670852936ULL,
		16391232883808387655ULL, 7021035711900510124ULL,
		10692900826445096549ULL, 16071114882785454993ULL,
		18306082548072642114ULL, 16669114843345750906ULL,
		6709857401887543984ULL, 5355763670078799188ULL, 6773923974258713337ULL,
		3284134926832677631ULL, 10801429511481850101ULL,
		2074508293603499402ULL, 2315093724106102091ULL, 1216714770588107175ULL,
		12277349173823565178ULL, 17326265397690741963ULL,
		13725697910211303442ULL, 2180104191170882067ULL,
		10408927320937252336ULL, 3772118401319495046ULL,
		10476960793429125301ULL, 347882517138959621ULL,
		18383038865814623107ULL, 2475737687146530583ULL,
		7017471371079171788ULL, 3059586745067648801ULL,
		10265164252453779982ULL, 12041691570785653202ULL,
		6891078275471962455ULL, 16243135149882579570ULL } }, { {
		9357413064938498220ULL, 15317421174757935340ULL,
		2129812916462525194ULL, 15853402099531378998ULL,
		4350958881388170612ULL, 7154065658172106309ULL,
		15137775693777273790ULL, 570795727881829368ULL,
		12206060130190809182ULL, 985533994957159669ULL, 8543307862538901074ULL,
		16296787386207176009ULL, 10236580224554804573ULL,
		7341999091885694878ULL, 5512483969484022735ULL,
		17212242946533496103ULL, 15478257787246232068ULL,
		15273292905494655527ULL, 6951230350224367906ULL, 757504639984204055ULL,
		3003574804124129878ULL, 7611813925312416370ULL, 3270460278406574784ULL,
		15138588616799255659ULL, 1757345958072541220ULL,
		10344337812052839116ULL, 12869018187135520041ULL,
		17851395836034254307ULL, 644871665556558169ULL,
		10307691580865620168ULL, 12491098674705058355ULL,
		13717033313791182738ULL, 17014245892760043269ULL,
		3898333969513027700ULL, 17378066184855740204ULL,
		15292784292953336788ULL, 1419349649317530235ULL,
		16743452824857684296ULL, 15606289296956009895ULL,
		7788820929345581207ULL, 18194085772362198341ULL,
		6341118277888699213ULL, 14788417988252090286ULL,
		15147391794068612411ULL, 18159140576431469353ULL,
		11520495745260955256ULL, 3506969058520515828ULL,
		11272030250943012495ULL, 14005340598559692691ULL,
		15582335253274263372ULL, 10535062875263539405ULL,
		13042109256454947162ULL, 8845843515985837894ULL,
		8220178731409633932ULL, 3258105200411397935ULL,
		13986154997043982861ULL, 10812495045926977761ULL,
		3648150905166084434ULL, 16797221703855946285ULL, 996084258544091229ULL,
		4983858794520261925ULL, 16044493017969234593ULL,
		16848285825310730615ULL, 17535928651290760305ULL,
		4508431159108072953ULL, 11835651341177194919ULL,
		13884698146233076675ULL, 8249350456957274814ULL,
		10858843922573957352ULL, 17875870125384041144ULL,
		3957913103313767980ULL, 12462277388075771581ULL,
		12791537434167613960ULL, 304450469549557744ULL,
		11629202978669605420ULL, 9235609810011155643ULL,
		8865095988714766742ULL, 10059328816456336845ULL,
		13764168684397609830ULL, 7823258396899717062ULL,
		5797892973045822274ULL, 15324068101921588159ULL, 43544008808702473ULL,
		5775587595746496769ULL, 92949768309428296ULL, 5117660132883705063ULL,
		3888687716432559256ULL, 1987523796104151430ULL, 8205104629411247632ULL,
		17862137035246845354ULL, 1558396987063976013ULL,
		18353458638127323678ULL, 15514639830895842915ULL,
		12157416944439481101ULL, 14253567725479266125ULL,
		2753637214618112145ULL, 3568657346608780672ULL,
		10153528941466650925ULL, 15346176207237865165ULL,
		9382007679444561252ULL, 8900178843138699453ULL,
		12910748162758285438ULL, 5252954905528838049ULL,
		6427735158349101867ULL, 17653155844266386802ULL,
		15316889141552807258ULL, 1518257001932167579ULL,
		16343874462587312759ULL, 469924310741017728ULL, 2480718689703122869ULL,
		17243605486905254653ULL, 13707449702877961699ULL,
		14270623411629358008ULL, 13658738437409869613ULL,
		13196019796938468013ULL, 4457757113541646106ULL,
		13119859732021215971ULL, 9854341589305028934ULL,
		2182594626530968903ULL, 11992073384822197999ULL }, {
		15382711093578456557ULL, 17956934030924405657ULL,
		4915812256804824824ULL, 11427067970453287846ULL,
		16207007683347722878ULL, 10862754970500608657ULL,
		13417510336000170110ULL, 9802306442911286196ULL, 918210498380646936ULL,
		15290975494703347194ULL, 7975137613281278174ULL,
		13420233184090661596ULL, 10655953128874253039ULL,
		10841094308896756097ULL, 11579652474951534670ULL,
		14359939608531849668ULL, 8664584518023942581ULL,
		14455284131580190455ULL, 9021554881848221073ULL,
		9587589360001511951ULL, 4933632728552309954ULL, 8238791045366174287ULL,
		5585025217513848174ULL, 9997370218828616217ULL, 8043877900847325924ULL,
		12769293395594756196ULL, 16054898387418942062ULL,
		12381612240935773414ULL, 7087998807712197315ULL,
		14036234771466100682ULL, 12940080807999706663ULL,
		15944957739923088414ULL, 10919069035312722121ULL,
		1437798928183246213ULL, 15304524230798502743ULL,
		16941822195577164256ULL, 13536112568792018643ULL,
		17252609434388136373ULL, 18072512475294286672ULL,
		7840001192685672866ULL, 3318423194593476357ULL, 8421930448748040413ULL,
		14907943056059674871ULL, 17097218571503803445ULL,
		16906814423288273039ULL, 10116824467964712438ULL,
		1758940395891600904ULL, 17687715194043984068ULL,
		10754555686070891527ULL, 4908414401201110253ULL,
		4511138590908523012ULL, 8188070485591055364ULL, 4847832871928523149ULL,
		12783192647717729754ULL, 13044426356609639189ULL,
		9715605344180881600ULL, 17275131765653223594ULL,
		13891224409565085205ULL, 14938061084984264420ULL,
		12491753008466120376ULL, 7252865559060088124ULL,
		12451494237822354880ULL, 7892063093023975414ULL,
		12795415384455596618ULL, 14386768753394837777ULL,
		16301528165468922901ULL, 16934645925519168626ULL,
		825176156725938942ULL, 5839144160349401218ULL, 7966563038729245206ULL,
		11191723997988148720ULL, 1346014197442265305ULL,
		6049150441785948148ULL, 8497707054882385552ULL,
		18268592660530093678ULL, 3453477144709667357ULL,
		14551937983120539651ULL, 5814031260378009745ULL, 52617560479614474ULL,
		3882262257514321719ULL, 16635810798325525946ULL,
		11455535957126444505ULL, 3880587716135721894ULL,
		11662956071340787844ULL, 14067206853930336560ULL,
		16136183090591211607ULL, 4547947279708268099ULL,
		2888318714771337647ULL, 8469412092968732034ULL,
		13526840833176012395ULL, 3786438350182086595ULL,
		8209601791873594877ULL, 17213355276067976822ULL,
		12366384322692612577ULL, 6375875189184209638ULL,
		8189245809909656699ULL, 5529996437994144520ULL,
		10528101090384677563ULL, 14548190101586217088ULL,
		13683638166733454328ULL, 12226500477797640991ULL,
		18294498577951175443ULL, 16581394357213398865ULL,
		7763096075959116127ULL, 6234507409954873215ULL,
		16083403931671327491ULL, 7129908961809415094ULL,
		10898522610344974455ULL, 17961726022268954078ULL,
		523694597083119835ULL, 6681480163818062667ULL, 8535499318776680700ULL,
		7026254679967098974ULL, 4673866402022862923ULL, 7250215335121024357ULL,
		8035141688097768835ULL, 952546779065936323ULL, 3742889922167924016ULL,
		10401577831904389105ULL, 11844186450635713210ULL } }, { {
		7604961494645766986ULL, 12794449605657642405ULL,
		10965858883409267965ULL, 13815142973696811943ULL,
		12617548704127269135ULL, 15708635561695980045ULL,
		15588918026463625175ULL, 3458061835379599094ULL,
		14470374400592635108ULL, 4706171960335753702ULL,
		5451570875384580394ULL, 14805641338374650266ULL,
		7730768881227264146ULL, 4469008347453545767ULL, 2967174264743461402ULL,
		15288649764059546852ULL, 10605122989668232912ULL,
		8490118073952721771ULL, 9769346196291595981ULL, 8745023443233923677ULL,
		2439579050877998748ULL, 4090633074219726298ULL,
		10658026189838534214ULL, 2171664632868710095ULL,
		7789576503195937442ULL, 12072904135393648945ULL,
		16296273598922047622ULL, 7541791521592899235ULL,
		3740896846711590195ULL, 8092432130066437432ULL,
		12256070852365955087ULL, 7708142411239180341ULL,
		12405221923299531036ULL, 10775290463441266245ULL,
		5802439361983914599ULL, 11689062814192922097ULL, 787583567128270348ULL,
		13656367306977804775ULL, 14766448269030150526ULL,
		14921867717710897044ULL, 5911884645355867403ULL,
		13472929088686487316ULL, 18066481294173185996ULL,
		5170971266005606565ULL, 9933773447769614869ULL,
		16918026560404946817ULL, 15742927970579444453ULL,
		5757914909666823090ULL, 1257379906228318127ULL, 8016567679864437333ULL,
		13595347152241783198ULL, 10855065360580997315ULL,
		10285287318226538839ULL, 16914539473521385164ULL,
		5653377388956328625ULL, 16447053704057135830ULL,
		14676044415434153535ULL, 9867632548653692672ULL,
		5152258806944381794ULL, 4262592953301017299ULL,
		10330170100439230276ULL, 3613577064148693580ULL,
		5640969518866218675ULL, 5441911977533769853ULL,
		15105680849384588464ULL, 9156082335109608973ULL,
		9686688551532537342ULL, 8080309346858320597ULL, 4971238588466056942ULL,
		14183073707893901954ULL, 9947177783545843017ULL,
		1911576946032340168ULL, 4109797440978381817ULL, 5774395563216116165ULL,
		5483785530276321724ULL, 6528749946978678792ULL,
		12508129800859856586ULL, 4279952339078234868ULL,
		10174144983669997826ULL, 1403098264756375990ULL,
		16575714290202687913ULL, 5143071919787338986ULL,
		1504260123088389376ULL, 10251799984581114030ULL,
		12936714731624103090ULL, 14626498856485836409ULL,
		8761356234946988033ULL, 10480816707476218042ULL,
		4376448248957665210ULL, 17207073102275307093ULL,
		3899050226499361739ULL, 1813650142423249191ULL, 6802396482994989729ULL,
		5305793640908467039ULL, 12594807262743280450ULL,
		9836411877935042354ULL, 937074070249543937ULL, 16611984785277563369ULL,
		16213720933363273995ULL, 11726297183275578351ULL,
		9900436820278370405ULL, 2049951124097661661ULL,
		11288561104246288412ULL, 12544456681061583412ULL,
		13799342936842367756ULL, 16574633405468373641ULL,
		3770319087337003409ULL, 3333704231009312886ULL,
		11347026629071624694ULL, 9187905446157686973ULL,
		17063185730644237862ULL, 16766983666173826345ULL,
		11218022420179768413ULL, 964682645424513510ULL, 5321937474095918394ULL,
		77472808839800072ULL, 9791596257095786743ULL, 8049240772980751611ULL,
		7445881240677581937ULL, 8805410338653611379ULL }, {
		2235256221279267107ULL, 3155110324095976669ULL,
		13774525803474343048ULL, 13380739146472014653ULL,
		4220239853862333688ULL, 15427424774893422461ULL,
		8566708709529102631ULL, 5540037463473857440ULL,
		15832632050857381429ULL, 5374732602952818002ULL,
		9507425254159043901ULL, 12256701719912258817ULL,
		13898060566680693047ULL, 4387135460931953484ULL,
		7774165038275399621ULL, 8916054903699797473ULL, 894065586937531685ULL,
		14609502141623067443ULL, 6525750334635346493ULL,
		18146006223200348671ULL, 3339897712722753183ULL,
		14907868346912108202ULL, 15654378592905252076ULL,
		6841578843114664653ULL, 8633232406170205971ULL, 8389716602871406052ULL,
		4265760409959631545ULL, 15852565185406572289ULL,
		7533443825449812655ULL, 17279231767063337670ULL,
		1205744522988822568ULL, 11056237087220948656ULL,
		17296206327535469779ULL, 6934180954027762168ULL,
		4394584816234237707ULL, 3204379359838810829ULL, 8693818872477756244ULL,
		15193842201490187827ULL, 9071751136309032045ULL, 687029869914129933ULL,
		12863073736767729400ULL, 2893900161059472913ULL,
		7338561600131959087ULL, 7266796392428594932ULL, 5090229540089426609ULL,
		1481607882547723763ULL, 10824452544177887590ULL, 105609774335074853ULL,
		5764377674405746921ULL, 7317872420714408527ULL, 5761861061692882657ULL,
		17004954163030082149ULL, 5653659795999835610ULL,
		4216896857470545250ULL, 6696225974483710889ULL, 7873790497438510724ULL,
		866272006499183522ULL, 6156087931391586675ULL, 6721339450984214969ULL,
		6829186341656870880ULL, 4801440068435766177ULL, 2702653867792616215ULL,
		6608841753065871486ULL, 2979939640551462491ULL,
		11759984275708361014ULL, 1961151877122953498ULL,
		13947015363064404205ULL, 16595990591984971713ULL,
		6638647384440825505ULL, 17527726945583142258ULL,
		6354307906313874594ULL, 5441973372477336432ULL, 185388547812883726ULL,
		16272037153302073077ULL, 14509194453745623284ULL,
		4050168266520953111ULL, 190376278005721015ULL, 12692172217427867742ULL,
		10493773035607946734ULL, 6317965145455183416ULL,
		15196288898125994863ULL, 13445117162867792848ULL,
		10098000360900323442ULL, 8047130420101908947ULL,
		1545654044278332814ULL, 7604612986925732299ULL,
		12302260881513079971ULL, 3622709627645838440ULL,
		13549521752974967750ULL, 2393577748943836066ULL,
		1811119091353979447ULL, 12442273929006990721ULL,
		9468912480303067723ULL, 10213118706181107569ULL,
		11955807505158491198ULL, 12530322198420173136ULL,
		6217280779323236530ULL, 8887513467191768943ULL, 5733737147759597227ULL,
		16156419599411424099ULL, 16553392242897924868ULL,
		15490695631613520114ULL, 16358337506697935758ULL,
		12976555241503415395ULL, 584624006049096931ULL, 4882014994772936735ULL,
		11523135925690002730ULL, 3417316219728680499ULL,
		1661626908594969614ULL, 18261224744222018596ULL,
		12560203147861744990ULL, 17549696481644046936ULL,
		4748032010786484883ULL, 11185517755581704439ULL,
		6357753057759758020ULL, 14083959066741841440ULL,
		1590562209001723313ULL, 12974563436779469491ULL,
		13299057312048130027ULL, 11902517844278924581ULL } }, { {
		17342622943001499427ULL, 15156180883622301085ULL,
		14362028954478864574ULL, 13943374929801415937ULL,
		2638515060305358442ULL, 12178226239043075253ULL,
		8756018852674298389ULL, 6501775982426769645ULL,
		17409372839716123108ULL, 11469342961282695911ULL,
		8088508674128260457ULL, 2829448500005546747ULL, 833072580107964995ULL,
		2746647813575405423ULL, 916783952718351302ULL, 15521102238738323289ULL,
		8498336004633694784ULL, 16028769552829086230ULL,
		5061779344034871544ULL, 12463080314137546062ULL,
		17951590900990491876ULL, 13382209899052343936ULL,
		15699875261015501729ULL, 9591554513710255110ULL, 745637404309085106ULL,
		7423488478960241585ULL, 3399581060223405374ULL, 6189238303339591539ULL,
		2968577575282346587ULL, 17609476189752597861ULL,
		6419747746202469853ULL, 18045365537175121933ULL,
		14616584706980953885ULL, 15880957346354417810ULL,
		4060525135993799366ULL, 12249567891414217990ULL,
		3450711511367158318ULL, 5418411497932587015ULL,
		13086311984475852007ULL, 3521983148630832926ULL,
		3500615175033441281ULL, 5269167627133596048ULL, 143110855003410742ULL,
		16029682932730312434ULL, 2738398903214781014ULL,
		6405787667532549454ULL, 16707066964265439033ULL,
		17351530050452683103ULL, 9589948137846163337ULL,
		5479712820840866824ULL, 4936931391338171440ULL, 2708930543342828921ULL,
		7997291719489983096ULL, 9487951757253073162ULL, 9647478929207234160ULL,
		14496441518930724047ULL, 3949753325944552764ULL,
		7485495307091879222ULL, 10502410665562304595ULL,
		7713626592190192916ULL, 7697461132068230617ULL,
		15119084962731389795ULL, 6180142186674524337ULL,
		7625031631685953268ULL, 11024871281718891954ULL,
		10821366968558508962ULL, 12360291565721399836ULL,
		16686903606357474692ULL, 4897245480555456109ULL,
		3323813415788218382ULL, 15431420454889922623ULL,
		14091140306820777295ULL, 7334746074983640227ULL,
		13386635530976262883ULL, 8393056668705576327ULL,
		12922428083335442846ULL, 10490053774844397610ULL,
		4053450720758620947ULL, 9453341768601562189ULL, 5276576725659159035ULL,
		12366215537648134889ULL, 15201545583437957459ULL,
		2945655582643254666ULL, 8540466774461540628ULL,
		18329571205791271759ULL, 12829142765714308294ULL,
		3756459879611463639ULL, 16527518512218620346ULL,
		16719586540530533729ULL, 18333818816300815289ULL,
		10485752071148620997ULL, 14703266968717239448ULL,
		756668274855658623ULL, 15724791729202074678ULL,
		10083448954610435108ULL, 13003379313978724312ULL,
		15379702073284272574ULL, 13435093654999479671ULL,
		14580709453032739394ULL, 12352526554638233839ULL,
		14405531896575482492ULL, 2336131147567826713ULL,
		3126830326162722399ULL, 2218034867687809295ULL, 9529578453927019775ULL,
		12815576305024414140ULL, 12565544076319290089ULL,
		978071401672948536ULL, 104564098814283752ULL, 4413972170542915993ULL,
		16140101602983089161ULL, 5590767942983418579ULL,
		14592924922423500617ULL, 358457924353809616ULL,
		10731937920183444987ULL, 7377337099212692037ULL,
		7276119206773243219ULL, 876263299176509881ULL, 18288421629487585194ULL,
		14036439904208269331ULL }, { 2396058051082795618ULL,
		13471167791766581423ULL, 16375496227477160808ULL,
		11356595946651735179ULL, 14606915566259690855ULL,
		14920822876784766696ULL, 7939410636570810062ULL,
		10528961277068177286ULL, 16194258502511855317ULL,
		6823732013879206911ULL, 595245704162527222ULL, 16840428881817822527ULL,
		1066257973954688012ULL, 7556306384489029528ULL, 4815233335207794857ULL,
		3682979156954859906ULL, 2186366125197941293ULL, 4852043401620924594ULL,
		2597631740327780480ULL, 16509977160371672683ULL, 682559788163893988ULL,
		18315921604163507915ULL, 15676624785904806694ULL,
		7205063087533414138ULL, 16603972329408494842ULL,
		6757618925846698250ULL, 15918737442990789296ULL,
		15710219520571768493ULL, 13093585058856574496ULL,
		15785682989706468012ULL, 2821623552460796367ULL,
		8613995591053374415ULL, 6635652296359598359ULL, 1081647895398065470ULL,
		7571026526336710248ULL, 12091479676465029081ULL,
		13376775892523676119ULL, 15356170055109195246ULL,
		14418249624339711899ULL, 7417367569000607975ULL,
		4264904603491175856ULL, 10403548446139132446ULL,
		1182440439304074655ULL, 12338062073178192936ULL,
		17320227185118794011ULL, 17934099245896762987ULL,
		8913951533573316258ULL, 11426392975847586007ULL,
		6296731437819917045ULL, 3085575191929238452ULL, 9381580788031286504ULL,
		2980978748516633113ULL, 8421708424143435820ULL,
		16819513551707010377ULL, 18432475792307247482ULL,
		12273936367141871060ULL, 18386545023521882577ULL,
		13874064749590667182ULL, 4425074070300069204ULL,
		3239723622732795462ULL, 2394620266912592447ULL,
		18045632519384996754ULL, 14186683186491102067ULL,
		11382888739338988070ULL, 6229668069587694125ULL,
		6759610279761927577ULL, 11222259988065132649ULL,
		3463027054055207855ULL, 16289609064517379230ULL,
		13307340086449891452ULL, 14126043789674442170ULL,
		17582102736512727389ULL, 5127848924952894768ULL,
		10109974980943791984ULL, 6799758135109672153ULL,
		12129646839378323833ULL, 6099752908431352153ULL,
		3163755831274681097ULL, 3346056261603517612ULL,
		12909465156286309609ULL, 17874743584665963041ULL, 9963178948217030ULL,
		2952398822856100789ULL, 16507083712179188562ULL,
		6804616283065198403ULL, 13615772756870954848ULL,
		2340988798217408699ULL, 9130971569085198392ULL,
		17495253846182034807ULL, 12055608119783591635ULL,
		2999791688405008029ULL, 16807110962995200009ULL,
		17006502098104364969ULL, 1934357519442617171ULL, 194520367982993572ULL,
		18078979325528163675ULL, 11267220564098575408ULL,
		15449898428037460950ULL, 5919007215592593239ULL,
		1115784628400771833ULL, 13692362739127246340ULL,
		11923548013390758958ULL, 15614340631117318412ULL,
		6867699005063793362ULL, 1445833923329405104ULL,
		16544764746451241858ULL, 5424070271036289254ULL,
		7734067583883638898ULL, 17423575175368649883ULL,
		14386713927014983926ULL, 6554376141062655198ULL,
		17642511755337013503ULL, 10328900012967677177ULL,
		11631863677643410977ULL, 5478028168344196388ULL,
		8652796350040409906ULL, 5432787800869956783ULL, 7067042773331491054ULL,
		5471286612692007715ULL, 3623859561793376921ULL } }, { {
		8545354249702107762ULL, 6114286133133791347ULL, 7665419748457857921ULL,
		771055935051227338ULL, 14851667801211233874ULL,
		10266920090154585412ULL, 11744331932913112691ULL,
		6466757608467841304ULL, 8073690246589933772ULL,
		15499009182699201581ULL, 756001009665636761ULL,
		13514892066184525858ULL, 5688733969430167140ULL,
		10077848738139000885ULL, 7837040060206655427ULL,
		14702747695076987262ULL, 14086773313897479145ULL,
		16825389919303076868ULL, 9275814003613255896ULL,
		12913683117410044872ULL, 4443025163149818547ULL,
		13571695740276984217ULL, 9136125467619561107ULL,
		12435307674105250505ULL, 17660683274325482599ULL,
		5051283211641369207ULL, 11341124847859682335ULL,
		15800061972472177093ULL, 17848140619644917941ULL,
		1438535119947774251ULL, 16668713405621867096ULL, 464697071109918491ULL,
		14589922556063155622ULL, 10360254596815884879ULL,
		1620467048922612695ULL, 12007021594642066845ULL,
		7724168621533131090ULL, 13750752894276483160ULL,
		16387582839987574580ULL, 10733037133657235010ULL, 26563480919521794ULL,
		17335573043716912447ULL, 7623579990663254623ULL,
		7245295470947003978ULL, 15593371162636986602ULL,
		13460495043233574800ULL, 8085540813787023638ULL,
		16504861013155754267ULL, 8330294664725242891ULL,
		16144368662558923056ULL, 1572575246070947023ULL,
		13757836776849426175ULL, 17799824878189614935ULL,
		5596043953397525801ULL, 15961147054974567198ULL, 67697129924317489ULL,
		1495092464164437569ULL, 2359728605913229984ULL, 1842622735847803577ULL,
		14149678771234954554ULL, 5264380797863842391ULL,
		13953941344949922605ULL, 8388038059689876769ULL,
		2955562174895817792ULL, 18129249587152574897ULL,
		6081114090812502234ULL, 18072906095674043755ULL,
		16925019298458634399ULL, 10033498658488447580ULL,
		4680040248337212740ULL, 4330143123913566772ULL,
		14308618555218737141ULL, 4084828596262733119ULL,
		4485331545478590837ULL, 7244609567441047364ULL, 5790634565535554297ULL,
		424134941013042422ULL, 10339557669604796746ULL,
		10365298759978709126ULL, 6481930236799144065ULL,
		18273440563006340975ULL, 4940103786031247235ULL,
		12111600101020704324ULL, 18202171203518169251ULL,
		951251633369715690ULL, 2988063327511213162ULL, 978906986097134076ULL,
		14185582509454756660ULL, 16301259579365573228ULL,
		12172421129809162535ULL, 11737499212969651375ULL,
		16145807660564821634ULL, 14606308895997467507ULL,
		8393656056764876909ULL, 1415750679887573384ULL, 1531293070517878799ULL,
		11908666255869003218ULL, 877425413289050666ULL,
		15653632765385768613ULL, 4880474800328042583ULL,
		12745968793689474965ULL, 4212306451634898567ULL,
		15000683418801343977ULL, 5165720652394323946ULL,
		14576714197387794737ULL, 5715661537700225678ULL,
		16493623487875010385ULL, 11708619125401294278ULL,
		5198471133839113674ULL, 599380307240923370ULL, 5642456264922156122ULL,
		17581934475831558859ULL, 6033056327533708723ULL,
		1611230012053531349ULL, 9885023315539812451ULL, 9491399132714582858ULL,
		17463645483172642557ULL, 13168119502336692960ULL,
		2071402497817890200ULL, 6327644375626475127ULL }, {
		237992316313154277ULL, 9789249984977037365ULL, 669582961508745588ULL,
		9456285559962142052ULL, 3257579473051166340ULL,
		14830205860287651363ULL, 3960562973863916457ULL,
		16974819372390958638ULL, 7040772486929187604ULL,
		3928449855912563517ULL, 5264614611929919227ULL,
		16730691349113488074ULL, 5938924893533303453ULL,
		4304379627200201771ULL, 7756197632631786114ULL,
		16899410122001864171ULL, 18157666522655017624ULL,
		14459459354549962483ULL, 1915277220517036661ULL,
		12921308800701497296ULL, 15379353919693298780ULL,
		5446580008072325098ULL, 14810038343035754930ULL,
		15943000758104051878ULL, 15908651295699315129ULL,
		10215541716194073827ULL, 9924294374475643055ULL,
		8673760783601782832ULL, 5227059081492064981ULL, 7245879321451002327ULL,
		725136657237543915ULL, 17793228471702184257ULL,
		11501181771076620745ULL, 7446518838416426636ULL,
		6018917265507688295ULL, 17114185770495248545ULL,
		10622404482762054619ULL, 5359103713096985364ULL,
		7915829853307401203ULL, 1295229687897770710ULL,
		12454018708848283970ULL, 14945491727363715852ULL,
		1877718522750393459ULL, 17294393783053623329ULL,
		7772253544331613100ULL, 5136409600752958816ULL, 8381920317272517917ULL,
		400208854838836409ULL, 6714338879647613407ULL, 2776440837160621695ULL,
		5392938728147689453ULL, 11868833320145918536ULL,
		16279890438210998779ULL, 12844756987452600922ULL,
		15458472537039198873ULL, 9145220262061931035ULL,
		12359585095498056814ULL, 1095371354466081046ULL,
		14721796802064974674ULL, 16146855339468488249ULL,
		17612998062389382949ULL, 8781807061722671031ULL,
		1806351979614926187ULL, 8942736696926989884ULL,
		15724692454047190019ULL, 4120976459188978725ULL,
		2935639997458972787ULL, 12142975940377586906ULL, 811192625678856631ULL,
		4725840035302023146ULL, 9546909342582761355ULL,
		15147167813439095354ULL, 2474679654286869707ULL,
		9631738841173176525ULL, 16854709180585347722ULL,
		8169717475786561503ULL, 9078975863885379781ULL,
		11239491725596284532ULL, 11656538251551847185ULL,
		9347405657814301679ULL, 9026893706223532103ULL, 6690623163867567295ULL,
		7812582690416916857ULL, 13554977050668051990ULL,
		10973198396666411580ULL, 3695818164351558579ULL,
		3855971104373409592ULL, 1443711631702639453ULL,
		11139856454966969215ULL, 7829597397974860432ULL,
		10457089298674238770ULL, 18088500374343339964ULL,
		17472251608480637240ULL, 366609905487869259ULL, 2807496603409841066ULL,
		11429673518851620420ULL, 7102362695540288075ULL,
		6093707118116440281ULL, 16412806385466849235ULL,
		1713945935248226077ULL, 4488028135005706483ULL,
		10736562452003732437ULL, 9924665493570997963ULL,
		2000240282706770015ULL, 3538555968456007890ULL, 5297641446412262807ULL,
		1189762698059398314ULL, 12435573430938212590ULL,
		7360707355754707197ULL, 16272306281023595525ULL,
		1640708495943247363ULL, 16525357815223047791ULL,
		9398003508521300863ULL, 8584000370174393683ULL, 1458886507302967056ULL,
		3741996440568087129ULL, 18217395538163497215ULL,
		18143691811922319720ULL, 16235134896566797619ULL,
		9175452688547103146ULL } } };
unsigned long long Zobrist::wCastlingRights[4] = { 17363731140687555519ULL,
		18044768215054674627ULL, 10113286798862278581ULL,
		11653288333699715126ULL };
unsigned long long
		Zobrist::bCastlingRights[4] = { 6083778184881865624ULL,
				6767058732826959245ULL, 5691195672070719405ULL,
				4283603127980928432ULL };
unsigned long long Zobrist::enPassant[120] = { 1152413559318253490ULL,
		4503427277470447098ULL, 14229110007964551188ULL,
		11865947041373542828ULL, 7400807970287231228ULL,
		9794639299655612497ULL, 6858916429265986887ULL, 2227409659506738211ULL,
		14608846731294480372ULL, 17427992348672492409ULL,
		6276224488933759968ULL, 3573006830106248054ULL, 8554542032658244776ULL,
		17585843255517141963ULL, 17249203110029883075ULL,
		12227747326994127957ULL, 7501855002706770716ULL,
		13398558948845412965ULL, 14752139883208562821ULL,
		6657168480942452708ULL, 2107681636579916541ULL, 208687714090014490ULL,
		5843484982053488334ULL, 11459031377058611253ULL,
		13034409175039462528ULL, 14784966802998044524ULL,
		10544372239454709338ULL, 8908839317155929768ULL,
		12243221251171714210ULL, 17203962742911172205ULL,
		9256828403302282025ULL, 2519249767533931388ULL,
		16994944716741671438ULL, 15829091135563780767ULL,
		2713372925314477691ULL, 1211442419223931377ULL, 4579483671505053091ULL,
		9459068597816929380ULL, 428148626515297964ULL, 14218931525961679654ULL,
		10423672217452222813ULL, 13097238908496065268ULL,
		5674185960207825565ULL, 10727894507972664314ULL,
		17392990584709790470ULL, 5543403858887344030ULL,
		17559716704940914682ULL, 3699460623221754870ULL,
		3066575580230865176ULL, 10777341827452397353ULL,
		10897770049806687029ULL, 1751999024269385325ULL,
		9004119830555682057ULL, 4249321036171610111ULL,
		13898003402510386615ULL, 6076298518762049563ULL,
		6856520790922925600ULL, 16356512255398423497ULL,
		8660365532281328565ULL, 13981063034463007233ULL,
		6006602871032377703ULL, 758293677655627153ULL, 16013776205206287329ULL,
		13639532675202205323ULL, 2752297428475306644ULL,
		9774416648113763245ULL, 1379555172409170765ULL, 2623786791723131957ULL,
		4337010593470625352ULL, 14321237308586208353ULL,
		16129326854207570091ULL, 9364393985760173963ULL,
		15749935338144872448ULL, 189455578056641342ULL, 6533479810584769970ULL,
		5343135317342489766ULL, 5930108256597237157ULL, 2376286812202293428ULL,
		18024932047180636457ULL, 2288108704306313135ULL,
		6201730119636024642ULL, 8331853776964565959ULL,
		16525109418033991218ULL, 14297582468778293459ULL,
		3811734596144982345ULL, 568383224465315051ULL, 10850694212738989498ULL,
		10638136231214983879ULL, 11692986629740029588ULL,
		12806465976816349880ULL, 7344051033678682538ULL,
		2982382710316071178ULL, 13351591803893576962ULL,
		3579307295425082119ULL, 500543459611396461ULL, 3513775339765792820ULL,
		6910552625402503699ULL, 11080737845353144540ULL,
		12373054944615714453ULL, 428959420050929033ULL, 9075640393597745423ULL,
		15323002473480926890ULL, 15301582758276626588ULL,
		3382809051628627547ULL, 12287575638970759572ULL,
		10388217330202225862ULL, 2427738163418475285ULL,
		13579867886221416145ULL, 73704902954204856ULL, 8771515682954240975ULL,
		17931855671845060613ULL, 5893423696184501714ULL,
		8410655836427770521ULL, 16025821678049977021ULL,
		15889979920203325333ULL, 7833774249192013003ULL,
		10126632171388431436ULL, 10101675635043400892ULL,
		13581179610982249337ULL, 13665963370457243906ULL };
unsigned long long Zobrist::side = 9432228469085594402ULL;

unsigned long long Zobrist::getPawnZobristKey(Board* board) {
	long zobristKey = 0;

	for (int index = 0; index < 120; index++) {
		if ((index & 0x88) == 0) {
			int piece = board -> board0x88[index];

			if (piece == W_PAWN) {
				zobristKey ^= pieces[abs(piece) - 1][0][index];
			} else if (piece == B_PAWN) {
				zobristKey ^= pieces[abs(piece) - 1][1][index];
			}
		} else
			index += 7;
	}

	return zobristKey;
}

unsigned long long Zobrist::getZobristKey(Board* board) {
	unsigned long long zobristKey = 0;

	for (int index = 0; index < 120; index++) {
		if ((index & 0x88) == 0) {
			int piece = board -> board0x88[index];

			if (piece > 0) { // white
				zobristKey ^= pieces[abs(piece) - 1][0][index];
			} else if (piece < 0) { // black
				zobristKey ^= pieces[abs(piece) - 1][1][index];
			}
		} else
			index += 7;
	}

	zobristKey ^= wCastlingRights[board -> whiteCastle];
	zobristKey ^= bCastlingRights[board -> blackCastle];

	if (board -> enPassant != -1)
		zobristKey ^= enPassant[board -> enPassant];

	if (board -> toMove == -1)
		zobristKey ^= side;

	return zobristKey;
}
