/*
 * Copyright (C) 2010 František Hejl
 *
 * This file is part of Chesswalk.
 *
 * Chesswalk is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Chesswalk is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "definitions.h"
#include "Board.h"
#ifndef EVALUATION_H_
#define EVALUATION_H_

const int B_PAWN_POS[] = { -15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0,
		0, -15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 5,
		5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 15, 15, 0, -5, -15,
		0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 25, 25, 0, -5, -15, 0, 0, 0, 0, 0,
		0, 0, 0, -15, -5, 0, 15, 15, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15,
		-5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 5, 5, 0,
		-5, -15, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_PAWN_POS[] = { -15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0,
		0, -15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0,
		15, 15, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 25, 25, 0, -5,
		-15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 15, 15, 0, -5, -15, 0, 0, 0,
		0, 0, 0, 0, 0, -15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0,
		-15, -5, 0, 5, 5, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -15, -5, 0, 5, 5,
		0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0 };

const int B_PAWN_POS_ENDING[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_PAWN_POS_ENDING[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_KNIGHT_POS[] = { -50, -40, -30, -25, -25, -30, -40, -50, 0, 0, 0,
		0, 0, 0, 0, 0, -35, -25, -15, -10, -10, -15, -25, -35, 0, 0, 0, 0, 0,
		0, 0, 0, -20, -10, 0, 5, 5, 0, -10, -20, 0, 0, 0, 0, 0, 0, 0, 0, -10,
		0, 10, 15, 15, 10, 0, -10, 0, 0, 0, 0, 0, 0, 0, 0, -5, 5, 15, 20, 20,
		15, 5, -5, 0, 0, 0, 0, 0, 0, 0, 0, -5, 5, 15, 20, 20, 15, 5, -5, 0, 0,
		0, 0, 0, 0, 0, 0, -20, -10, 0, 5, 5, 0, -10, -20, 0, 0, 0, 0, 0, 0, 0,
		0, -135, -25, -15, -10, -10, -15, -25, -135, 0, 0, 0, 0, 0, 0, 0, 0 };

const int B_KNIGHT_POS[] = { -135, -25, -15, -10, -10, -15, -25, -135, 0, 0, 0,
		0, 0, 0, 0, 0, -20, -10, 0, 5, 5, 0, -10, -20, 0, 0, 0, 0, 0, 0, 0, 0,
		-5, 5, 15, 20, 20, 15, 5, -5, 0, 0, 0, 0, 0, 0, 0, 0, -5, 5, 15, 20,
		20, 15, 5, -5, 0, 0, 0, 0, 0, 0, 0, 0, -10, 0, 10, 15, 15, 10, 0, -10,
		0, 0, 0, 0, 0, 0, 0, 0, -20, -10, 0, 5, 5, 0, -10, -20, 0, 0, 0, 0, 0,
		0, 0, 0, -35, -25, -15, -10, -10, -15, -25, -35, 0, 0, 0, 0, 0, 0, 0,
		0, -50, -40, -30, -25, -25, -30, -40, -50, 0, 0, 0, 0, 0, 0, 0, 0 };

const int KNIGHT_POS_ENDING[] = { -10, -5, -5, -5, -5, -5, -5, -10, 0, 0, 0, 0,
		0, 0, 0, 0, -5, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, 5,
		5, 5, 5, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, 5, 10, 10, 5, 0, -5, 0,
		0, 0, 0, 0, 0, 0, 0, -5, 0, 5, 10, 10, 5, 0, -5, 0, 0, 0, 0, 0, 0, 0,
		0, -5, 0, 5, 5, 5, 5, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0, 0, 0,
		0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -10, -5, -5, -5, -5, -5, -5, -10, 0, 0,
		0, 0, 0, 0, 0, 0 };
const int W_BISHOP_POS[] = { -20, -15, -15, -13, -13, -15, -15, -20, 0, 0, 0,
		0, 0, 0, 0, 0, -5, 0, -5, 0, 0, -5, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -6,
		-2, 4, 2, 2, 4, -2, -6, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, 2, 10, 10, 2, 0,
		-4, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, 2, 10, 10, 2, 0, -4, 0, 0, 0, 0, 0,
		0, 0, 0, -6, -2, 4, 2, 2, 4, -2, -6, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, -2,
		0, 0, -2, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -8, -8, -6, -4, -4, -6, -8,
		-8, 0, 0, 0, 0, 0, 0, 0, 0 };

const int B_BISHOP_POS[] = { -8, -8, -6, -4, -4, -6, -8, -8, 0, 0, 0, 0, 0, 0,
		0, 0, -5, 0, -2, 0, 0, -2, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -6, -2, 4, 2,
		2, 4, -2, -6, 0, 0, 0, 0, 0, 0, 0, 0, -4, 0, 2, 10, 10, 2, 0, -4, 0, 0,
		0, 0, 0, 0, 0, 0, -4, 0, 2, 10, 10, 2, 0, -4, 0, 0, 0, 0, 0, 0, 0, 0,
		-6, -2, 4, 2, 2, 4, -2, -6, 0, 0, 0, 0, 0, 0, 0, 0, -5, 0, -5, 0, 0,
		-5, 0, -5, 0, 0, 0, 0, 0, 0, 0, 0, -20, -15, -15, -13, -13, -15, -15,
		-20, 0, 0, 0, 0, 0, 0, 0, 0 };

const int BISHOP_POS_ENDING[] = { -18, -12, -9, -6, -6, -9, -12, -18, 0, 0, 0,
		0, 0, 0, 0, 0, -12, -6, -3, 0, 0, -3, -6, -12, 0, 0, 0, 0, 0, 0, 0, 0,
		-9, -3, 0, 3, 3, 0, -3, -9, 0, 0, 0, 0, 0, 0, 0, 0, -6, 0, 3, 6, 6, 3,
		0, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, 0, 3, 6, 6, 3, 0, -6, 0, 0, 0, 0, 0,
		0, 0, 0, -9, -3, 0, 3, 3, 0, -3, -9, 0, 0, 0, 0, 0, 0, 0, 0, -12, -6,
		-3, 0, 0, -3, -6, -12, 0, 0, 0, 0, 0, 0, 0, 0, -18, -12, -9, -6, -6,
		-9, -12, -18, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_ROOK_POS[] = { -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0,
		-6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0,
		-3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0,
		0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3,
		0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6,
		0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0,
		0, 0 };

const int B_ROOK_POS[] = { -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0,
		-6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0,
		-3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0,
		0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3,
		0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6,
		0, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0, 3, 3, 0, -3, -6, 0, 0, 0, 0, 0, 0,
		0, 0 };

const int ROOK_POS_ENDING[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_QUEEN_POS[] = { -10, -10, -10, -10, -10, -10, -10, -10, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

const int B_QUEEN_POS[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		-10, -10, -10, -10, -10, -10, -10, -10, 0, 0, 0, 0, 0, 0, 0, 0 };

const int QUEEN_POS_ENDING[] = { -24, -16, -12, -8, -8, -12, -16, -24, 0, 0, 0,
		0, 0, 0, 0, 0, -16, -8, -4, 0, 0, -4, -8, -16, 0, 0, 0, 0, 0, 0, 0, 0,
		-12, -4, 0, 4, 4, 0, -4, -12, 0, 0, 0, 0, 0, 0, 0, 0, -8, 0, 4, 8, 8,
		4, 0, -8, 0, 0, 0, 0, 0, 0, 0, 0, -8, 0, 4, 8, 8, 4, 0, -8, 0, 0, 0, 0,
		0, 0, 0, 0, -12, -4, 0, 4, 4, 0, -4, -12, 0, 0, 0, 0, 0, 0, 0, 0, -16,
		-8, -4, 0, 0, -4, -8, -16, 0, 0, 0, 0, 0, 0, 0, 0, -24, -16, -12, -8,
		-8, -12, -16, -24, 0, 0, 0, 0, 0, 0, 0, 0 };

const int W_KING_POS[] = { 10, 20, 0, 0, 0, 10, 20, 10, 0, 0, 0, 0, 0, 0, 0, 0,
		10, 15, 0, 0, 0, 0, 15, 10, 0, 0, 0, 0, 0, 0, 0, 0, -10, -20, -20, -25,
		-25, -20, -20, -10, 0, 0, 0, 0, 0, 0, 0, 0, -15, -25, -40, -40, -40,
		-40, -25, -15, 0, 0, 0, 0, 0, 0, 0, 0, -30, -40, -40, -40, -40, -40,
		-40, -30, 0, 0, 0, 0, 0, 0, 0, 0, -40, -50, -50, -50, -50, -50, -50,
		-40, 0, 0, 0, 0, 0, 0, 0, 0, -50, -50, -50, -50, -50, -50, -50, -50, 0,
		0, 0, 0, 0, 0, 0, 0, -50, -50, -50, -50, -50, -50, -50, -50, 0, 0, 0,
		0, 0, 0, 0, 0 };

const int B_KING_POS[] = { -50, -50, -50, -50, -50, -50, -50, -50, 0, 0, 0, 0,
		0, 0, 0, 0, -50, -50, -50, -50, -50, -50, -50, -50, 0, 0, 0, 0, 0, 0,
		0, 0, -40, -50, -50, -50, -50, -50, -50, -40, 0, 0, 0, 0, 0, 0, 0, 0,
		-30, -40, -40, -40, -40, -40, -40, -30, 0, 0, 0, 0, 0, 0, 0, 0, -15,
		-25, -40, -40, -40, -40, -25, -15, 0, 0, 0, 0, 0, 0, 0, 0, -10, -20,
		-20, -25, -25, -20, -20, -10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 15, 0, 0, 0,
		0, 15, 10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 20, 0, 0, 0, 10, 20, 10, 0, 0,
		0, 0, 0, 0, 0, 0 };

const int KING_POS_ENDING[] = { -20, -15, -10, -10, -10, -10, -15, -20, 0, 0,
		0, 0, 0, 0, 0, 0, -15, -5, 0, 0, 0, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0,
		-10, 0, 5, 5, 5, 5, 0, -10, 0, 0, 0, 0, 0, 0, 0, 0, -10, 0, 5, 10, 10,
		5, 0, -10, 0, 0, 0, 0, 0, 0, 0, 0, -10, 0, 5, 10, 10, 5, 0, -10, 0, 0,
		0, 0, 0, 0, 0, 0, -10, 0, 5, 5, 5, 5, 0, -10, 0, 0, 0, 0, 0, 0, 0, 0,
		-15, -5, 0, 0, 0, 0, -5, -15, 0, 0, 0, 0, 0, 0, 0, 0, -20, -15, -10,
		-10, -10, -10, -10, -20, 0, 0, 0, 0, 0, 0, 0, 0 };

const int PIECE_VALUE_ARRAY[] = { 0, // Not used
		-PAWN_VALUE, // Black pawn
		-KNIGHT_VALUE, // Black knight
		-BISHOP_VALUE, // Black bishop
		-ROOK_VALUE, // Black rook
		-QUEEN_VALUE, // Black queen
		0, // Black king
		0, // Empty square
		0, // White king
		QUEEN_VALUE, // White queen
		ROOK_VALUE, // White rook
		BISHOP_VALUE, // White bishop
		KNIGHT_VALUE, // White knight
		PAWN_VALUE }; // White pawn

class Evaluation {
public:
	static int getGamePhase(Board* board);
	static int evaluate(Board* board, int* moves, int movesSize);
	static int material(Board* board, int side);
};

#endif /* EVALUATION_H_ */
