package cz.jirkovsky.lukas.chmupocasi.forecast;

import junit.framework.TestCase;

/**
 * Tests for the WeatherFeatures.
 */
public class WeatherFeaturesTest extends TestCase {
    private static double EPS = 0.0001;

    /**
     * Tests for crashes caused by unhandled exceptions
     */
    public void testExceptions() {
        WeatherFeatures features;

        // incomplete text
        features = new WeatherFeatures("míst");
        // issue #5 (a keyword is the last word in the forecast)
        features = new WeatherFeatures("místy");
    }

    /**
     * Test for parser itself
     */
    public void testParsing() {
        WeatherFeatures features;

        features = new WeatherFeatures("Skoro jasno.");
        assertEquals(0.1875, features.getCloudCover(), EPS);

        features = new WeatherFeatures("Oblačno až zataženo, místy déšť nebo přeháňky. Odpoledne od severozápadu ustávání srážek a ubývání oblačnosti.");
        assertEquals(0.7182421875, features.getCloudCover(), EPS);
        assertEquals(0.298, features.getRain(), EPS);
        assertEquals(0.298, features.getShowers(), EPS);
        assertEquals(0.0, features.getStorm(), EPS);
        assertEquals(0.0, features.getSnow(), EPS);
    }
}
