/*
 *   Copyright 2013 Lukas Jirkovsky
 *
 *   This file is part of Počasí v krajích.
 *
 *   Počasí v krajích is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, version 3 of the License.
 *
 *   Počasí v krajích is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Počasí v krajích.  If not, see <http://www.gnu.org/licenses/>.
 */

package cz.jirkovsky.lukas.chmupocasi.forecast;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import cz.jirkovsky.lukas.chmupocasi.R;

/**
 * Represents forecast for one day.
 *
 * The forecast may also include situation, but it is not mandatory.
 */
public class DayForecast implements Serializable {
    private final Days matchingDay;
    private Date date;
    private String situation;
    private String forecast;
    private WeatherFeatures features;

    public enum Days {
        UNKNOWN(R.string.day_unknown, -1),

        NIGHT(R.string.day_night, -1),

        Mon(R.string.day_mon, Calendar.MONDAY),
        Tue(R.string.day_tue, Calendar.TUESDAY),
        Wed(R.string.day_wed, Calendar.WEDNESDAY),
        Thu(R.string.day_thu, Calendar.THURSDAY),
        Fri(R.string.day_fri, Calendar.FRIDAY),
        Sat(R.string.day_sat, Calendar.SATURDAY),
        Sun(R.string.day_sun, Calendar.SUNDAY);

        Days(int name, int calendarDay) {
            this.name = name;
            this.calendarDay = calendarDay;
        }

        public int getName() {
            return name;
        }

        public int getCalendarDay() {
            return calendarDay;
        }

        private final int name;
        private final int calendarDay;
    }

    public DayForecast(Days matchingDay) {
        this.matchingDay = matchingDay;
        features = null;
    }

    public Days getMatchingDay() {
        return matchingDay;
    }

    public int getName() {
        return matchingDay.getName();
    }

    /** Get a date corresponding to the forecast.
     *
     * @return null if the matching day is not known or if it is night
     */
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getSituation() {
        return situation;
    }

    public void setSituation(String situation) {
        this.situation = situation.trim();
    }

    public String getForecast() {
        return forecast;
    }

    public void setForecast(String forecast) {
        this.forecast = forecast.trim();
    }

    public synchronized WeatherFeatures getFeatures() {
        // lazy initialization
        if (features == null) {
            features = new WeatherFeatures(forecast);
        }
        return features;
    }
}
