/*
 * Copyright (C) 2014, The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LATINIME_NGRAM_LISTENER_H
#define LATINIME_NGRAM_LISTENER_H

#include "defines.h"

namespace latinime {

/**
 * Interface to iterate ngram entries.
 */
class NgramListener {
 public:
    // ngramProbability is always 0 for v403 decaying dictionary.
    // TODO: Remove ngramProbability.
    virtual void onVisitEntry(const int ngramProbability, const int targetWordId) = 0;
    virtual ~NgramListener() {};

 protected:
    NgramListener() {}

 private:
    DISALLOW_COPY_AND_ASSIGN(NgramListener);

};
} // namespace latinime
#endif /* LATINIME_NGRAM_LISTENER_H */
