/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import java.util.HashMap;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CordovaChromeClient;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.LinearLayoutSoftKeyboardDetect;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.IPlugin;
import org.apache.cordova.api.LOG;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroidGap
extends Activity
implements CordovaInterface {
    public static String TAG = "DroidGap";
    protected CordovaWebView appView;
    protected CordovaWebViewClient webViewClient;
    protected LinearLayout root;
    protected boolean cancelLoadUrl = false;
    protected ProgressDialog spinnerDialog = null;
    private static int ACTIVITY_STARTING = 0;
    private static int ACTIVITY_RUNNING = 1;
    private static int ACTIVITY_EXITING = 2;
    private int activityState = 0;
    String baseUrl = null;
    protected IPlugin activityResultCallback = null;
    protected boolean activityResultKeepRunning;
    private int backgroundColor = -16777216;
    protected int splashscreen = 0;
    protected int splashscreenTime = 0;
    protected int loadUrlTimeoutValue = 20000;
    protected boolean keepRunning = true;
    protected Dialog splashDialog;

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            this.appView.viewClient.setAuthenticationToken(authenticationToken, host, realm);
        }
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            return this.appView.viewClient.removeAuthenticationToken(host, realm);
        }
        return null;
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        if (this.appView != null && this.appView.viewClient != null) {
            return this.appView.viewClient.getAuthenticationToken(host, realm);
        }
        return null;
    }

    public void clearAuthenticationTokens() {
        if (this.appView != null && this.appView.viewClient != null) {
            this.appView.viewClient.clearAuthenticationTokens();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        LOG.d(TAG, "DroidGap.onCreate()");
        super.onCreate(savedInstanceState);
        if (!this.getBooleanProperty("showTitle", false)) {
            this.getWindow().requestFeature(1);
        }
        if (this.getBooleanProperty("setFullscreen", false)) {
            this.getWindow().setFlags(1024, 1024);
        } else {
            this.getWindow().setFlags(2048, 2048);
        }
        Display display = this.getWindowManager().getDefaultDisplay();
        int width = display.getWidth();
        int height = display.getHeight();
        this.root = new LinearLayoutSoftKeyboardDetect((Context)this, width, height);
        this.root.setOrientation(1);
        this.root.setBackgroundColor(this.backgroundColor);
        this.root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
        this.setVolumeControlStream(3);
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    public void init() {
        CordovaWebView webView = new CordovaWebView((Context)this);
        this.init(webView, new CordovaWebViewClient(this, webView), new CordovaChromeClient(this, webView));
    }

    public void init(CordovaWebView webView, CordovaWebViewClient webViewClient, CordovaChromeClient webChromeClient) {
        LOG.d(TAG, "DroidGap.init()");
        this.appView = webView;
        this.appView.setId(100);
        this.appView.setWebViewClient(webViewClient);
        this.appView.setWebChromeClient(webChromeClient);
        webViewClient.setWebView(this.appView);
        webChromeClient.setWebView(this.appView);
        this.appView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        this.appView.setVisibility(4);
        this.root.addView((View)this.appView);
        this.setContentView((View)this.root);
        this.cancelLoadUrl = false;
    }

    public void loadUrl(String url) {
        if (this.appView == null) {
            this.init();
        }
        this.backgroundColor = this.getIntegerProperty("backgroundColor", -16777216);
        this.root.setBackgroundColor(this.backgroundColor);
        this.keepRunning = this.getBooleanProperty("keepRunning", true);
        this.loadSpinner();
        this.appView.loadUrl(url);
    }

    void loadSpinner() {
        String loading = null;
        loading = this.appView == null || !this.appView.canGoBack() ? this.getStringProperty("loadingDialog", null) : this.getStringProperty("loadingPageDialog", null);
        if (loading != null) {
            String title = "";
            String message = "Loading Application...";
            if (loading.length() > 0) {
                int comma = loading.indexOf(44);
                if (comma > 0) {
                    title = loading.substring(0, comma);
                    message = loading.substring(comma + 1);
                } else {
                    title = "";
                    message = loading;
                }
            }
            this.spinnerStart(title, message);
        }
    }

    public void loadUrl(String url, int time) {
        if (this.appView == null) {
            this.init();
        }
        this.splashscreenTime = time;
        this.appView.loadUrl(url, time);
    }

    @Override
    @Deprecated
    public void cancelLoadUrl() {
        this.cancelLoadUrl = true;
    }

    public void clearCache() {
        if (this.appView == null) {
            this.init();
        }
        this.appView.clearCache(true);
    }

    public void clearHistory() {
        this.appView.clearHistory();
    }

    public boolean backHistory() {
        if (this.appView != null) {
            return this.appView.backHistory();
        }
        return false;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Boolean p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        try {
            p = (Boolean)bundle.get(name);
        }
        catch (ClassCastException e) {
            String s = bundle.get(name).toString();
            p = "true".equals(s) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        Integer p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        try {
            p = (Integer)bundle.get(name);
        }
        catch (ClassCastException e) {
            p = Integer.parseInt(bundle.get(name).toString());
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public String getStringProperty(String name, String defaultValue) {
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        String p = bundle.getString(name);
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Double p;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle == null) {
            return defaultValue;
        }
        try {
            p = (Double)bundle.get(name);
        }
        catch (ClassCastException e) {
            p = Double.parseDouble(bundle.get(name).toString());
        }
        if (p == null) {
            return defaultValue;
        }
        return p;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.getIntent().putExtra(name, value);
    }

    public void setIntegerProperty(String name, int value) {
        this.getIntent().putExtra(name, value);
    }

    public void setStringProperty(String name, String value) {
        this.getIntent().putExtra(name, value);
    }

    public void setDoubleProperty(String name, double value) {
        this.getIntent().putExtra(name, value);
    }

    protected void onPause() {
        super.onPause();
        if (this.activityState == ACTIVITY_EXITING) {
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.loadUrl("javascript:try{cordova.fireDocumentEvent('pause');}catch(e){console.log('exception firing pause event from native');};");
        if (this.appView.pluginManager != null) {
            this.appView.pluginManager.onPause(this.keepRunning);
        }
        if (!this.keepRunning) {
            this.appView.pauseTimers();
        }
        this.removeSplashScreen();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.appView != null && this.appView.pluginManager != null) {
            this.appView.pluginManager.onNewIntent(intent);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.activityState == ACTIVITY_STARTING) {
            this.activityState = ACTIVITY_RUNNING;
            return;
        }
        if (this.appView == null) {
            return;
        }
        this.appView.loadUrl("javascript:try{cordova.fireDocumentEvent('resume');}catch(e){console.log('exception firing resume event from native');};");
        if (this.appView.pluginManager != null) {
            this.appView.pluginManager.onResume(this.keepRunning || this.activityResultKeepRunning);
        }
        if (!this.keepRunning || this.activityResultKeepRunning) {
            if (this.activityResultKeepRunning) {
                this.keepRunning = this.activityResultKeepRunning;
                this.activityResultKeepRunning = false;
            }
            this.appView.resumeTimers();
        }
    }

    public void onDestroy() {
        LOG.d(TAG, "onDestroy()");
        super.onDestroy();
        this.removeSplashScreen();
        if (this.appView != null) {
            this.appView.loadUrl("javascript:try{cordova.require('cordova/channel').onDestroy.fire();}catch(e){console.log('exception firing destroy event from native');};");
            this.appView.loadUrl("about:blank");
            if (this.appView.pluginManager != null) {
                this.appView.pluginManager.onDestroy();
            }
        } else {
            this.endActivity();
        }
    }

    public void postMessage(String id, Object data) {
        if (this.appView != null) {
            this.appView.postMessage(id, data);
        }
    }

    public void addService(String serviceType, String className) {
        if (this.appView != null && this.appView.pluginManager != null) {
            this.appView.pluginManager.addService(serviceType, className);
        }
    }

    public void sendJavascript(String statement) {
        if (this.appView != null && this.appView.callbackServer != null) {
            this.appView.callbackServer.sendJavascript(statement);
        }
    }

    public void spinnerStart(String title, String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final DroidGap me = this;
        this.spinnerDialog = ProgressDialog.show((Context)this, (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                me.spinnerDialog = null;
            }
        });
    }

    public void spinnerStop() {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public void endActivity() {
        this.activityState = ACTIVITY_EXITING;
        super.finish();
    }

    @Override
    public void startActivityForResult(IPlugin command, Intent intent, int requestCode) {
        this.activityResultCallback = command;
        this.activityResultKeepRunning = this.keepRunning;
        if (command != null) {
            this.keepRunning = false;
        }
        super.startActivityForResult(intent, requestCode);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        IPlugin callback = this.activityResultCallback;
        if (callback != null) {
            callback.onActivityResult(requestCode, resultCode, intent);
        }
    }

    @Override
    public void setActivityResultCallback(IPlugin plugin) {
        this.activityResultCallback = plugin;
    }

    public void onReceivedError(int errorCode, final String description, final String failingUrl) {
        final DroidGap me = this;
        this.spinnerStop();
        final String errorUrl = me.getStringProperty("errorUrl", null);
        if (errorUrl != null && (errorUrl.startsWith("file://") || errorUrl.indexOf(me.baseUrl) == 0 || this.appView.isUrlWhiteListed(errorUrl)) && !failingUrl.equals(errorUrl)) {
            me.runOnUiThread(new Runnable(){

                public void run() {
                    me.appView.showWebPage(errorUrl, false, true, null);
                }
            });
        } else {
            final boolean exit = errorCode != -2;
            me.runOnUiThread(new Runnable(){

                public void run() {
                    if (exit) {
                        me.appView.setVisibility(8);
                        me.displayError("Application Error", description + " (" + failingUrl + ")", "OK", exit);
                    }
                }
            });
        }
    }

    public void displayError(final String title, final String message, final String button, final boolean exit) {
        final DroidGap me = this;
        me.runOnUiThread(new Runnable(){

            public void run() {
                try {
                    AlertDialog.Builder dlg = new AlertDialog.Builder((Context)me);
                    dlg.setMessage((CharSequence)message);
                    dlg.setTitle((CharSequence)title);
                    dlg.setCancelable(false);
                    dlg.setPositiveButton((CharSequence)button, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            if (exit) {
                                me.endActivity();
                            }
                        }
                    });
                    dlg.create();
                    dlg.show();
                }
                catch (Exception e) {
                    DroidGap.this.finish();
                }
            }
        });
    }

    public boolean isUrlWhiteListed(String url) {
        if (this.appView != null) {
            return this.appView.isUrlWhiteListed(url);
        }
        return false;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        this.postMessage("onCreateOptionsMenu", menu);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.postMessage("onPrepareOptionsMenu", menu);
        return super.onPrepareOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        this.postMessage("onOptionsItemSelected", item);
        return true;
    }

    @Override
    public Context getContext() {
        LOG.d(TAG, "This will be deprecated December 2012");
        return this;
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        if (this.appView != null) {
            this.appView.showWebPage(url, openExternal, clearHistory, params);
        }
    }

    public void removeSplashScreen() {
        if (this.splashDialog != null && this.splashDialog.isShowing()) {
            this.splashDialog.dismiss();
            this.splashDialog = null;
        }
    }

    protected void showSplashScreen(final int time) {
        final DroidGap that = this;
        Runnable runnable = new Runnable(){

            public void run() {
                Display display = DroidGap.this.getWindowManager().getDefaultDisplay();
                LinearLayout root = new LinearLayout((Context)that.getActivity());
                root.setMinimumHeight(display.getHeight());
                root.setMinimumWidth(display.getWidth());
                root.setOrientation(1);
                root.setBackgroundColor(that.getIntegerProperty("backgroundColor", -16777216));
                root.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 0.0f));
                root.setBackgroundResource(that.splashscreen);
                DroidGap.this.splashDialog = new Dialog((Context)that, 0x1030010);
                if ((DroidGap.this.getWindow().getAttributes().flags & 0x400) == 1024) {
                    DroidGap.this.splashDialog.getWindow().setFlags(1024, 1024);
                }
                DroidGap.this.splashDialog.setContentView((View)root);
                DroidGap.this.splashDialog.setCancelable(false);
                DroidGap.this.splashDialog.show();
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    public void run() {
                        DroidGap.this.removeSplashScreen();
                    }
                }, (long)time);
            }
        };
        this.runOnUiThread(runnable);
    }

    @Override
    public Object onMessage(String id, Object data) {
        LOG.d(TAG, "onMessage(" + id + "," + data + ")");
        if ("splashscreen".equals(id)) {
            if ("hide".equals(data.toString())) {
                this.removeSplashScreen();
            } else {
                this.splashscreen = this.getIntegerProperty("splashscreen", 0);
                this.showSplashScreen(this.splashscreenTime);
            }
        } else if ("spinner".equals(id)) {
            if ("stop".equals(data.toString())) {
                this.spinnerStop();
                this.appView.setVisibility(0);
            }
        } else if ("onReceivedError".equals(id)) {
            JSONObject d = (JSONObject)data;
            try {
                this.onReceivedError(d.getInt("errorCode"), d.getString("description"), d.getString("url"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if ("exit".equals(id)) {
            this.endActivity();
        }
        return null;
    }
}

