/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.net.Uri;
import android.util.Log;
import android.webkit.CookieManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cordova.FileUploadResult;
import org.apache.cordova.FileUtils;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileTransfer
extends Plugin {
    private static final String LOG_TAG = "FileTransfer";
    private static final String LINE_START = "--";
    private static final String LINE_END = "\r\n";
    private static final String BOUNDARY = "*****";
    public static int FILE_NOT_FOUND_ERR = 1;
    public static int INVALID_URL_ERR = 2;
    public static int CONNECTION_ERR = 3;
    private SSLSocketFactory defaultSSLSocketFactory = null;
    private HostnameVerifier defaultHostnameVerifier = null;
    static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        String source = null;
        String target = null;
        try {
            source = URLDecoder.decode(args.getString(0));
            target = args.getString(1);
        }
        catch (JSONException e) {
            Log.d((String)LOG_TAG, (String)"Missing source or target");
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION, "Missing source or target");
        }
        if (action.equals("upload")) {
            return this.upload(source, target, args);
        }
        if (action.equals("download")) {
            return this.download(source, target);
        }
        return new PluginResult(PluginResult.Status.INVALID_ACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginResult upload(String source, String target, JSONArray args) {
        Log.d((String)LOG_TAG, (String)("upload " + source + " to " + target));
        HttpURLConnection conn = null;
        try {
            String line;
            DataInputStream inStream;
            String cookie;
            String fileKey = this.getArgument(args, 2, "file");
            String fileName = this.getArgument(args, 3, "image.jpg");
            String mimeType = this.getArgument(args, 4, "image/jpeg");
            JSONObject params = args.optJSONObject(5);
            if (params == null) {
                params = new JSONObject();
            }
            boolean trustEveryone = args.optBoolean(6);
            boolean chunkedMode = args.optBoolean(7) || args.isNull(7);
            Log.d((String)LOG_TAG, (String)("fileKey: " + fileKey));
            Log.d((String)LOG_TAG, (String)("fileName: " + fileName));
            Log.d((String)LOG_TAG, (String)("mimeType: " + mimeType));
            Log.d((String)LOG_TAG, (String)("params: " + params));
            Log.d((String)LOG_TAG, (String)("trustEveryone: " + trustEveryone));
            Log.d((String)LOG_TAG, (String)("chunkedMode: " + chunkedMode));
            FileUploadResult result = new FileUploadResult();
            FileInputStream fileInputStream = (FileInputStream)this.getPathFromUri(source);
            DataOutputStream dos = null;
            int maxBufferSize = 8096;
            URL url = new URL(target);
            if (url.getProtocol().toLowerCase().equals("https")) {
                if (!trustEveryone) {
                    conn = (HttpsURLConnection)url.openConnection();
                } else {
                    this.trustAllHosts();
                    HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                    this.defaultHostnameVerifier = https.getHostnameVerifier();
                    https.setHostnameVerifier(DO_NOT_VERIFY);
                    conn = https;
                }
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            try {
                JSONObject headers = params.getJSONObject("headers");
                Iterator iter = headers.keys();
                while (iter.hasNext()) {
                    String headerKey = iter.next().toString();
                    conn.setRequestProperty(headerKey, headers.getString(headerKey));
                }
            }
            catch (JSONException e1) {
                // empty catch block
            }
            if ((cookie = CookieManager.getInstance().getCookie(target)) != null) {
                conn.setRequestProperty("Cookie", cookie);
            }
            String extraParams = "";
            try {
                Iterator iter = params.keys();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    if (String.valueOf(key).equals("headers")) continue;
                    extraParams = extraParams + "--*****\r\n";
                    extraParams = extraParams + "Content-Disposition: form-data; name=\"" + key.toString() + "\";";
                    extraParams = extraParams + "\r\n\r\n";
                    extraParams = extraParams + params.getString(key.toString());
                    extraParams = extraParams + LINE_END;
                }
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            }
            extraParams = extraParams + "--*****\r\n";
            extraParams = extraParams + "Content-Disposition: form-data; name=\"" + fileKey + "\";" + " filename=\"";
            byte[] extraBytes = extraParams.getBytes("UTF-8");
            String midParams = "\"\r\nContent-Type: " + mimeType + LINE_END + LINE_END;
            String tailParams = "\r\n--*****--\r\n";
            byte[] fileNameBytes = fileName.getBytes("UTF-8");
            if (chunkedMode) {
                conn.setChunkedStreamingMode(maxBufferSize);
            } else {
                int stringLength = extraBytes.length + midParams.length() + tailParams.length() + fileNameBytes.length;
                Log.d((String)LOG_TAG, (String)("String Length: " + stringLength));
                int fixedLength = (int)fileInputStream.getChannel().size() + stringLength;
                Log.d((String)LOG_TAG, (String)("Content Length: " + fixedLength));
                conn.setFixedLengthStreamingMode(fixedLength);
            }
            dos = new DataOutputStream(conn.getOutputStream());
            dos.write(extraBytes);
            dos.write(fileNameBytes);
            dos.writeBytes(midParams);
            int bytesAvailable = fileInputStream.available();
            int bufferSize = Math.min(bytesAvailable, maxBufferSize);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            long totalBytes = 0L;
            while (bytesRead > 0) {
                result.setBytesSent(totalBytes += (long)bytesRead);
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = fileInputStream.available();
                bufferSize = Math.min(bytesAvailable, maxBufferSize);
                bytesRead = fileInputStream.read(buffer, 0, bufferSize);
            }
            dos.writeBytes(tailParams);
            fileInputStream.close();
            dos.flush();
            dos.close();
            StringBuffer responseString = new StringBuffer("");
            try {
                inStream = new DataInputStream(conn.getInputStream());
            }
            catch (FileNotFoundException e) {
                Log.e((String)LOG_TAG, (String)e.toString(), (Throwable)e);
                throw new IOException("Received error from server");
            }
            while ((line = inStream.readLine()) != null) {
                responseString.append(line);
            }
            Log.d((String)LOG_TAG, (String)"got response from server");
            Log.d((String)LOG_TAG, (String)responseString.toString());
            result.setResponseCode(conn.getResponseCode());
            result.setResponse(responseString.toString());
            inStream.close();
            if (trustEveryone && url.getProtocol().toLowerCase().equals("https")) {
                ((HttpsURLConnection)conn).setHostnameVerifier(this.defaultHostnameVerifier);
                HttpsURLConnection.setDefaultSSLSocketFactory(this.defaultSSLSocketFactory);
            }
            Log.d((String)LOG_TAG, (String)"****** About to return a result from upload");
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, result.toJSONObject());
            return pluginResult;
        }
        catch (FileNotFoundException e) {
            JSONObject error = this.createFileTransferError(FILE_NOT_FOUND_ERR, source, target, conn);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (MalformedURLException e) {
            JSONObject error = this.createFileTransferError(INVALID_URL_ERR, source, target, conn);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (IOException e) {
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target, conn);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
            PluginResult error = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            return error;
        }
        catch (Throwable t) {
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target, conn);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)t);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            this.defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private JSONObject createFileTransferError(int errorCode, String source, String target, HttpURLConnection connection) {
        Integer httpStatus = null;
        if (connection != null) {
            try {
                httpStatus = connection.getResponseCode();
            }
            catch (IOException e) {
                Log.w((String)LOG_TAG, (String)"Error getting HTTP status code from connection.", (Throwable)e);
            }
        }
        return this.createFileTransferError(errorCode, source, target, httpStatus);
    }

    private JSONObject createFileTransferError(int errorCode, String source, String target, Integer httpStatus) {
        JSONObject error = null;
        try {
            error = new JSONObject();
            error.put("code", errorCode);
            error.put("source", (Object)source);
            error.put("target", (Object)target);
            if (httpStatus != null) {
                error.put("http_status", (Object)httpStatus);
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return error;
    }

    private String getArgument(JSONArray args, int position, String defaultString) {
        String arg = defaultString;
        if (args.length() >= position && ((arg = args.optString(position)) == null || "null".equals(arg))) {
            arg = defaultString;
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginResult download(String source, String target) {
        Log.d((String)LOG_TAG, (String)("download " + source + " to " + target));
        HttpURLConnection connection = null;
        try {
            File file = this.getFileFromPath(target);
            file.getParentFile().mkdirs();
            if (this.webView.isUrlWhiteListed(source)) {
                URL url = new URL(source);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                String cookie = CookieManager.getInstance().getCookie(source);
                if (cookie != null) {
                    connection.setRequestProperty("cookie", cookie);
                }
                connection.connect();
                Log.d((String)LOG_TAG, (String)("Download file: " + url));
                connection.connect();
                Log.d((String)LOG_TAG, (String)("Download file:" + url));
                InputStream inputStream = connection.getInputStream();
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                FileOutputStream outputStream = new FileOutputStream(file);
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                Log.d((String)LOG_TAG, (String)("Saved file: " + target));
                FileUtils fileUtil = new FileUtils();
                JSONObject fileEntry = fileUtil.getEntry(file);
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, fileEntry);
                return pluginResult;
            }
            Log.w((String)LOG_TAG, (String)("Source URL is not in white list: '" + source + "'"));
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target, 401);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (FileNotFoundException e) {
            JSONObject error = this.createFileTransferError(FILE_NOT_FOUND_ERR, source, target, connection);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (MalformedURLException e) {
            JSONObject error = this.createFileTransferError(INVALID_URL_ERR, source, target, connection);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        catch (Exception e) {
            JSONObject error = this.createFileTransferError(CONNECTION_ERR, source, target, connection);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            PluginResult pluginResult = new PluginResult(PluginResult.Status.IO_EXCEPTION, error);
            return pluginResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private InputStream getPathFromUri(String path) throws FileNotFoundException {
        if (path.startsWith("content:")) {
            Uri uri = Uri.parse((String)path);
            return this.cordova.getActivity().getContentResolver().openInputStream(uri);
        }
        if (path.startsWith("file://")) {
            int question = path.indexOf("?");
            if (question == -1) {
                return new FileInputStream(path.substring(7));
            }
            return new FileInputStream(path.substring(7, question));
        }
        return new FileInputStream(path);
    }

    private File getFileFromPath(String path) throws FileNotFoundException {
        String prefix = "file://";
        File file = path.startsWith(prefix) ? new File(path.substring(prefix.length())) : new File(path);
        if (file.getParent() == null) {
            throw new FileNotFoundException();
        }
        return file;
    }
}

