/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Vibrator;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.Plugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;

public class Notification
extends Plugin {
    public int confirmResult = -1;
    public ProgressDialog spinnerDialog = null;
    public ProgressDialog progressDialog = null;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("beep")) {
                this.beep(args.getLong(0));
            } else if (action.equals("vibrate")) {
                this.vibrate(args.getLong(0));
            } else {
                if (action.equals("alert")) {
                    this.alert(args.getString(0), args.getString(1), args.getString(2), callbackId);
                    PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
                    r.setKeepCallback(true);
                    return r;
                }
                if (action.equals("confirm")) {
                    this.confirm(args.getString(0), args.getString(1), args.getString(2), callbackId);
                    PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
                    r.setKeepCallback(true);
                    return r;
                }
                if (action.equals("activityStart")) {
                    this.activityStart(args.getString(0), args.getString(1));
                } else if (action.equals("activityStop")) {
                    this.activityStop();
                } else if (action.equals("progressStart")) {
                    this.progressStart(args.getString(0), args.getString(1));
                } else if (action.equals("progressValue")) {
                    this.progressValue(args.getInt(0));
                } else if (action.equals("progressStop")) {
                    this.progressStop();
                }
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("alert")) {
            return true;
        }
        if (action.equals("confirm")) {
            return true;
        }
        if (action.equals("activityStart")) {
            return true;
        }
        if (action.equals("activityStop")) {
            return true;
        }
        if (action.equals("progressStart")) {
            return true;
        }
        if (action.equals("progressValue")) {
            return true;
        }
        return action.equals("progressStop");
    }

    public void beep(long count) {
        Uri ringtone = RingtoneManager.getDefaultUri((int)2);
        Ringtone notification = RingtoneManager.getRingtone((Context)this.cordova.getActivity().getBaseContext(), (Uri)ringtone);
        if (notification != null) {
            for (long i = 0L; i < count; ++i) {
                notification.play();
                long timeout = 5000L;
                while (notification.isPlaying() && timeout > 0L) {
                    timeout -= 100L;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public void vibrate(long time) {
        if (time == 0L) {
            time = 500L;
        }
        Vibrator vibrator = (Vibrator)this.cordova.getActivity().getSystemService("vibrator");
        vibrator.vibrate(time);
    }

    public synchronized void alert(final String message, final String title, final String buttonLabel, final String callbackId) {
        final CordovaInterface cordova = this.cordova;
        final Notification notification = this;
        Runnable runnable = new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)cordova.getActivity());
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(false);
                dlg.setPositiveButton((CharSequence)buttonLabel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        notification.success(new PluginResult(PluginResult.Status.OK, 0), callbackId);
                    }
                });
                dlg.create();
                dlg.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void confirm(final String message, final String title, String buttonLabels, final String callbackId) {
        final CordovaInterface cordova = this.cordova;
        final Notification notification = this;
        final String[] fButtons = buttonLabels.split(",");
        Runnable runnable = new Runnable(){

            public void run() {
                AlertDialog.Builder dlg = new AlertDialog.Builder((Context)cordova.getActivity());
                dlg.setMessage((CharSequence)message);
                dlg.setTitle((CharSequence)title);
                dlg.setCancelable(false);
                if (fButtons.length > 0) {
                    dlg.setNegativeButton((CharSequence)fButtons[0], new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            notification.success(new PluginResult(PluginResult.Status.OK, 1), callbackId);
                        }
                    });
                }
                if (fButtons.length > 1) {
                    dlg.setNeutralButton((CharSequence)fButtons[1], new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            notification.success(new PluginResult(PluginResult.Status.OK, 2), callbackId);
                        }
                    });
                }
                if (fButtons.length > 2) {
                    dlg.setPositiveButton((CharSequence)fButtons[2], new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            notification.success(new PluginResult(PluginResult.Status.OK, 3), callbackId);
                        }
                    });
                }
                dlg.create();
                dlg.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStart(final String title, final String message) {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
        final Notification notification = this;
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                notification.spinnerDialog = ProgressDialog.show((Context)cordova.getActivity(), (CharSequence)title, (CharSequence)message, (boolean)true, (boolean)true, (DialogInterface.OnCancelListener)new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        notification.spinnerDialog = null;
                    }
                });
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void activityStop() {
        if (this.spinnerDialog != null) {
            this.spinnerDialog.dismiss();
            this.spinnerDialog = null;
        }
    }

    public synchronized void progressStart(final String title, final String message) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
        final Notification notification = this;
        final CordovaInterface cordova = this.cordova;
        Runnable runnable = new Runnable(){

            public void run() {
                notification.progressDialog = new ProgressDialog((Context)cordova.getActivity());
                notification.progressDialog.setProgressStyle(1);
                notification.progressDialog.setTitle((CharSequence)title);
                notification.progressDialog.setMessage((CharSequence)message);
                notification.progressDialog.setCancelable(true);
                notification.progressDialog.setMax(100);
                notification.progressDialog.setProgress(0);
                notification.progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        notification.progressDialog = null;
                    }
                });
                notification.progressDialog.show();
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
    }

    public synchronized void progressValue(int value) {
        if (this.progressDialog != null) {
            this.progressDialog.setProgress(value);
        }
    }

    public synchronized void progressStop() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }
}

