#!/bin/sh
# 

SCRIPT_DIRECTORY=`dirname $0`

git log --reverse --format='%aN <%aE>' | perl -we '

BEGIN {
  %seen = (), @authors = ();
}

while (<>) {
  next if $seen{$_};
  next if /\@chromium.org/;
  next if /<erik.corry\@gmail.com>/;
  $seen{$_} = push @authors, $_;
}

END {
  print "# Authors ordered by first contribution.\n";
  print "\n", @authors, "\n";
  print "# Generated by scripts/update-authors.sh\n";
}

' > "$SCRIPT_DIRECTORY/../AUTHORS"
