"use strict";

exports.__esModule = true;
exports.default = void 0;

var _helperOptimiseCallExpression = _interopRequireDefault(require("@babel/helper-optimise-call-expression"));

var t = _interopRequireWildcard(require("@babel/types"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HARDCORE_THIS_REF = new WeakSet();

function isIllegalBareSuper(node, parent) {
  if (!t.isSuper(node)) return false;
  if (t.isMemberExpression(parent, {
    computed: false
  })) return false;
  if (t.isCallExpression(parent, {
    callee: node
  })) return false;
  return true;
}

function isMemberExpressionSuper(node) {
  return t.isMemberExpression(node) && t.isSuper(node.object);
}

function getPrototypeOfExpression(objectRef, isStatic) {
  var targetRef = isStatic ? objectRef : t.memberExpression(objectRef, t.identifier("prototype"));
  return t.logicalExpression("||", t.memberExpression(targetRef, t.identifier("__proto__")), t.callExpression(t.memberExpression(t.identifier("Object"), t.identifier("getPrototypeOf")), [t.cloneNode(targetRef)]));
}

var visitor = {
  Function: function Function(path) {
    if (!path.isArrowFunctionExpression()) path.skip();
  },
  ClassProperty: function ClassProperty(path) {
    if (!path.node.static) path.skip();
  },
  ReturnStatement: function ReturnStatement(path, state) {
    if (!path.getFunctionParent().isArrowFunctionExpression()) {
      state.returns.push(path);
    }
  },
  ThisExpression: function ThisExpression(path, state) {
    if (!HARDCORE_THIS_REF.has(path.node)) {
      state.thises.push(path);
    }
  },
  enter: function enter(path, state) {
    var callback = state.specHandle;
    if (state.isLoose) callback = state.looseHandle;
    var isBareSuper = path.isCallExpression() && path.get("callee").isSuper();
    var result = callback.call(state, path);

    if (result) {
      state.hasSuper = true;
    }

    if (isBareSuper) {
      state.bareSupers.push(path);
    }

    if (result === true) {
      path.requeue();
    }

    if (result !== true && result) {
      if (Array.isArray(result)) {
        path.replaceWithMultiple(result);
      } else {
        path.replaceWith(result);
      }
    }
  }
};

var ReplaceSupers = function () {
  function ReplaceSupers(opts, inClass) {
    if (inClass === void 0) {
      inClass = false;
    }

    this.forceSuperMemoisation = opts.forceSuperMemoisation;
    this.methodPath = opts.methodPath;
    this.methodNode = opts.methodNode;
    this.superRef = opts.superRef;
    this.isStatic = opts.isStatic;
    this.hasSuper = false;
    this.inClass = inClass;
    this.inConstructor = opts.inConstructor;
    this.isLoose = opts.isLoose;
    this.scope = this.methodPath.scope;
    this.file = opts.file;
    this.opts = opts;
    this.bareSupers = [];
    this.returns = [];
    this.thises = [];
  }

  var _proto = ReplaceSupers.prototype;

  _proto.getObjectRef = function getObjectRef() {
    return t.cloneNode(this.opts.objectRef || this.opts.getObjectRef());
  };

  _proto.setSuperProperty = function setSuperProperty(property, value, isComputed) {
    return t.callExpression(this.file.addHelper("set"), [getPrototypeOfExpression(this.getObjectRef(), this.isStatic), isComputed ? property : t.stringLiteral(property.name), value, t.thisExpression()]);
  };

  _proto.getSuperProperty = function getSuperProperty(property, isComputed) {
    var thisExpr = t.thisExpression();

    if (this.inConstructor) {
      thisExpr = t.callExpression(this.file.addHelper("assertThisInitialized"), [thisExpr]);
    }

    return t.callExpression(this.file.addHelper("get"), [getPrototypeOfExpression(this.getObjectRef(), this.isStatic), isComputed ? property : t.stringLiteral(property.name), thisExpr]);
  };

  _proto.replace = function replace() {
    this.methodPath.traverse(visitor, this);
  };

  _proto.getLooseSuperProperty = function getLooseSuperProperty(id, parent) {
    var methodNode = this.methodNode;
    var superRef = this.superRef || t.identifier("Function");

    if (parent.property === id) {
      return;
    } else if (t.isCallExpression(parent, {
      callee: id
    })) {
      return;
    } else if (t.isMemberExpression(parent) && !methodNode.static) {
      return t.memberExpression(t.cloneNode(superRef), t.identifier("prototype"));
    } else {
      return t.cloneNode(superRef);
    }
  };

  _proto.looseHandle = function looseHandle(path) {
    var node = path.node;

    if (path.isSuper()) {
      return this.getLooseSuperProperty(node, path.parent);
    } else if (path.isCallExpression()) {
      var callee = node.callee;
      if (!t.isMemberExpression(callee)) return;
      if (!t.isSuper(callee.object)) return;
      t.appendToMemberExpression(callee, t.identifier("call"));
      node.arguments.unshift(t.thisExpression());
      return true;
    }
  };

  _proto.specHandleAssignmentExpression = function specHandleAssignmentExpression(ref, path, node) {
    if (node.operator === "=") {
      return this.setSuperProperty(node.left.property, node.right, node.left.computed);
    } else {
      ref = ref || path.scope.generateUidIdentifier("ref");
      return [t.variableDeclaration("var", [t.variableDeclarator(t.cloneNode(ref), t.cloneNode(node.left))]), t.expressionStatement(t.assignmentExpression("=", node.left, t.binaryExpression(node.operator.slice(0, -1), t.cloneNode(ref), node.right)))];
    }
  };

  _proto.specHandle = function specHandle(path) {
    var property;
    var computed;
    var args;
    var parent = path.parent;
    var node = path.node;

    if (isIllegalBareSuper(node, parent)) {
      throw path.buildCodeFrameError("Illegal use of bare super");
    }

    if (t.isCallExpression(node)) {
      var callee = node.callee;

      if (t.isSuper(callee)) {
        return;
      } else if (isMemberExpressionSuper(callee)) {
        property = callee.property;
        computed = callee.computed;
        args = node.arguments;
      }
    } else if (t.isMemberExpression(node) && t.isSuper(node.object)) {
      property = node.property;
      computed = node.computed;
    } else if (t.isUpdateExpression(node) && isMemberExpressionSuper(node.argument)) {
      var binary = t.assignmentExpression(node.operator[0] + "=", node.argument, t.numericLiteral(1));

      if (node.prefix) {
        return this.specHandleAssignmentExpression(null, path, binary);
      } else {
        var ref = path.scope.generateUidIdentifier("ref");
        return this.specHandleAssignmentExpression(ref, path, binary).concat(t.expressionStatement(ref));
      }
    } else if (t.isAssignmentExpression(node) && isMemberExpressionSuper(node.left)) {
      return this.specHandleAssignmentExpression(null, path, node);
    }

    if (!property) return;
    var superProperty = this.getSuperProperty(property, computed);

    if (args) {
      return this.optimiseCall(superProperty, args);
    } else {
      return superProperty;
    }
  };

  _proto.optimiseCall = function optimiseCall(callee, args) {
    var thisNode = t.thisExpression();
    HARDCORE_THIS_REF.add(thisNode);
    return (0, _helperOptimiseCallExpression.default)(callee, thisNode, args);
  };

  return ReplaceSupers;
}();

exports.default = ReplaceSupers;