import { GraphQLFieldConfigArgumentMap, GraphQLArgument } from './definition';
import { DirectiveDefinitionNode } from '../language/ast';

export const DirectiveLocation: {
  // Operations
  QUERY: 'QUERY';
  MUTATION: 'MUTATION';
  SUBSCRIPTION: 'SUBSCRIPTION';
  FIELD: 'FIELD';
  FRAGMENT_DEFINITION: 'FRAGMENT_DEFINITION';
  FRAGMENT_SPREAD: 'FRAGMENT_SPREAD';
  INLINE_FRAGMENT: 'INLINE_FRAGMENT';
  // Schema Definitions
  SCHEMA: 'SCHEMA';
  SCALAR: 'SCALAR';
  OBJECT: 'OBJECT';
  FIELD_DEFINITION: 'FIELD_DEFINITION';
  ARGUMENT_DEFINITION: 'ARGUMENT_DEFINITION';
  INTERFACE: 'INTERFACE';
  UNION: 'UNION';
  ENUM: 'ENUM';
  ENUM_VALUE: 'ENUM_VALUE';
  INPUT_OBJECT: 'INPUT_OBJECT';
  INPUT_FIELD_DEFINITION: 'INPUT_FIELD_DEFINITION';
};

export type DirectiveLocationEnum = keyof typeof DirectiveLocation;

/**
 * Directives are used by the GraphQL runtime as a way of modifying execution
 * behavior. Type system creators will usually not create these directly.
 */
export class GraphQLDirective {
  name: string;
  description?: string;
  locations: DirectiveLocationEnum[];
  args: GraphQLArgument[];
  astNode?: DirectiveDefinitionNode;

  constructor(config: GraphQLDirectiveConfig);
}

export interface GraphQLDirectiveConfig {
  name: string;
  description?: string;
  locations: DirectiveLocationEnum[];
  args?: GraphQLFieldConfigArgumentMap;
  astNode?: DirectiveDefinitionNode;
}

/**
 * Used to conditionally include fields or fragments.
 */
export const GraphQLIncludeDirective: GraphQLDirective;

/**
 * Used to conditionally skip (exclude) fields or fragments.
 */
export const GraphQLSkipDirective: GraphQLDirective;

/**
 * Constant string used for default reason for a deprecation.
 */
export const DEFAULT_DEPRECATION_REASON: 'No longer supported';

/**
 * Used to declare element of a GraphQL schema as deprecated.
 */
export const GraphQLDeprecatedDirective: GraphQLDirective;

/**
 * The full list of specified directives.
 */
export const specifiedDirectives: GraphQLDirective[];
