import { SelectionSetNode, FieldNode, DocumentNode } from 'graphql';
import { FragmentMatcher } from 'graphql-anywhere';
import { FragmentMap } from 'apollo-utilities';
import { IdGetter, NormalizedCache, NormalizedCacheFactory } from './types';
export declare class WriteError extends Error {
    type: string;
}
export declare function enhanceErrorWithDocument(error: Error, document: DocumentNode): WriteError;
/**
 * Writes the result of a query to the store.
 *
 * @param result The result object returned for the query document.
 *
 * @param query The query document whose result we are writing to the store.
 *
 * @param store The {@link NormalizedCache} used by Apollo for the `data` portion of the store.
 *
 * @param variables A map from the name of a variable to its value. These variables can be
 * referenced by the query document.
 *
 * @param dataIdFromObject A function that returns an object identifier given a particular result
 * object. See the store documentation for details and an example of this function.
 *
 * @param fragmentMap A map from the name of a fragment to its fragment definition. These fragments
 * can be referenced within the query document.
 *
 * @param fragmentMatcherFunction A function to use for matching fragment conditions in GraphQL documents
 */
export declare function writeQueryToStore({ result, query, storeFactory, store, variables, dataIdFromObject, fragmentMap, fragmentMatcherFunction, }: {
    result: Object;
    query: DocumentNode;
    store?: NormalizedCache;
    storeFactory?: NormalizedCacheFactory;
    variables?: Object;
    dataIdFromObject?: IdGetter;
    fragmentMap?: FragmentMap;
    fragmentMatcherFunction?: FragmentMatcher;
}): NormalizedCache;
export declare type WriteContext = {
    store: NormalizedCache;
    storeFactory: NormalizedCacheFactory;
    processedData?: {
        [x: string]: FieldNode[];
    };
    variables?: any;
    dataIdFromObject?: IdGetter;
    fragmentMap?: FragmentMap;
    fragmentMatcherFunction?: FragmentMatcher;
};
export declare function writeResultToStore({ dataId, result, document, storeFactory, store, variables, dataIdFromObject, fragmentMatcherFunction, }: {
    dataId: string;
    result: any;
    document: DocumentNode;
    store?: NormalizedCache;
    storeFactory?: NormalizedCacheFactory;
    variables?: Object;
    dataIdFromObject?: IdGetter;
    fragmentMatcherFunction?: FragmentMatcher;
}): NormalizedCache;
export declare function writeSelectionSetToStore({ result, dataId, selectionSet, context, }: {
    dataId: string;
    result: any;
    selectionSet: SelectionSetNode;
    context: WriteContext;
}): NormalizedCache;
