import { DocumentNode } from 'graphql';
import { DataProxy, Cache } from './types';
export declare type Transaction<T> = (c: ApolloCache<T>) => void;
export declare abstract class ApolloCache<TSerialized> implements DataProxy {
    abstract read<T>(query: Cache.ReadOptions): T | null;
    abstract write(write: Cache.WriteOptions): void;
    abstract diff<T>(query: Cache.DiffOptions): Cache.DiffResult<T>;
    abstract watch(watch: Cache.WatchOptions): () => void;
    abstract evict(query: Cache.EvictOptions): Cache.EvictionResult;
    abstract reset(): Promise<void>;
    /**
     * Replaces existing state in the cache (if any) with the values expressed by
     * `serializedState`.
     *
     * Called when hydrating a cache (server side rendering, or offline storage),
     * and also (potentially) during hot reloads.
     */
    abstract restore(serializedState: TSerialized): ApolloCache<TSerialized>;
    /**
     * Exposes the cache's complete state, in a serializable format for later restoration.
     */
    abstract extract(optimistic?: boolean): TSerialized;
    abstract removeOptimistic(id: string): void;
    abstract performTransaction(transaction: Transaction<TSerialized>): void;
    abstract recordOptimisticTransaction(transaction: Transaction<TSerialized>, id: string): void;
    transformDocument(document: DocumentNode): DocumentNode;
    transformForLink(document: DocumentNode): DocumentNode;
    /**
     *
     * @param options
     * @param optimistic
     */
    readQuery<QueryType>(options: DataProxy.Query, optimistic?: boolean): QueryType | null;
    readFragment<FragmentType>(options: DataProxy.Fragment, optimistic?: boolean): FragmentType | null;
    writeQuery(options: Cache.WriteQueryOptions): void;
    writeFragment(options: Cache.WriteFragmentOptions): void;
    writeData({id, data}: Cache.WriteDataOptions): void;
}
