var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
import { getFragmentQueryDocument } from 'apollo-utilities';
import { justTypenameQuery, queryFromPojo, fragmentFromPojo } from './utils';
var ApolloCache = /** @class */ (function () {
    function ApolloCache() {
    }
    // optional API
    ApolloCache.prototype.transformDocument = function (document) {
        return document;
    };
    // experimental
    ApolloCache.prototype.transformForLink = function (document) {
        return document;
    };
    // DataProxy API
    /**
     *
     * @param options
     * @param optimistic
     */
    ApolloCache.prototype.readQuery = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: options.query,
            variables: options.variables,
            optimistic: optimistic,
        });
    };
    ApolloCache.prototype.readFragment = function (options, optimistic) {
        if (optimistic === void 0) { optimistic = false; }
        return this.read({
            query: getFragmentQueryDocument(options.fragment, options.fragmentName),
            variables: options.variables,
            rootId: options.id,
            optimistic: optimistic,
        });
    };
    ApolloCache.prototype.writeQuery = function (options) {
        this.write({
            dataId: 'ROOT_QUERY',
            result: options.data,
            query: options.query,
            variables: options.variables,
        });
    };
    ApolloCache.prototype.writeFragment = function (options) {
        this.write({
            dataId: options.id,
            result: options.data,
            variables: options.variables,
            query: getFragmentQueryDocument(options.fragment, options.fragmentName),
        });
    };
    ApolloCache.prototype.writeData = function (_a) {
        var id = _a.id, data = _a.data;
        if (typeof id !== 'undefined') {
            var typenameResult = null;
            // Since we can't use fragments without having a typename in the store,
            // we need to make sure we have one.
            // To avoid overwriting an existing typename, we need to read it out first
            // and generate a fake one if none exists.
            try {
                typenameResult = this.read({
                    rootId: id,
                    optimistic: false,
                    query: justTypenameQuery,
                });
            }
            catch (e) {
                // Do nothing, since an error just means no typename exists
            }
            // tslint:disable-next-line
            var __typename = (typenameResult && typenameResult.__typename) || '__ClientData';
            // Add a type here to satisfy the inmemory cache
            var dataToWrite = __assign({ __typename: __typename }, data);
            this.writeFragment({
                id: id,
                fragment: fragmentFromPojo(dataToWrite, __typename),
                data: dataToWrite,
            });
        }
        else {
            this.writeQuery({ query: queryFromPojo(data), data: data });
        }
    };
    return ApolloCache;
}());
export { ApolloCache };
//# sourceMappingURL=cache.js.map