import { DataProxy } from './DataProxy';
export declare namespace Cache {
    type WatchCallback = (newData: any) => void;
    interface EvictionResult {
        success: Boolean;
    }
    interface ReadOptions extends DataProxy.Query {
        rootId?: string;
        previousResult?: any;
        optimistic: boolean;
    }
    interface WriteOptions extends DataProxy.Query {
        dataId: string;
        result: any;
    }
    interface DiffOptions extends ReadOptions {
        returnPartialData?: boolean;
    }
    interface WatchOptions extends ReadOptions {
        callback: WatchCallback;
    }
    interface EvictOptions extends DataProxy.Query {
        rootId?: string;
    }
    export import DiffResult = DataProxy.DiffResult;
    export import WriteQueryOptions = DataProxy.WriteQueryOptions;
    export import WriteFragmentOptions = DataProxy.WriteFragmentOptions;
    export import WriteDataOptions = DataProxy.WriteDataOptions;
    export import Fragment = DataProxy.Fragment;
}
