'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = parseWebpack;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var webpackConfigRegex = /webpack(\..+)?\.config\.(babel\.)?js/;
var loaderTemplates = ['*-webpack-loader', '*-web-loader', '*-loader', '*'];

function extractLoaders(item) {
  if (typeof item === 'string') {
    return item;
  }

  if (item.loader && typeof item.loader === 'string') {
    return item.loader.split('!');
  }

  if (item.loaders) {
    return item.loaders;
  }

  return [];
}

function stripQueryParameter(loader) {
  var index = loader.indexOf('?');
  return index === -1 ? loader : loader.substring(0, index);
}

function normalizeLoader(deps, loader) {
  var name = (0, _lodash2.default)(loaderTemplates).map(function (template) {
    return template.replace('*', loader);
  }).intersection(deps).first();
  return name;
}

function getLoaders(deps, loaders) {
  return (0, _lodash2.default)(loaders || []).map(extractLoaders).flatten().map(function (loader) {
    return stripQueryParameter(loader);
  }).map(function (loader) {
    return normalizeLoader(deps, loader);
  }).filter(function (loader) {
    return loader;
  }).uniq().value();
}

function parseWebpack1(module, deps) {
  var loaders = getLoaders(deps, module.loaders);
  var preLoaders = getLoaders(deps, module.preLoaders);
  var postLoaders = getLoaders(deps, module.postLoaders);
  return [].concat(_toConsumableArray(loaders), _toConsumableArray(preLoaders), _toConsumableArray(postLoaders));
}

function mapRuleUse(module) {
  return module.rules
  // filter use or loader because 'loader' is a shortcut to 'use'
  .filter(function (rule) {
    return rule.use || rule.loader;
  })
  // return coerced array, using the relevant key
  .map(function (rule) {
    return [].concat(rule.use || rule.loader);
  });
}

function parseWebpack2(module, deps) {
  if (!module.rules) {
    return [];
  }

  var mappedLoaders = module.rules.filter(function (rule) {
    return rule.loaders;
  });
  var mappedUses = mapRuleUse(module);
  var loaders = getLoaders(deps, _lodash2.default.flatten([].concat(_toConsumableArray(mappedLoaders), _toConsumableArray(mappedUses))));
  return loaders;
}

function parseWebpack(content, filepath, deps) {
  var filename = _path2.default.basename(filepath);
  if (webpackConfigRegex.test(filename)) {
    var module = require(filepath).module || {}; // eslint-disable-line global-require

    var webpack1Loaders = parseWebpack1(module, deps);
    var webpack2Loaders = parseWebpack2(module, deps);
    return [].concat(_toConsumableArray(webpack1Loaders), _toConsumableArray(webpack2Loaders));
  }

  return [];
}
module.exports = exports['default'];