'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _DOMMatrixReadOnly = require('./DOMMatrixReadOnly');

var _DOMMatrixReadOnly2 = _interopRequireDefault(_DOMMatrixReadOnly);

var _utilities = require('./utilities');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _DOMMatrixReadOnly.initDOMMatrixReadOnly)();

var DOMMatrix = function (DOMMatrixReadOnly) {
    function DOMMatrix(arg) {
        const numArgs = arguments.length;
        if (numArgs === 0) {
            DOMMatrixReadOnly.call(this, [1, 0, 0, 1, 0, 0]);
        } else if (numArgs === 1) {
            if (typeof arg == 'string') {
                throw new Error('CSS transformList arg not yet implemented.');
                // TODO validate that syntax of transformList matches transform-list (http://www.w3.org/TR/css-transforms-1/#typedef-transform-list).
            } else if (arg instanceof DOMMatrix) {
                DOMMatrixReadOnly.call(this, arg._matrix);
            } else if (arg instanceof Float32Array || arg instanceof Float64Array || arg instanceof Array) {
                DOMMatrixReadOnly.call(this, arg);
            }
        } else {
            throw new Error('Wrong number of arguments to DOMMatrix constructor.');
        }
    }

    if (DOMMatrixReadOnly) DOMMatrix.__proto__ = DOMMatrixReadOnly;
    DOMMatrix.prototype = Object.create(DOMMatrixReadOnly && DOMMatrixReadOnly.prototype);
    DOMMatrix.prototype.constructor = DOMMatrix;

    var prototypeAccessors = { a: {}, b: {}, c: {}, d: {}, e: {}, f: {}, m11: {}, m12: {}, m13: {}, m14: {}, m21: {}, m22: {}, m23: {}, m24: {}, m31: {}, m32: {}, m33: {}, m34: {}, m41: {}, m42: {}, m43: {}, m44: {} };

    // Mutable transform methods
    DOMMatrix.prototype.multiplySelf = function multiplySelf(other) {
        if (!(other instanceof DOMMatrix)) {
            throw new Error('The argument to multiplySelf must be an instance of DOMMatrix');
        }

        // TODO: avoid creating a new array, just apply values directly.
        (0, _utilities.multiplyAndApply)(this, other, this);

        if (!other.is2D) {
            this._is2D = false;
        }

        return this;
    };

    DOMMatrix.prototype.preMultiplySelf = function preMultiplySelf(other) {
        if (!(other instanceof DOMMatrix)) {
            throw new Error('The argument to multiplySelf must be an instance of DOMMatrix');
        }

        // TODO: avoid creating a new array, just apply values directly.
        (0, _utilities.multiplyAndApply)(other, this, this);

        if (!other.is2D) {
            this._is2D = false;
        }

        return this;
    };

    DOMMatrix.prototype.translateSelf = function translateSelf(tx, ty, tz) {
        if (tz === void 0) tz = 0;

        // TODO: check args are numbers

        if (arguments.length === 1) {
            throw new Error('The first two arguments (X and Y translation values) are required (the third, Z translation, is optional).');
        }

        // http://www.w3.org/TR/2012/WD-css3-transforms-20120911/#Translate3dDefined
        const translationMatrix = new DOMMatrix([
        // column-major:
        1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, tx, ty, tz, 1]);

        this.multiplySelf(translationMatrix);

        if (tz != 0) {
            this._is2D = false;
        }

        return this;
    };

    DOMMatrix.prototype.scaleSelf = function scaleSelf(scale, originX, originY) {
        if (originX === void 0) originX = 0;
        if (originY === void 0) originY = 0;

        this.translateSelf(originX, originY);

        this.multiplySelf(new DOMMatrix([
        // 2D:
        /*a*/scale, /*b*/0,
        /*c*/0, /*d*/scale,
        /*e*/0, /*f*/0]));

        this.translateSelf(-originX, -originY);
        return this;
    };

    DOMMatrix.prototype.scale3dSelf = function scale3dSelf(scale, originX, originY, originZ) {
        if (originX === void 0) originX = 0;
        if (originY === void 0) originY = 0;
        if (originZ === void 0) originZ = 0;

        this.translateSelf(originX, originY, originZ);

        this.multiplySelf(new DOMMatrix([
        // 3D
        scale, 0, 0, 0, 0, scale, 0, 0, 0, 0, scale, 0, 0, 0, 0, 1]));

        this.translateSelf(-originX, -originY, -originZ);
        return this;
    };

    DOMMatrix.prototype.scaleNonUniformSelf = function scaleNonUniformSelf(scaleX, scaleY, scaleZ, originX, originY, originZ) {
        if (scaleY === void 0) scaleY = 1;
        if (scaleZ === void 0) scaleZ = 1;
        if (originX === void 0) originX = 0;
        if (originY === void 0) originY = 0;
        if (originZ === void 0) originZ = 0;

        this.translateSelf(originX, originY, originZ);

        this.multiplySelf(new DOMMatrix([
        // 3D
        scaleX, 0, 0, 0, 0, scaleY, 0, 0, 0, 0, scaleZ, 0, 0, 0, 0, 1]));

        this.translateSelf(-originX, -originY, -originZ);

        if (scaleZ !== 1 || originZ !== 0) {
            this._is2D = false;
        }

        return this;
    };

    DOMMatrix.prototype.rotateSelf = function rotateSelf(angle, originX, originY) {
        if (originX === void 0) originX = 0;
        if (originY === void 0) originY = 0;

        this.translateSelf(originX, originY);

        // axis of rotation
        var ref = [0, 0, 1];
        var x = ref[0];
        var y = ref[1];
        var z = ref[2]; // We're rotating around the Z axis.

        this.rotateAxisAngleSelf(x, y, z, angle);

        this.translateSelf(-originX, -originY);
        return this;
    };

    // TODO
    DOMMatrix.prototype.rotateFromVectorSelf = function rotateFromVectorSelf(x, y) {
        throw new Error('rotateFromVectorSelf is not implemented yet.');
    };

    DOMMatrix.prototype.rotateAxisAngleSelf = function rotateAxisAngleSelf(x, y, z, angle) {
        const rotationMatrix = new DOMMatrix((0, _utilities.rotateAxisAngleArray)(x, y, z, angle));
        this.multiplySelf(rotationMatrix);
        return this;
    };

    DOMMatrix.prototype.skewXSelf = function skewXSelf(sx) {
        throw new Error('skewXSelf is not implemented yet.');
    };

    DOMMatrix.prototype.skewYSelf = function skewYSelf(sy) {
        throw new Error('skewYSelf is not implemented yet.');
    };

    DOMMatrix.prototype.invertSelf = function invertSelf() {
        throw new Error('invertSelf is not implemented yet.');
    };

    DOMMatrix.prototype.setMatrixValue = function setMatrixValue( /*DOMString*/transformList) {
        throw new Error('setMatrixValue is not implemented yet.');
    };

    prototypeAccessors.a.get = function () {
        return this.m11;
    };
    prototypeAccessors.b.get = function () {
        return this.m12;
    };
    prototypeAccessors.c.get = function () {
        return this.m21;
    };
    prototypeAccessors.d.get = function () {
        return this.m22;
    };
    prototypeAccessors.e.get = function () {
        return this.m41;
    };
    prototypeAccessors.f.get = function () {
        return this.m42;
    };

    prototypeAccessors.m11.get = function () {
        return this._matrix[0];
    };
    prototypeAccessors.m12.get = function () {
        return this._matrix[4];
    };
    prototypeAccessors.m13.get = function () {
        return this._matrix[8];
    };
    prototypeAccessors.m14.get = function () {
        return this._matrix[12];
    };

    prototypeAccessors.m21.get = function () {
        return this._matrix[1];
    };
    prototypeAccessors.m22.get = function () {
        return this._matrix[5];
    };
    prototypeAccessors.m23.get = function () {
        return this._matrix[9];
    };
    prototypeAccessors.m24.get = function () {
        return this._matrix[13];
    };

    prototypeAccessors.m31.get = function () {
        return this._matrix[2];
    };
    prototypeAccessors.m32.get = function () {
        return this._matrix[6];
    };
    prototypeAccessors.m33.get = function () {
        return this._matrix[10];
    };
    prototypeAccessors.m34.get = function () {
        return this._matrix[14];
    };

    prototypeAccessors.m41.get = function () {
        return this._matrix[3];
    };
    prototypeAccessors.m42.get = function () {
        return this._matrix[7];
    };
    prototypeAccessors.m43.get = function () {
        return this._matrix[11];
    };
    prototypeAccessors.m44.get = function () {
        return this._matrix[15];
    };

    prototypeAccessors.a.set = function (value) {
        this.m11 = value;
    };
    prototypeAccessors.b.set = function (value) {
        this.m12 = value;
    };
    prototypeAccessors.c.set = function (value) {
        this.m21 = value;
    };
    prototypeAccessors.d.set = function (value) {
        this.m22 = value;
    };
    prototypeAccessors.e.set = function (value) {
        this.m41 = value;
    };
    prototypeAccessors.f.set = function (value) {
        this.m42 = value;
    };

    prototypeAccessors.m11.set = function (value) {
        this._matrix[0] = value;
    };
    prototypeAccessors.m12.set = function (value) {
        this._matrix[4] = value;
    };
    prototypeAccessors.m13.set = function (value) {
        this._matrix[8] = value;
    };
    prototypeAccessors.m14.set = function (value) {
        this._matrix[12] = value;
    };

    prototypeAccessors.m21.set = function (value) {
        this._matrix[1] = value;
    };
    prototypeAccessors.m22.set = function (value) {
        this._matrix[5] = value;
    };
    prototypeAccessors.m23.set = function (value) {
        this._matrix[9] = value;
    };
    prototypeAccessors.m24.set = function (value) {
        this._matrix[13] = value;
    };

    prototypeAccessors.m31.set = function (value) {
        this._matrix[2] = value;
    };
    prototypeAccessors.m32.set = function (value) {
        this._matrix[6] = value;
    };
    prototypeAccessors.m33.set = function (value) {
        this._matrix[10] = value;
    };
    prototypeAccessors.m34.set = function (value) {
        this._matrix[14] = value;
    };

    prototypeAccessors.m41.set = function (value) {
        this._matrix[3] = value;
    };
    prototypeAccessors.m42.set = function (value) {
        this._matrix[7] = value;
    };
    prototypeAccessors.m43.set = function (value) {
        this._matrix[11] = value;
    };
    prototypeAccessors.m44.set = function (value) {
        this._matrix[15] = value;
    };

    Object.defineProperties(DOMMatrix.prototype, prototypeAccessors);

    return DOMMatrix;
}(_DOMMatrixReadOnly2.default);

exports.default = DOMMatrix;
//# sourceMappingURL=DOMMatrix.js.map