'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
let privatesMap;
const _ = function (o) {
    if (!privatesMap) {
        privatesMap = new WeakMap();
        let privates = {};
        privatesMap.set(o, privates);
        return privates;
    } else {
        let privates = privatesMap.get(o);

        if (privates === undefined) {
            privates = {};
            privatesMap.set(o, privates);
        }

        return privates;
    }
};

var DOMPointReadOnly = exports.DOMPointReadOnly = function DOMPointReadOnly(x, y, z, w) {
    if (arguments.length === 1) {
        if (!isDOMPointInit(x)) {
            throw new TypeError('Expected an object with x, y, z, and w properties');
        }

        _(this).x = x.x;
        _(this).y = x.y;
        _(this).z = x.z;
        _(this).w = x.w;
    } else if (arguments.length === 4) {
        _(this).x = x || 0;
        _(this).y = y || 0;
        _(this).z = z || 0;
        _(this).w = w || 0;
    } else {
        throw new TypeError('Expected 1 or 4 arguments');
    }
};

var prototypeAccessors = { x: {}, y: {}, z: {}, w: {} };

prototypeAccessors.x.get = function () {
    return _(this).x;
};
prototypeAccessors.y.get = function () {
    return _(this).y;
};
prototypeAccessors.z.get = function () {
    return _(this).z;
};
prototypeAccessors.w.get = function () {
    return _(this).w;
};

DOMPointReadOnly.prototype.matrixTransform = function matrixTransform(matrix) {
    let result = new this.constructor(this);
    // TODO
    //const x
    //const y
    //const z
    //const w

    return result;
};

DOMPointReadOnly.fromPoint = function fromPoint(other) {
    return new this(other);
};

Object.defineProperties(DOMPointReadOnly.prototype, prototypeAccessors);

var DOMPoint = exports.DOMPoint = function (DOMPointReadOnly) {
    function DOMPoint() {
        DOMPointReadOnly.apply(this, arguments);
    }

    if (DOMPointReadOnly) DOMPoint.__proto__ = DOMPointReadOnly;
    DOMPoint.prototype = Object.create(DOMPointReadOnly && DOMPointReadOnly.prototype);
    DOMPoint.prototype.constructor = DOMPoint;

    var prototypeAccessors$1 = { x: {}, y: {}, z: {}, w: {} };

    prototypeAccessors$1.x.set = function (value) {
        _(this).x = value;
    };
    prototypeAccessors$1.y.set = function (value) {
        _(this).y = value;
    };
    prototypeAccessors$1.z.set = function (value) {
        _(this).z = value;
    };
    prototypeAccessors$1.w.set = function (value) {
        _(this).w = value;
    };

    Object.defineProperties(DOMPoint.prototype, prototypeAccessors$1);

    return DOMPoint;
}(DOMPointReadOnly);

exports.default = DOMPoint;


function isDOMPointInit(o) {
    if (typeof o != 'object') {
        return false;
    }

    if ('x' in o && 'y' in o && 'z' in o && 'w' in o) {
        return true;
    }

    return false;
}
//# sourceMappingURL=DOMPoint.js.map