import DOMMatrix from './DOMMatrix'
import DOMMatrixReadOnly from './DOMMatrixReadOnly'
import {DOMPoint, DOMPointReadOnly} from './DOMPoint'

let _global = null

// browser
if (typeof window != 'undefined') {
    _global = window
}
else if (typeof global != 'undefined') {
    _global = global
}

if (_global) {
    _global.DOMMatrix = DOMMatrix
    _global.DOMMatrixReadOnly = DOMMatrixReadOnly
    _global.DOMPoint = DOMPoint
    _global.DOMPointReadOnly = DOMPointReadOnly
}

export {
    DOMMatrix,
    DOMMatrixReadOnly,
    DOMPoint,
    DOMPointReadOnly,
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbmRleC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgRE9NTWF0cml4IGZyb20gJy4vRE9NTWF0cml4J1xuaW1wb3J0IERPTU1hdHJpeFJlYWRPbmx5IGZyb20gJy4vRE9NTWF0cml4UmVhZE9ubHknXG5pbXBvcnQge0RPTVBvaW50LCBET01Qb2ludFJlYWRPbmx5fSBmcm9tICcuL0RPTVBvaW50J1xuXG5sZXQgX2dsb2JhbCA9IG51bGxcblxuLy8gYnJvd3NlclxuaWYgKHR5cGVvZiB3aW5kb3cgIT0gJ3VuZGVmaW5lZCcpIHtcbiAgICBfZ2xvYmFsID0gd2luZG93XG59XG5lbHNlIGlmICh0eXBlb2YgZ2xvYmFsICE9ICd1bmRlZmluZWQnKSB7XG4gICAgX2dsb2JhbCA9IGdsb2JhbFxufVxuXG5pZiAoX2dsb2JhbCkge1xuICAgIF9nbG9iYWwuRE9NTWF0cml4ID0gRE9NTWF0cml4XG4gICAgX2dsb2JhbC5ET01NYXRyaXhSZWFkT25seSA9IERPTU1hdHJpeFJlYWRPbmx5XG4gICAgX2dsb2JhbC5ET01Qb2ludCA9IERPTVBvaW50XG4gICAgX2dsb2JhbC5ET01Qb2ludFJlYWRPbmx5ID0gRE9NUG9pbnRSZWFkT25seVxufVxuXG5leHBvcnQge1xuICAgIERPTU1hdHJpeCxcbiAgICBET01NYXRyaXhSZWFkT25seSxcbiAgICBET01Qb2ludCxcbiAgICBET01Qb2ludFJlYWRPbmx5LFxufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sU0FBUyxNQUFNLGFBQWE7QUFDbkMsT0FBTyxpQkFBaUIsTUFBTSxxQkFBcUI7QUFDbkQsUUFBUSxRQUFRLEVBQUUsZ0JBQWdCLE9BQU8sWUFBWTs7QUFFckQsSUFBSSxPQUFPLEdBQUcsSUFBSTs7O0FBR2xCLElBQUksT0FBTyxNQUFNLElBQUksV0FBVyxFQUFFO0lBQzlCLE9BQU8sR0FBRyxNQUFNO0NBQ25CO0tBQ0ksSUFBSSxPQUFPLE1BQU0sSUFBSSxXQUFXLEVBQUU7SUFDbkMsT0FBTyxHQUFHLE1BQU07Q0FDbkI7O0FBRUQsSUFBSSxPQUFPLEVBQUU7SUFDVCxPQUFPLENBQUMsU0FBUyxHQUFHLFNBQVM7SUFDN0IsT0FBTyxDQUFDLGlCQUFpQixHQUFHLGlCQUFpQjtJQUM3QyxPQUFPLENBQUMsUUFBUSxHQUFHLFFBQVE7SUFDM0IsT0FBTyxDQUFDLGdCQUFnQixHQUFHLGdCQUFnQjtDQUM5Qzs7QUFFRDtJQUNJLFNBQVM7SUFDVCxpQkFBaUI7SUFDakIsUUFBUTtJQUNSLGdCQUFnQjtDQUNuQjsifQ==