"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var yaml_1 = require("./yaml");
var fs = require("fs-extra");
var dotenv = require("dotenv");
var path = require("path");
var jwt = require("jsonwebtoken");
var Cluster_1 = require("./Cluster");
var chalk_1 = require("chalk");
var yamlComment_1 = require("./utils/yamlComment");
var DefinitionMigrator_1 = require("./utils/DefinitionMigrator");
var parseEndpoint_1 = require("./utils/parseEndpoint");
var debug = require('debug')('prisma definition');
var PrismaDefinitionClass = /** @class */ (function () {
    function PrismaDefinitionClass(env, definitionPath, envVars, out) {
        if (envVars === void 0) { envVars = process.env; }
        this.secrets = null;
        this.definitionPath = definitionPath;
        if (definitionPath) {
            this.definitionDir = path.dirname(definitionPath);
        }
        this.env = env;
        this.out = out;
        this.envVars = envVars;
    }
    PrismaDefinitionClass.prototype.load = function (args, envPath) {
        return __awaiter(this, void 0, void 0, function () {
            var migrator, migrated;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (envPath) {
                            if (!fs.pathExistsSync(envPath)) {
                                envPath = path.join(process.cwd(), envPath);
                            }
                            if (!fs.pathExistsSync(envPath)) {
                                throw new Error("--env-file path '" + envPath + "' does not exist");
                            }
                        }
                        dotenv.config({ path: envPath });
                        if (!this.definitionPath) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.loadDefinition(args)];
                    case 1:
                        _a.sent();
                        migrator = new DefinitionMigrator_1.DefinitionMigrator(this);
                        migrated = migrator.migrate(this.definitionPath);
                        if (!migrated) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.loadDefinition(args)];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        this.validate();
                        return [3 /*break*/, 5];
                    case 4: throw new Error("Couldn\u2019t find `prisma.yml` file. Are you in the right directory?");
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    PrismaDefinitionClass.prototype.loadDefinition = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, definition, rawJson, secrets;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, yaml_1.readDefinition(this.definitionPath, args, this.out, this.envVars)];
                    case 1:
                        _a = _b.sent(), definition = _a.definition, rawJson = _a.rawJson;
                        this.definition = definition;
                        this.rawJson = rawJson;
                        this.definitionString = fs.readFileSync(this.definitionPath, 'utf-8');
                        this.typesString = this.getTypesString(this.definition);
                        secrets = this.definition.secret;
                        this.secrets = secrets ? secrets.replace(/\s/g, '').split(',') : null;
                        return [2 /*return*/];
                }
            });
        });
    };
    Object.defineProperty(PrismaDefinitionClass.prototype, "endpoint", {
        get: function () {
            return ((this.definition && this.definition.endpoint) ||
                process.env.PRISMA_MANAGEMENT_API_ENDPOINT);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PrismaDefinitionClass.prototype, "clusterBaseUrl", {
        get: function () {
            if (!this.definition || this.definition.cluster || !this.endpoint) {
                return undefined;
            }
            var clusterBaseUrl = parseEndpoint_1.parseEndpoint(this.endpoint).clusterBaseUrl;
            return clusterBaseUrl;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PrismaDefinitionClass.prototype, "service", {
        get: function () {
            if (!this.definition) {
                return undefined;
            }
            if (this.definition.service) {
                return this.definition.service;
            }
            if (!this.endpoint) {
                return undefined;
            }
            var service = parseEndpoint_1.parseEndpoint(this.endpoint).service;
            return service;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PrismaDefinitionClass.prototype, "stage", {
        get: function () {
            if (!this.definition) {
                return undefined;
            }
            if (this.definition.stage) {
                return this.definition.stage;
            }
            if (!this.endpoint) {
                return undefined;
            }
            var stage = parseEndpoint_1.parseEndpoint(this.endpoint).stage;
            return stage;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PrismaDefinitionClass.prototype, "cluster", {
        get: function () {
            if (!this.definition) {
                return undefined;
            }
            if (this.definition.cluster) {
                return this.definition.cluster;
            }
            if (!this.endpoint) {
                return undefined;
            }
            var clusterName = parseEndpoint_1.parseEndpoint(this.endpoint).clusterName;
            return clusterName;
        },
        enumerable: true,
        configurable: true
    });
    PrismaDefinitionClass.prototype.validate = function () {
        // shared clusters need a workspace
        var clusterName = this.getClusterName();
        var cluster = this.env.clusterByName(clusterName);
        if (clusterName &&
            cluster &&
            cluster.shared &&
            !cluster.isPrivate &&
            !this.getWorkspace() &&
            clusterName !== 'shared-public-demo') {
            throw new Error("Your `cluster` property in the prisma.yml is missing the workspace slug.\nMake sure that your `cluster` property looks like this: " + chalk_1.default.bold('<workspace>/<cluster-name>') + ". You can also remove the cluster property from the prisma.yml\nand execute " + chalk_1.default.bold.green('prisma deploy') + " again, to get that value auto-filled.");
        }
        this.env.sharedClusters;
    };
    PrismaDefinitionClass.prototype.getToken = function (serviceName, stageName) {
        if (this.secrets) {
            var data = {
                data: {
                    service: serviceName + "@" + stageName,
                    roles: ['admin'],
                },
            };
            return jwt.sign(data, this.secrets[0], {
                expiresIn: '7d',
            });
        }
        return undefined;
    };
    PrismaDefinitionClass.prototype.getCluster = function (throws) {
        if (throws === void 0) { throws = false; }
        var clusterName = this.getClusterName();
        if (clusterName) {
            var cluster = this.env.clusterByName(clusterName);
            if (!cluster && clusterName !== 'local') {
                if (throws) {
                    throw new Error("Cluster " + clusterName + ", that is provided in the prisma.yml could not be found.\nIf it is a private cluster, make sure that you're logged in with " + chalk_1.default.bold.green('prisma login'));
                }
            }
            else if (cluster) {
                return cluster;
            }
        }
        if (this.definition && this.endpoint) {
            var _a = parseEndpoint_1.parseEndpoint(this.endpoint), clusterBaseUrl = _a.clusterBaseUrl, isPrivate = _a.isPrivate, local = _a.local, shared = _a.shared, workspaceSlug = _a.workspaceSlug, clusterName_1 = _a.clusterName;
            if (clusterBaseUrl) {
                debug('making cluster here');
                var cluster = new Cluster_1.Cluster(this.out, clusterName_1, clusterBaseUrl, shared ? this.env.cloudSessionKey : undefined, local, shared, isPrivate, workspaceSlug);
                this.env.removeCluster(clusterName_1);
                this.env.addCluster(cluster);
                return cluster;
            }
        }
        return undefined;
    };
    PrismaDefinitionClass.prototype.getTypesString = function (definition) {
        var _this = this;
        var typesPaths = Array.isArray(definition.datamodel)
            ? definition.datamodel
            : [definition.datamodel];
        var errors = [];
        var allTypes = '';
        typesPaths.forEach(function (unresolvedTypesPath) {
            var typesPath = path.join(_this.definitionDir, unresolvedTypesPath);
            if (fs.existsSync(typesPath)) {
                var types = fs.readFileSync(typesPath, 'utf-8');
                allTypes += types + '\n';
            }
            else {
                throw new Error("The types definition file \"" + typesPath + "\" could not be found.");
            }
        });
        return allTypes;
    };
    PrismaDefinitionClass.prototype.getClusterName = function () {
        if (this.definition && this.definition.cluster) {
            return this.definition.cluster.split('/').slice(-1)[0];
        }
        return this.cluster || null;
    };
    PrismaDefinitionClass.prototype.getWorkspace = function () {
        if (this.definition && this.definition.cluster) {
            var splitted = this.definition.cluster.split('/');
            if (splitted.length > 1) {
                return splitted[0];
            }
        }
        if (this.definition && this.endpoint) {
            var workspaceSlug = parseEndpoint_1.parseEndpoint(this.endpoint).workspaceSlug;
            if (workspaceSlug) {
                return workspaceSlug;
            }
        }
        return null;
    };
    PrismaDefinitionClass.prototype.getDeployName = function () {
        var cluster = this.getCluster();
        return concatName(cluster, this.definition.service, this.getWorkspace());
    };
    PrismaDefinitionClass.prototype.getSubscriptions = function () {
        var _this = this;
        if (this.definition && this.definition.subscriptions) {
            return Object.keys(this.definition.subscriptions).map(function (name) {
                var subscription = _this.definition.subscriptions[name];
                var url = typeof subscription.webhook === 'string'
                    ? subscription.webhook
                    : subscription.webhook.url;
                var headers = typeof subscription.webhook === 'string'
                    ? []
                    : transformHeaders(subscription.webhook.headers);
                var query = subscription.query;
                if (subscription.query.endsWith('.graphql')) {
                    var queryPath = path.join(_this.definitionDir, subscription.query);
                    if (!fs.pathExistsSync(queryPath)) {
                        throw new Error("Subscription query " + queryPath + " provided in subscription \"" + name + "\" in prisma.yml does not exist.");
                    }
                    query = fs.readFileSync(queryPath, 'utf-8');
                }
                return {
                    name: name,
                    query: query,
                    headers: headers,
                    url: url,
                };
            });
        }
        return [];
    };
    PrismaDefinitionClass.prototype.addCluster = function (cluster, args) {
        return __awaiter(this, void 0, void 0, function () {
            var newString;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!this.definition.cluster) return [3 /*break*/, 2];
                        this.definition.cluster = cluster;
                        newString = this.definitionString + ("\ncluster: " + cluster);
                        fs.writeFileSync(this.definitionPath, newString);
                        return [4 /*yield*/, this.load(args)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/];
                }
            });
        });
    };
    PrismaDefinitionClass.prototype.replaceEndpoint = function (newEndpoint) {
        this.definitionString = yamlComment_1.replaceYamlValue(this.definitionString, 'endpoint', newEndpoint);
        fs.writeFileSync(this.definitionPath, this.definitionString);
    };
    PrismaDefinitionClass.prototype.getEndpoint = function (serviceInput, stageInput) {
        var cluster = this.getCluster();
        var service = serviceInput || this.service;
        var stage = stageInput || this.stage;
        var workspace = this.getWorkspace();
        if (service && stage && cluster) {
            return cluster.getApiEndpoint(service, stage, workspace);
        }
        return null;
    };
    PrismaDefinitionClass.prototype.getHooks = function (hookType) {
        if (this.definition &&
            this.definition.hooks &&
            this.definition.hooks[hookType]) {
            var hooks = this.definition.hooks[hookType];
            if (typeof hooks !== 'string' && !Array.isArray(hooks)) {
                throw new Error("Hook " + hookType + " provided in prisma.yml must be string or an array of strings.");
            }
            return typeof hooks === 'string' ? [hooks] : hooks;
        }
        return [];
    };
    return PrismaDefinitionClass;
}());
exports.PrismaDefinitionClass = PrismaDefinitionClass;
function concatName(cluster, name, workspace) {
    if (cluster.shared) {
        var workspaceString = workspace ? workspace + "~" : '';
        return "" + workspaceString + name;
    }
    return name;
}
exports.concatName = concatName;
function transformHeaders(headers) {
    if (!headers) {
        return [];
    }
    return Object.keys(headers).map(function (key) { return ({
        name: key,
        value: headers[key],
    }); });
}
function getEndpointFromRawProps(clusterWorkspace, service, stage) {
    var splitted = clusterWorkspace.split('/');
    var cluster = splitted.length > 1 ? splitted[1] : splitted[0];
    var workspace = splitted.length > 1 ? splitted[0] : undefined;
}
exports.getEndpointFromRawProps = getEndpointFromRawProps;
//# sourceMappingURL=PrismaDefinition.js.map