"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Ajv = require("ajv");
var yaml = require("js-yaml");
var fs = require("fs-extra");
var schema = require("prisma-json-schema/dist/schema.json");
var Variables_1 = require("./Variables");
var Output_1 = require("./Output");
var debug = require('debug')('yaml');
var stringify = require("json-stable-stringify");
var ajv = new Ajv();
var validate = ajv.compile(schema);
var cache = {};
function readDefinition(filePath, args, out, envVars) {
    if (out === void 0) { out = new Output_1.Output(); }
    return __awaiter(this, void 0, void 0, function () {
        var file, json, jsonCopy, vars, populatedJson, valid, errorMessage;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!fs.pathExistsSync(filePath)) {
                        throw new Error(filePath + " could not be found.");
                    }
                    file = fs.readFileSync(filePath, 'utf-8');
                    json = yaml.safeLoad(file);
                    jsonCopy = __assign({}, json);
                    vars = new Variables_1.Variables(filePath, args, out, envVars);
                    return [4 /*yield*/, vars.populateJson(json)];
                case 1:
                    populatedJson = _a.sent();
                    if (populatedJson.custom) {
                        delete populatedJson.custom;
                    }
                    valid = validate(populatedJson);
                    // TODO activate as soon as the backend sends valid yaml
                    if (!valid) {
                        debugger;
                        errorMessage = "Invalid prisma.yml file" + '\n' + printErrors(validate.errors);
                        throw new Error(errorMessage);
                    }
                    cache[file] = populatedJson;
                    return [2 /*return*/, {
                            definition: populatedJson,
                            rawJson: jsonCopy,
                        }];
            }
        });
    });
}
exports.readDefinition = readDefinition;
function printErrors(errors, name) {
    if (name === void 0) { name = 'prisma.yml'; }
    return errors
        .map(function (e) {
        var paramsKey = stringify(e.params);
        if (betterMessagesByParams[paramsKey]) {
            return betterMessagesByParams[paramsKey];
        }
        var params = Object.keys(e.params)
            .map(function (key) { return key + ": " + e.params[key]; })
            .join(', ');
        debug(stringify(e.params));
        return "" + name + e.dataPath + " " + e.message + ". " + params;
    })
        .join('\n');
}
var betterMessagesByParams = {
    // this is not up-to-date, stages are in again!
    // https://github.com/prisma/framework/issues/1461
    '{"additionalProperty":"stages"}': 'prisma.yml should NOT have a "stages" property anymore. Stages are now just provided as CLI args.\nRead more here: https://goo.gl/SUD5i5',
    '{"additionalProperty":"types"}': 'prisma.yml should NOT have a "types" property anymore. It has been renamed to "datamodel"',
};
//# sourceMappingURL=yaml.js.map