'use strict';Object.defineProperty(exports, "__esModule", { value: true });var _jestGetType;









function _load_jestGetType() {return _jestGetType = _interopRequireDefault(require('jest-get-type'));}function _interopRequireDefault(obj) {return obj && obj.__esModule ? obj : { default: obj };} /**
                                                                                                                                                                                                     * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * This source code is licensed under the MIT license found in the
                                                                                                                                                                                                     * LICENSE file in the root directory of this source tree.
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * 
                                                                                                                                                                                                     */const RESERVED_KEYS = [0x03, // Jest should handle ctrl-c interrupt
'q'.codePointAt(0)];class WatchPluginRegistry {


  constructor(rootDir) {
    this._rootDir = rootDir;
    this._watchPluginsByKey = new Map();
  }

  loadPluginPath(pluginModulePath) {
    // $FlowFixMe dynamic require
    const maybePlugin = require(pluginModulePath);

    // Since we're loading the module from a dynamic path, assert its shape
    // before assuming it's a valid watch plugin.
    if ((0, (_jestGetType || _load_jestGetType()).default)(maybePlugin) !== 'object') {
      throw new Error(
      `Jest watch plugin ${pluginModulePath} must be an ES Module or export an object`);

    }
    if ((0, (_jestGetType || _load_jestGetType()).default)(maybePlugin.key) !== 'number') {
      throw new Error(
      `Jest watch plugin ${pluginModulePath} must export 'key' as a number`);

    }
    if ((0, (_jestGetType || _load_jestGetType()).default)(maybePlugin.prompt) !== 'string') {
      throw new Error(
      `Jest watch plugin ${pluginModulePath} must export 'prompt' as a string`);

    }
    if ((0, (_jestGetType || _load_jestGetType()).default)(maybePlugin.enter) !== 'function') {
      throw new Error(
      `Jest watch plugin ${pluginModulePath} must export 'enter' as a function`);

    }

    const plugin = maybePlugin;

    if (RESERVED_KEYS.includes(maybePlugin.key)) {
      throw new Error(
      `Jest watch plugin ${pluginModulePath} tried to register reserved key ${String.fromCodePoint(
      maybePlugin.key)
      }`);

    }
    // TODO: Reject registering when another plugin has claimed the key?
    this._watchPluginsByKey.set(plugin.key, plugin);
  }

  getPluginByPressedKey(pressedKey) {
    return this._watchPluginsByKey.get(pressedKey);
  }

  getPluginsOrderedByKey() {
    return Array.from(this._watchPluginsByKey.values()).sort(
    (a, b) => a.key - b.key);

  }}exports.default = WatchPluginRegistry;