/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */

'use strict';





module.exports = class Module {






  constructor(
  path,
  moduleCache,
  info)
  {
    this.hasteID = info.hasteID;
    this.moduleCache = moduleCache;
    this.name = this.hasteID || getName(path);
    this.path = path;
    this.type = 'Module';
  }

  readCached() {
    throw new Error('not implemented');
  }

  readFresh() {
    return Promise.reject(new Error('not implemented'));
  }

  getName() {
    return this.name;
  }

  getPackage() {
    return this.moduleCache.getPackageOf(this.path);
  }

  isHaste() {
    return Boolean(this.hasteID);
  }

  hash() {
    throw new Error('not implemented');
  }};


function getName(path) {
  return path.replace(/^.*[\/\\]node_modules[\///]/, '');
}