import { ImportData, RelationTuple, RelationNode } from './types';
import { DocumentNode, ObjectTypeDefinitionNode, FieldDefinitionNode } from 'graphql';
export interface Mapping {
    [typeName: string]: {
        [key: string]: string;
    };
}
export interface FieldsMap {
    [name: string]: FieldDefinitionNode;
}
export interface Types {
    [typeName: string]: {
        definition: ObjectTypeDefinitionNode;
        fields: FieldsMap;
        requiredNonRelationScalarFieldNames: string[];
        requiredNonRelationListFieldNames: string[];
        allNonRelationListFieldNames: string[];
        allNonRelationScalarFieldNames: string[];
    };
}
export interface Enums {
    [enumName: string]: string[];
}
export declare class Validator {
    typesString: string;
    ast: DocumentNode;
    types: Types;
    enums: Enums;
    mapping: Mapping;
    validators: {
        [key: string]: (type: any) => boolean;
    };
    modelTypes: {
        [key: string]: boolean;
    };
    constructor(typesString: string);
    validateImportData(data: ImportData): true;
    validateNode(obj: any): true;
    validateListNode(obj: any): true;
    validateRelationNode(node: RelationNode): true;
    validateRelationTuple(tuple: RelationTuple): true;
    private checkFieldName(node);
    private collectModelTypes(ast);
    private astToTypes(ast);
    private astToEnums(ast);
    private makeEnumValidators(enums);
    private getFieldNames(definition, requiredOnly?, listsOnly?);
    private resolveFieldName(typeName, fieldName);
    private checkTypeName(obj);
    private checkIdField(obj);
    private checkRequiredFields(obj, listsOnly);
    private checkUnknownFields(obj, includeLists);
    private checkType(obj, listsOnly);
    private validateValue(value, field, listsOnly);
    private validateScalarValue(value, field);
    private getDeepType(field);
    private isList(field);
}
