"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var prisma_cli_engine_1 = require("prisma-cli-engine");
var fs = require("fs-extra");
var path = require("path");
var chalk_1 = require("chalk");
var debug = require('debug')('init');
var EndpointDialog_1 = require("../../utils/EndpointDialog");
var dockerComposeInstalled_1 = require("../../utils/dockerComposeInstalled");
var Init = /** @class */ (function (_super) {
    __extends(Init, _super);
    function Init() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Init.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            var dirName, newDefinitionDir;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dirName = this.args.dirName;
                        if (dirName) {
                            newDefinitionDir = path.join(this.config.cwd, dirName + '/');
                            this.config.definitionDir = newDefinitionDir;
                            fs.mkdirpSync(newDefinitionDir);
                        }
                        else {
                            this.config.definitionDir = this.config.cwd;
                        }
                        return [4 /*yield*/, this.runInit()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Init.prototype.runInit = function () {
        return __awaiter(this, void 0, void 0, function () {
            var files, endpointDialog, results, relativeDir, definitionPath, prismaYml, newPrismaYml, dir, dirString, isLocal, dbType, beautifulDbTypesMap, beautifulDbType, steps, createdFiles, dockerComposeInstalled;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        files = fs.readdirSync(this.config.definitionDir);
                        // the .prismarc must be allowed for the docker version to be functioning
                        // CONTINUE: special env handling for dockaa. can't just override the host/dinges
                        if (files.length > 0 &&
                            (files.includes('prisma.yml') ||
                                files.includes('datamodel.graphql') ||
                                files.includes('docker-compose.yml'))) {
                            this.out.log("\nThe directory " + chalk_1.default.cyan(this.config.definitionDir) + " contains files that could conflict:\n\n" + files.map(function (f) { return "  " + f; }).join('\n') + "\n\nEither try using a new directory name, or remove the files listed above.\n      ");
                            this.out.exit(1);
                        }
                        endpointDialog = new EndpointDialog_1.EndpointDialog(this.out, this.client, this.env, this.config);
                        return [4 /*yield*/, endpointDialog.getEndpoint()];
                    case 1:
                        results = _a.sent();
                        fs.copySync(path.join(__dirname, 'boilerplate', 'prisma.yml'), path.join(this.config.definitionDir, 'prisma.yml'));
                        fs.writeFileSync(path.join(this.config.definitionDir, 'datamodel.graphql'), results.datamodel);
                        if (results.cluster.local && results.writeDockerComposeYml) {
                            fs.writeFileSync(path.join(this.config.definitionDir, 'docker-compose.yml'), results.dockerComposeYml);
                        }
                        if (results.managementSecret) {
                            fs.writeFileSync(path.join(this.config.definitionDir, '.env'), "PRISMA_MANAGEMENT_API_SECRET=" + results.managementSecret);
                        }
                        relativeDir = path.relative(this.config.cwd, this.config.definitionDir);
                        relativeDir = relativeDir.length === 0 ? '.' : relativeDir;
                        definitionPath = path.join(this.config.definitionDir, 'prisma.yml');
                        prismaYml = fs.readFileSync(definitionPath, 'utf-8');
                        newPrismaYml = prismaYml.replace('ENDPOINT', results.endpoint);
                        fs.writeFileSync(definitionPath, newPrismaYml);
                        dir = this.args.dirName;
                        dirString = dir
                            ? "Open the new folder via " + chalk_1.default.cyan("$ cd " + dir) + ".\n"
                            : "";
                        isLocal = results.cluster.local && results.writeDockerComposeYml;
                        dbType = results.database ? results.database.type : '';
                        beautifulDbTypesMap = {
                            mysql: 'MySQL',
                            postgres: 'PostgreSQL',
                        };
                        beautifulDbType = beautifulDbTypesMap[dbType] || '';
                        steps = [];
                        if (dir) {
                            steps.push("Open folder: " + chalk_1.default.cyan("cd " + dir));
                        }
                        if (results.cluster.local && results.writeDockerComposeYml) {
                            steps.push("Start your Prisma server: " + chalk_1.default.cyan('docker-compose up -d'));
                        }
                        steps.push("Deploy your Prisma service: " + chalk_1.default.cyan('prisma deploy'));
                        if (results.database && results.database.alreadyData) {
                            steps.push("Read more about introspection:\n     http://bit.ly/prisma-introspection");
                        }
                        else if ((results.database && !results.database.alreadyData) ||
                            results.newDatabase) {
                            steps.push("Read more about Prisma server:\n     http://bit.ly/prisma-server-overview");
                        }
                        else {
                            steps.push("Read more about deploying services:\n     http://bit.ly/prisma-deploy-services");
                        }
                        createdFiles = [
                            "  " + chalk_1.default.cyan('prisma.yml') + "           Prisma service definition",
                            "  " + chalk_1.default.cyan('datamodel.graphql') + "    GraphQL SDL-based datamodel (foundation for database)",
                        ];
                        if (isLocal) {
                            createdFiles.push("  " + chalk_1.default.cyan('docker-compose.yml') + "   Docker configuration file");
                        }
                        if (results.managementSecret) {
                            createdFiles.push("  " + chalk_1.default.cyan('.env') + "                 Env file including PRISMA_API_MANAGEMENT_SECRET");
                        }
                        this.out.log("\n" + chalk_1.default.bold("Created " + createdFiles.length + " new files:                                                                          ") + "\n\n" + createdFiles.join('\n') + "\n\n" + chalk_1.default.bold('Next steps:') + "\n\n" + steps.map(function (step, index) { return "  " + (index + 1) + ". " + step; }).join('\n'));
                        return [4 /*yield*/, dockerComposeInstalled_1.isDockerComposeInstalled()];
                    case 2:
                        dockerComposeInstalled = _a.sent();
                        if (!dockerComposeInstalled) {
                            this.out.log("\nTo install docker-compose, please follow this link: " + chalk_1.default.cyan('https://docs.docker.com/compose/install/'));
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    Init.topic = 'init';
    Init.description = 'Initialize a new service';
    Init.args = [
        {
            name: 'dirName',
            description: 'Folder to initialize in (optional)',
        },
    ];
    Init.flags = {};
    return Init;
}(prisma_cli_engine_1.Command));
exports.default = Init;
//# sourceMappingURL=index.js.map