"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var prisma_cli_engine_1 = require("prisma-cli-engine");
var EndpointDialog_1 = require("../../utils/EndpointDialog");
var prisma_db_introspection_1 = require("prisma-db-introspection");
var path = require("path");
var fs = require("fs");
var util_1 = require("../../util");
var chalk_1 = require("chalk");
var IntrospectCommand = /** @class */ (function (_super) {
    __extends(IntrospectCommand, _super);
    function IntrospectCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    IntrospectCommand.prototype.run = function () {
        return __awaiter(this, void 0, void 0, function () {
            var endpointDialog, credentials, introspector, schemas, before, e_1, _a, sdl, numTables, fileName, fullFileName;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.definition.load(this.flags)];
                    case 1:
                        _b.sent();
                        endpointDialog = new EndpointDialog_1.EndpointDialog(this.out, this.client, this.env, this.config);
                        return [4 /*yield*/, endpointDialog.getDatabase(true)];
                    case 2:
                        credentials = _b.sent();
                        introspector = new prisma_db_introspection_1.Introspector(credentials);
                        before = Date.now();
                        this.out.action.start("Introspecting database");
                        _b.label = 3;
                    case 3:
                        _b.trys.push([3, 5, , 6]);
                        return [4 /*yield*/, introspector.listSchemas()];
                    case 4:
                        schemas = _b.sent();
                        return [3 /*break*/, 6];
                    case 5:
                        e_1 = _b.sent();
                        throw new Error("Could not connect to database. " + e_1.message);
                    case 6:
                        if (!(schemas && schemas.length > 0)) return [3 /*break*/, 8];
                        return [4 /*yield*/, introspector.introspect(schemas[0])];
                    case 7:
                        _a = _b.sent(), sdl = _a.sdl, numTables = _a.numTables;
                        if (numTables === 0) {
                            this.out.log(chalk_1.default.red("\n" + chalk_1.default.bold('Error: ') + "The provided database doesn't contain any tables. Please provide another database."));
                            this.out.exit(1);
                        }
                        fileName = "datamodel-" + new Date().getTime() + ".graphql";
                        fullFileName = path.join(this.config.definitionDir, fileName);
                        fs.writeFileSync(fullFileName, sdl);
                        this.out.action.stop(util_1.prettyTime(Date.now() - before));
                        this.out.log("Created datamodel definition based on " + numTables + " database tables.");
                        this.out.log(chalk_1.default.bold('Created 1 new file:') + "    GraphQL SDL-based datamodel (derived from existing database)\n\n  " + chalk_1.default.cyan(fileName) + "\n");
                        return [3 /*break*/, 9];
                    case 8: throw new Error("Could not find schema in provided database.");
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    IntrospectCommand.topic = 'introspect';
    IntrospectCommand.description = 'Introspect database schema(s) of service';
    IntrospectCommand.flags = {};
    IntrospectCommand.hidden = false;
    return IntrospectCommand;
}(prisma_cli_engine_1.Command));
exports.default = IntrospectCommand;
//# sourceMappingURL=introspect.js.map