import { Output, Config } from 'prisma-cli-engine';
import { Environment, Cluster } from 'prisma-yml';
export default class Docker {
    out: Output;
    env: Environment;
    config: Config;
    cluster?: Cluster;
    ymlPath: string;
    frameworkYmlPath: string;
    envPath: string;
    frameworkEnvPath: string;
    envVars: {
        [varName: string]: string;
    };
    clusterName: string;
    privateKey?: string;
    stdout?: string;
    psResult?: string;
    constructor(out: Output, config: Config, env: Environment, clusterName: string);
    readonly hostName: string;
    init(): Promise<void>;
    saveCluster(): Cluster;
    /**
     * returns true, if higher port should be used
     * @param port original port
     * @param higherPort alternative port
     */
    askIfDBPortShouldBeUnblocked(port: string): Promise<void>;
    /**
     * returns true, if higher port should be used
     * @param port original port
     * @param higherPort alternative port
     */
    askForHigherPort(port: string, higherPort: string): Promise<boolean>;
    up(): Promise<Docker>;
    ps(): Promise<Docker>;
    start(): Promise<Docker>;
    stop(): Promise<Docker>;
    restart(): Promise<Docker>;
    pull(): Promise<Docker>;
    kill(): Promise<Docker>;
    down(): Promise<Docker>;
    logs(): Promise<Docker>;
    nuke(): Promise<Docker>;
    getDockerEnvVars(db?: boolean): {};
    parseEnv(src: string): {};
    setEnvVars(port: string, dbPort: string): Promise<void>;
    setKeyPair(): Promise<void>;
    stopContainersBlockingPort(port: string, nuke?: boolean, kill?: boolean): Promise<void>;
    nukeContainers(name: string, isDB?: boolean): Promise<void>;
    private parsePs(output);
    private run(...argv);
    private getBin();
    private format(data);
}
