/**
 * Copyright (c) 2015-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
var chalk = require('chalk');
var execSync = require('child_process').execSync;
var path = require('path');
var execOptions = {
    encoding: 'utf8',
    stdio: [
        'pipe',
        'pipe',
        'ignore',
    ],
};
function getProcessIdOnPort(port) {
    return execSync('lsof -i:' + port + ' -P -t -sTCP:LISTEN', execOptions)
        .split('\n')[0]
        .trim();
}
function getProcessCommand(processId, processDirectory) {
    var command = execSync('ps -o command -p ' + processId + ' | sed -n 2p', execOptions);
    if (command.includes('docker')) {
        return 'docker';
    }
    command = command.replace(/\n$/, '');
}
function getDirectoryOfProcessById(processId) {
    return execSync('lsof -p ' + processId + ' | awk \'$4=="cwd" {print $9}\'', execOptions).trim();
}
function getProcessForPort(port) {
    try {
        var processId = getProcessIdOnPort(port);
        var directory = getDirectoryOfProcessById(processId);
        var command = getProcessCommand(processId, directory);
        return {
            command: command,
            processId: processId,
        };
    }
    catch (e) {
        // console.error(e)
        return null;
    }
}
exports.getProcessForPort = getProcessForPort;
exports.printProcess = function (_a) {
    var command = _a.command, processId = _a.processId;
    return chalk.cyan(command) + chalk.grey(' (pid ' + processId + ')');
};
//# sourceMappingURL=getProcessForPort.js.map