"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var prisma_cli_engine_1 = require("prisma-cli-engine");
var inquirer = require("inquirer");
var chalk_1 = require("chalk");
var prisma_yml_1 = require("prisma-yml");
var util_1 = require("../util");
var sillyname = require("sillyname");
var path = require("path");
var fs = require("fs");
var prisma_db_introspection_1 = require("prisma-db-introspection");
var yaml = require("js-yaml");
var encodeMap = {
    'prisma-eu1': 'demo-eu1',
    'prisma-us1': 'demo-us1',
};
var decodeMap = {
    'demo-eu1': 'prisma-eu1',
    'demo-us1': 'prisma-us1',
};
var defaultPorts = {
    postgres: 5432,
    mysql: 3306,
};
var databaseServiceDefinitions = {
    postgres: "\n  postgres:\n    image: postgres\n    restart: always\n    environment:\n      POSTGRES_USER: prisma\n      POSTGRES_PASSWORD: prisma\n    volumes:\n      - postgres:/var/lib/postgresql/data\nvolumes:\n  postgres:\n",
    mysql: "\n  mysql:\n    image: mysql:5.7\n    restart: always\n    environment:\n      MYSQL_ROOT_PASSWORD: prisma\n    volumes:\n      - mysql:/var/lib/mysql\nvolumes:\n  mysql:\n",
};
var EndpointDialog = /** @class */ (function () {
    function EndpointDialog(out, client, env, config) {
        var _this = this;
        this.getClusterChoice = function (c) {
            return [_this.getClusterName(c), _this.getClusterDescription(c)];
        };
        this.out = out;
        this.client = client;
        this.env = env;
        this.config = config;
    }
    EndpointDialog.prototype.getEndpoint = function () {
        return __awaiter(this, void 0, void 0, function () {
            var localClusterRunning, folderName, loggedIn, clusters, files, hasDockerComposeYml, question, choice;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.isClusterOnline('http://localhost:4466')];
                    case 1:
                        localClusterRunning = _a.sent();
                        folderName = path.basename(this.config.definitionDir);
                        return [4 /*yield*/, this.client.isAuthenticated()];
                    case 2:
                        loggedIn = _a.sent();
                        clusters = this.getCloudClusters();
                        files = this.listFiles();
                        hasDockerComposeYml = files.includes('docker-compose.yml');
                        question = this.getClusterQuestion(!loggedIn && !localClusterRunning, hasDockerComposeYml, clusters);
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 3:
                        choice = (_a.sent()).choice;
                        return [2 /*return*/, this.handleChoice({
                                choice: this.decodeName(choice),
                                loggedIn: loggedIn,
                                folderName: folderName,
                                localClusterRunning: localClusterRunning,
                                clusters: clusters,
                            })];
                }
            });
        });
    };
    EndpointDialog.prototype.encodeName = function (name) {
        return encodeMap[name] || name;
    };
    EndpointDialog.prototype.decodeName = function (name) {
        var replaced = name;
        Object.keys(decodeMap).forEach(function (item) {
            if (replaced.includes(item)) {
                replaced = replaced.replace(item, decodeMap[item]);
            }
        });
        return replaced;
    };
    EndpointDialog.prototype.printDatabaseConfig = function (credentials) {
        var defaultDB = JSON.parse(JSON.stringify({
            connector: credentials.type,
            host: credentials.host,
            port: credentials.port || defaultPorts[credentials.type],
            database: credentials.database && credentials.database.length > 0
                ? credentials.database
                : undefined,
            schema: credentials.schema && credentials.schema.length > 0
                ? credentials.schema
                : undefined,
            user: credentials.user,
            password: credentials.password,
            migrations: !credentials.alreadyData,
        }));
        return yaml
            .safeDump({
            databases: {
                default: defaultDB,
            },
        })
            .split('\n')
            .filter(function (l) { return l.trim().length > 0; })
            .map(function (l) { return "        " + l; })
            .join('\n');
    };
    EndpointDialog.prototype.printDatabaseService = function (type) {
        return databaseServiceDefinitions[type];
    };
    EndpointDialog.prototype.handleChoice = function (_a) {
        var choice = _a.choice, loggedIn = _a.loggedIn, folderName = _a.folderName, localClusterRunning = _a.localClusterRunning, _b = _a.clusters, clusters = _b === void 0 ? this.getCloudClusters() : _b;
        return __awaiter(this, void 0, void 0, function () {
            var clusterEndpoint, cluster, workspace, service, stage, credentials, dockerComposeYml, datamodel, newDatabase, managementSecret, writeDockerComposeYml, _c, needsAuth, type, _d, before, introspector, schemas, e_1, _e, numTables, sdl, demoCluster, result_1, _f, _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        service = 'default';
                        stage = 'default';
                        dockerComposeYml = util_1.defaultDockerCompose;
                        datamodel = util_1.defaultDataModel;
                        newDatabase = false;
                        writeDockerComposeYml = true;
                        _c = choice;
                        switch (_c) {
                            case 'Use other server': return [3 /*break*/, 1];
                            case 'local': return [3 /*break*/, 8];
                            case 'Create new database': return [3 /*break*/, 8];
                            case 'Use existing database': return [3 /*break*/, 12];
                            case 'Demo server': return [3 /*break*/, 21];
                        }
                        return [3 /*break*/, 23];
                    case 1: return [4 /*yield*/, this.customEndpointSelector()];
                    case 2:
                        clusterEndpoint = _h.sent();
                        cluster = new prisma_yml_1.Cluster(this.out, 'custom', clusterEndpoint);
                        return [4 /*yield*/, cluster.needsAuth()];
                    case 3:
                        needsAuth = _h.sent();
                        if (!needsAuth) return [3 /*break*/, 5];
                        return [4 /*yield*/, this.ask({
                                message: 'Enter the management API secret',
                                key: 'managementSecret',
                                inputType: 'password',
                            })];
                    case 4:
                        managementSecret = _h.sent();
                        _h.label = 5;
                    case 5: return [4 /*yield*/, this.ask({
                            message: 'Choose a name for your service',
                            key: 'serviceName',
                        })];
                    case 6:
                        service = _h.sent();
                        return [4 /*yield*/, this.ask({
                                message: 'Choose a name for your stage',
                                key: 'stageName',
                            })];
                    case 7:
                        stage = _h.sent();
                        writeDockerComposeYml = false;
                        return [3 /*break*/, 24];
                    case 8:
                        cluster =
                            (this.env.clusters || []).find(function (c) { return c.name === 'local'; }) ||
                                new prisma_yml_1.Cluster(this.out, 'local', 'http://localhost:4466');
                        if (!(choice === 'Create new database')) return [3 /*break*/, 10];
                        return [4 /*yield*/, this.askForDatabaseType()];
                    case 9:
                        _d = _h.sent();
                        return [3 /*break*/, 11];
                    case 10:
                        _d = 'mysql';
                        _h.label = 11;
                    case 11:
                        type = _d;
                        credentials = {
                            user: type === 'mysql' ? 'root' : 'prisma',
                            password: 'prisma',
                            type: type,
                            host: type === 'mysql' ? 'mysql' : 'postgres',
                            port: defaultPorts[type],
                        };
                        dockerComposeYml += this.printDatabaseConfig(credentials);
                        dockerComposeYml += this.printDatabaseService(type);
                        newDatabase = true;
                        return [3 /*break*/, 24];
                    case 12: return [4 /*yield*/, this.getDatabase()];
                    case 13:
                        credentials = _h.sent();
                        this.out.log('');
                        before = Date.now();
                        this.out.action.start(credentials.alreadyData
                            ? "Introspecting database"
                            : "Connecting to database");
                        introspector = new prisma_db_introspection_1.Introspector(this.replaceLocalDockerHost(credentials));
                        schemas = void 0;
                        _h.label = 14;
                    case 14:
                        _h.trys.push([14, 16, , 17]);
                        return [4 /*yield*/, introspector.listSchemas()];
                    case 15:
                        schemas = _h.sent();
                        return [3 /*break*/, 17];
                    case 16:
                        e_1 = _h.sent();
                        throw new Error("Could not connect to database. " + e_1.message);
                    case 17:
                        if (!(credentials &&
                            credentials.alreadyData &&
                            schemas &&
                            schemas.length > 0)) return [3 /*break*/, 19];
                        return [4 /*yield*/, introspector.introspect(schemas[0])];
                    case 18:
                        _e = _h.sent(), numTables = _e.numTables, sdl = _e.sdl;
                        if (numTables === 0) {
                            this.out.log(chalk_1.default.red("\n" + chalk_1.default.bold('Error: ') + "The provided database doesn't contain any tables. Please either provide another database or choose \"No\" for \"Does your database contain existing data?\""));
                            this.out.exit(1);
                        }
                        this.out.action.stop(util_1.prettyTime(Date.now() - before));
                        this.out.log("Created datamodel definition based on " + numTables + " database tables.");
                        datamodel = sdl;
                        return [3 /*break*/, 20];
                    case 19:
                        this.out.action.stop(util_1.prettyTime(Date.now() - before));
                        _h.label = 20;
                    case 20:
                        dockerComposeYml += this.printDatabaseConfig(credentials);
                        cluster = new prisma_yml_1.Cluster(this.out, 'custom', 'http://localhost:4466');
                        return [3 /*break*/, 24];
                    case 21: return [4 /*yield*/, this.getDemoCluster()];
                    case 22:
                        demoCluster = _h.sent();
                        if (!demoCluster) {
                            return [2 /*return*/, this.getEndpoint()];
                        }
                        else {
                            cluster = demoCluster;
                        }
                        return [3 /*break*/, 24];
                    case 23:
                        result_1 = this.getClusterAndWorkspaceFromChoice(choice);
                        if (!result_1.workspace) {
                            cluster = clusters.find(function (c) { return c.name === result_1.cluster; });
                            if (!loggedIn && cluster && cluster.shared) {
                                workspace = this.getPublicName();
                            }
                        }
                        else {
                            cluster = clusters.find(function (c) {
                                return c.name === result_1.cluster && c.workspaceSlug === result_1.workspace;
                            });
                            workspace = result_1.workspace;
                        }
                        _h.label = 24;
                    case 24:
                        if (!cluster) {
                            throw new Error("Oops. Could not get cluster.");
                        }
                        this.env.setActiveCluster(cluster);
                        _f = !cluster.local;
                        if (_f) return [3 /*break*/, 26];
                        return [4 /*yield*/, this.projectExists(cluster, service, stage, workspace)];
                    case 25:
                        _f = (_h.sent());
                        _h.label = 26;
                    case 26:
                        if (!_f) return [3 /*break*/, 28];
                        return [4 /*yield*/, this.askForService(folderName)];
                    case 27:
                        service = _h.sent();
                        _h.label = 28;
                    case 28:
                        _g = !cluster.local;
                        if (_g) return [3 /*break*/, 30];
                        return [4 /*yield*/, this.projectExists(cluster, service, stage, workspace)];
                    case 29:
                        _g = (_h.sent());
                        _h.label = 30;
                    case 30:
                        if (!_g) return [3 /*break*/, 32];
                        return [4 /*yield*/, this.askForStage('dev')];
                    case 31:
                        stage = _h.sent();
                        _h.label = 32;
                    case 32:
                        workspace = workspace || cluster.workspaceSlug;
                        return [2 /*return*/, {
                                endpoint: cluster.getApiEndpoint(service, stage, workspace),
                                cluster: cluster,
                                workspace: workspace,
                                service: service,
                                stage: stage,
                                localClusterRunning: localClusterRunning,
                                database: credentials,
                                dockerComposeYml: dockerComposeYml,
                                datamodel: datamodel,
                                newDatabase: newDatabase,
                                managementSecret: managementSecret,
                                writeDockerComposeYml: writeDockerComposeYml,
                            }];
                }
            });
        });
    };
    EndpointDialog.prototype.replaceLocalDockerHost = function (credentials) {
        var replaceMap = {
            'host.docker.internal': 'localhost',
            'docker.for.mac.localhost': 'localhost',
        };
        return __assign({}, credentials, { host: replaceMap[credentials.host] || credentials.host });
    };
    EndpointDialog.prototype.getDatabase = function (introspection) {
        if (introspection === void 0) { introspection = false; }
        return __awaiter(this, void 0, void 0, function () {
            var type, alreadyData, _a, host, port, user, password, database, _b, ssl, _c, schema;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0: return [4 /*yield*/, this.askForDatabaseType(introspection)
                        // const alreadyData = await this.ask({
                        //   message: 'Does your database contain existing data?',
                        //   key: 'alreadyData',
                        //   defaultValue: 'no',
                        //   validate: value =>
                        //     ['yes', 'no'].includes(value) ? true : 'Please answer either yes or no',
                        // })
                    ];
                    case 1:
                        type = _d.sent();
                        _a = introspection;
                        if (_a) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.askForExistingData()];
                    case 2:
                        _a = (_d.sent());
                        _d.label = 3;
                    case 3:
                        alreadyData = _a;
                        if (type === 'mysql' && alreadyData) {
                            throw new Error("Existing MySQL databases with data are not yet supported.");
                        }
                        return [4 /*yield*/, this.ask({
                                message: 'Enter database host',
                                key: 'host',
                                defaultValue: 'localhost',
                            })];
                    case 4:
                        host = _d.sent();
                        return [4 /*yield*/, this.ask({
                                message: 'Enter database port',
                                key: 'port',
                                defaultValue: String(defaultPorts[type]),
                            })];
                    case 5:
                        port = _d.sent();
                        return [4 /*yield*/, this.ask({
                                message: 'Enter database user',
                                key: 'user',
                            })];
                    case 6:
                        user = _d.sent();
                        return [4 /*yield*/, this.ask({
                                message: 'Enter database password',
                                key: 'password',
                            })];
                    case 7:
                        password = _d.sent();
                        if (!(type === 'postgres')) return [3 /*break*/, 9];
                        return [4 /*yield*/, this.ask({
                                message: alreadyData
                                    ? "Enter name of existing database"
                                    : "Enter database name",
                                key: 'database',
                            })];
                    case 8:
                        _b = _d.sent();
                        return [3 /*break*/, 10];
                    case 9:
                        _b = null;
                        _d.label = 10;
                    case 10:
                        database = _b;
                        if (!(type === 'postgres')) return [3 /*break*/, 12];
                        return [4 /*yield*/, this.ask({
                                message: 'Use SSL?',
                                inputType: 'confirm',
                                key: 'ssl',
                            })];
                    case 11:
                        _c = _d.sent();
                        return [3 /*break*/, 13];
                    case 12:
                        _c = undefined;
                        _d.label = 13;
                    case 13:
                        ssl = _c;
                        return [4 /*yield*/, this.ask({
                                message: "Enter name of existing schema",
                                key: 'schema',
                            })];
                    case 14:
                        schema = _d.sent();
                        return [2 /*return*/, {
                                type: type,
                                host: host,
                                port: port,
                                user: user,
                                password: password,
                                database: database,
                                alreadyData: alreadyData,
                                schema: schema,
                                ssl: ssl,
                            }];
                }
            });
        });
    };
    EndpointDialog.prototype.getClusterAndWorkspaceFromChoice = function (choice) {
        var splitted = choice.split('/');
        var workspace = splitted.length > 1 ? splitted[0] : null;
        var cluster = splitted.slice(-1)[0];
        return { workspace: workspace, cluster: cluster };
    };
    EndpointDialog.prototype.getCloudClusters = function () {
        if (!this.env.clusters) {
            return [];
        }
        return this.env.clusters.filter(function (c) { return c.shared || c.isPrivate; });
    };
    EndpointDialog.prototype.projectExists = function (cluster, name, stage, workspace) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, e_2;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 2, , 3]);
                        _a = Boolean;
                        return [4 /*yield*/, this.client.getProject(util_1.concatName(cluster, name, workspace || null), stage)];
                    case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent()])];
                    case 2:
                        e_2 = _b.sent();
                        return [2 /*return*/, false];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    EndpointDialog.prototype.listFiles = function () {
        return fs.readdirSync(this.config.definitionDir);
    };
    EndpointDialog.prototype.isClusterOnline = function (endpoint) {
        return __awaiter(this, void 0, void 0, function () {
            var cluster;
            return __generator(this, function (_a) {
                cluster = new prisma_yml_1.Cluster(this.out, 'local', endpoint, undefined, true);
                return [2 /*return*/, cluster.isOnline()];
            });
        });
    };
    EndpointDialog.prototype.getClusterQuestion = function (fromScratch, hasDockerComposeYml, clusters) {
        var sandboxChoices = [
            [
                'Demo server',
                'Hosted demo environment incl. database (requires login)',
            ],
            [
                'Use other server',
                'Manually provide endpoint of a running Prisma server',
            ],
        ];
        if (fromScratch && !hasDockerComposeYml) {
            var fixChoices = [
                ['Use existing database', 'Connect to existing database'],
                ['Create new database', 'Set up a local database using Docker'],
            ];
            var rawChoices = fixChoices.concat(sandboxChoices);
            var choices = this.convertChoices(rawChoices);
            var finalChoices = [
                new inquirer.Separator('                       '),
                new inquirer.Separator(chalk_1.default.bold('You can set up Prisma for local development (based on docker-compose)'))
            ].concat(choices.slice(0, fixChoices.length), [
                new inquirer.Separator('                       '),
                new inquirer.Separator(chalk_1.default.bold('Or deploy to an existing Prisma server:'))
            ], choices.slice(fixChoices.length, 5));
            return {
                name: 'choice',
                type: 'list',
                // message: `Connect to your database, set up a new one or use hosted sandbox?`,
                message: "Set up a new Prisma server or deploy to an existing server?",
                choices: finalChoices,
                pageSize: finalChoices.length,
            };
        }
        else {
            var clusterChoices = clusters.length > 0
                ? clusters.filter(function (c) { return !c.shared; }).map(this.getClusterChoice)
                : sandboxChoices;
            var rawChoices = [
                ['Use existing database', 'Connect to existing database'],
                ['Create new database', 'Set up a local database using Docker']
            ].concat(clusterChoices, [
                [
                    'Demo server',
                    'Hosted demo environment incl. database (requires login)',
                ],
                [
                    'Use other server',
                    'Manually provide endpoint of a running Prisma server',
                ],
            ]);
            var choices = this.convertChoices(rawChoices);
            var dockerChoices = hasDockerComposeYml
                ? []
                : [
                    new inquirer.Separator(chalk_1.default.bold('Set up a new Prisma server for local development (based on docker-compose):'))
                ].concat(choices.slice(0, 2));
            var finalChoices = [
                new inquirer.Separator('                       ')
            ].concat(dockerChoices, [
                new inquirer.Separator('                       '),
                new inquirer.Separator(chalk_1.default.bold('Or deploy to an existing Prisma server:'))
            ], choices.slice(2));
            return {
                name: 'choice',
                type: 'list',
                message: "Set up a new Prisma server or deploy to an existing server?",
                choices: finalChoices,
                pageSize: finalChoices.length,
            };
        }
    };
    EndpointDialog.prototype.getClusterName = function (c) {
        return "" + (c.workspaceSlug ? c.workspaceSlug + "/" : '') + this.encodeName(c.name);
    };
    EndpointDialog.prototype.getDemoCluster = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!this.env.cloudSessionKey) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.client.login()];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2 /*return*/, this.askForDemoCluster()];
                }
            });
        });
    };
    EndpointDialog.prototype.askForDemoCluster = function () {
        return __awaiter(this, void 0, void 0, function () {
            var clusters, eu1Cluster, us1Cluster, eu1Ping, us1Ping, eu1Name, us1Name, eu1Choice, us1Choice, rawChoices, choices, cluster;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        clusters = this.getCloudClusters().slice(0, 2);
                        eu1Cluster = clusters.find(function (c) { return c.name === 'prisma-eu1'; });
                        us1Cluster = clusters.find(function (c) { return c.name === 'prisma-us1'; });
                        return [4 /*yield*/, prisma_cli_engine_1.getPing('EU_WEST_1')];
                    case 1:
                        eu1Ping = _a.sent();
                        return [4 /*yield*/, prisma_cli_engine_1.getPing('US_WEST_2')];
                    case 2:
                        us1Ping = _a.sent();
                        eu1Name = this.getClusterName(eu1Cluster);
                        us1Name = this.getClusterName(us1Cluster);
                        eu1Choice = [
                            eu1Name,
                            "Hosted on AWS in eu-west-1 using MySQL [" + eu1Ping.toFixed() + "ms latency]",
                        ];
                        us1Choice = [
                            us1Name,
                            "Hosted on AWS in us-west-2 using MySQL [" + us1Ping.toFixed() + "ms latency]",
                        ];
                        rawChoices = eu1Ping < us1Ping ? [eu1Choice, us1Choice] : [us1Choice, eu1Choice];
                        choices = this.convertChoices(rawChoices);
                        return [4 /*yield*/, this.out.prompt({
                                name: 'cluster',
                                type: 'list',
                                message: "Choose the region of your demo server",
                                choices: choices,
                            })];
                    case 3:
                        cluster = (_a.sent()).cluster;
                        return [2 /*return*/, eu1Name === cluster ? eu1Cluster : us1Cluster];
                }
            });
        });
    };
    EndpointDialog.prototype.getClusterDescription = function (c) {
        if (c.shared) {
            return 'Free development server on Prisma Cloud (incl. database)';
        }
        return "Production Prisma cluster";
    };
    EndpointDialog.prototype.askForDatabaseType = function (introspect) {
        if (introspect === void 0) { introspect = false; }
        return __awaiter(this, void 0, void 0, function () {
            var choices, dbType;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        choices = [];
                        if (!introspect) {
                            choices.push({
                                value: 'mysql',
                                name: 'MySQL             MySQL compliant databases like MySQL or MariaDB',
                                short: 'MySQL',
                            });
                        }
                        choices.push({
                            value: 'postgres',
                            name: 'PostgreSQL        PostgreSQL database',
                            short: 'PostgreSQL',
                        });
                        return [4 /*yield*/, this.out.prompt({
                                name: 'dbType',
                                type: 'list',
                                message: "What kind of database do you want to " + (introspect ? 'introspect' : 'deploy to') + "?",
                                choices: choices,
                            })];
                    case 1:
                        dbType = (_a.sent()).dbType;
                        return [2 /*return*/, dbType];
                }
            });
        });
    };
    EndpointDialog.prototype.convertChoices = function (choices) {
        var padded = this.out.printPadded(choices, 0, 6).split('\n');
        return padded.map(function (name, index) { return ({
            name: name,
            value: choices[index][0],
            short: choices[index][0],
        }); });
    };
    EndpointDialog.prototype.askForStage = function (defaultName) {
        return __awaiter(this, void 0, void 0, function () {
            var question, stage;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        question = {
                            name: 'stage',
                            type: 'input',
                            message: 'Choose a name for your stage',
                            default: defaultName,
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        stage = (_a.sent()).stage;
                        return [2 /*return*/, stage];
                }
            });
        });
    };
    EndpointDialog.prototype.askForService = function (defaultName) {
        return __awaiter(this, void 0, void 0, function () {
            var question, service;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        question = {
                            name: 'service',
                            type: 'input',
                            message: 'Choose a name for your service',
                            default: defaultName,
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        service = (_a.sent()).service;
                        return [2 /*return*/, service];
                }
            });
        });
    };
    EndpointDialog.prototype.customEndpointSelector = function () {
        return __awaiter(this, void 0, void 0, function () {
            var question, endpoint;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        question = {
                            name: 'endpoint',
                            type: 'input',
                            message: "Enter the endpoint of your Prisma server",
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        endpoint = (_a.sent()).endpoint;
                        return [2 /*return*/, endpoint];
                }
            });
        });
    };
    EndpointDialog.prototype.askForExistingData = function () {
        return __awaiter(this, void 0, void 0, function () {
            var question, existingData;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        question = {
                            name: 'existingData',
                            type: 'list',
                            message: "Does your database contain existing data?",
                            choices: [
                                {
                                    value: 'no',
                                    name: 'No',
                                },
                                {
                                    value: 'yes',
                                    name: 'Yes (experimental - Prisma migrations not yet supported)',
                                    short: 'Yes',
                                },
                                new inquirer.Separator("\n\n" + chalk_1.default.yellow('Warning: Introspecting databases with existing data is currently an experimental feature. If you find any issues, please report them here: https://github.com/graphcool/prisma/issues\n')),
                            ],
                            pageSize: 10,
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        existingData = (_a.sent()).existingData;
                        return [2 /*return*/, existingData === 'yes'
                            // this.out.log(
                            //   chalk.bold.red(
                            //     `\n\nWarning: Introspecting databases with existing data is an early alpha preview not ready for production yet. If you find any problems, please let us know\n`,
                            //   ),
                            // )
                            // this.out.log(
                            //   chalk.dim(
                            //     `Note: If you already have data in your database you won't be able to change the database schema with Prisma. If you want to use Prisma's migratino system, plrease choose ${chalk.bold(
                            //       'No',
                            //     )}`,
                            //   ),
                            // )
                            // this.out.up(7)
                        ];
                }
            });
        });
    };
    EndpointDialog.prototype.ask = function (_a) {
        var message = _a.message, defaultValue = _a.defaultValue, key = _a.key, validate = _a.validate, required = _a.required, _b = _a.inputType, inputType = _b === void 0 ? 'input' : _b;
        return __awaiter(this, void 0, void 0, function () {
            var question, result;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        question = {
                            name: key,
                            type: inputType,
                            message: message,
                            default: defaultValue,
                            validate: defaultValue || !required
                                ? undefined
                                : validate ||
                                    (function (value) {
                                        return value && value.length > 0
                                            ? true
                                            : "Please provide a valid " + key;
                                    }),
                        };
                        return [4 /*yield*/, this.out.prompt(question)];
                    case 1:
                        result = _c.sent();
                        return [2 /*return*/, result[key]];
                }
            });
        });
    };
    EndpointDialog.prototype.getSillyName = function () {
        return slugify(sillyname()).split('-')[0] + "-" + Math.round(Math.random() * 1000);
    };
    EndpointDialog.prototype.getPublicName = function () {
        return "public-" + this.getSillyName();
    };
    return EndpointDialog;
}());
exports.EndpointDialog = EndpointDialog;
function slugify(text) {
    return text
        .toString()
        .toLowerCase()
        .replace(/\s+/g, '-') // Replace spaces with -
        .replace(/[^\w\-]+/g, '') // Remove all non-word chars
        .replace(/\-\-+/g, '-') // Replace multiple - with single -
        .replace(/^-+/, '') // Trim - from start of text
        .replace(/-+$/, ''); // Trim - from end of text
}
//# sourceMappingURL=EndpointDialog.js.map