"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var EndpointDialog_1 = require("./EndpointDialog");
var prisma_cli_engine_1 = require("prisma-cli-engine");
var prisma_yml_1 = require("prisma-yml");
var getTmpDir_1 = require("../test/getTmpDir");
var index_test_1 = require("../commands/init/index.test");
function makeDialog() {
    var config = new prisma_cli_engine_1.Config();
    var output = new prisma_cli_engine_1.Output(config);
    var env = new prisma_yml_1.Environment(getTmpDir_1.getTmpDir(), output);
    var client = new prisma_cli_engine_1.Client(config, env, output);
    var dialog = new EndpointDialog_1.EndpointDialog(output, client, env, config);
    return dialog;
}
describe('endpoint dialog', function () {
    var dialog = makeDialog();
    test('local', function () { return __awaiter(_this, void 0, void 0, function () {
        var input, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    input = {
                        choice: 'local',
                        loggedIn: false,
                        folderName: 'some-folder',
                        localClusterRunning: false,
                        existingData: false,
                    };
                    return [4 /*yield*/, dialog.handleChoice(input)];
                case 1:
                    result = _a.sent();
                    expect({ input: input, result: normalizeResult(result) }).toMatchSnapshot();
                    return [2 /*return*/];
            }
        });
    }); });
    test('local running', function () { return __awaiter(_this, void 0, void 0, function () {
        var input, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    input = {
                        choice: 'local',
                        loggedIn: false,
                        folderName: 'some-folder',
                        localClusterRunning: true,
                        existingData: false,
                    };
                    return [4 /*yield*/, dialog.handleChoice(input)];
                case 1:
                    result = _a.sent();
                    expect({ input: input, result: normalizeResult(result) }).toMatchSnapshot();
                    return [2 /*return*/];
            }
        });
    }); });
});
function normalizeResult(_a) {
    var dockerComposeYml = _a.dockerComposeYml, result = __rest(_a, ["dockerComposeYml"]);
    return __assign({}, result, { dockerComposeYml: index_test_1.normalizeDockerCompose(dockerComposeYml) });
}
exports.normalizeResult = normalizeResult;
//# sourceMappingURL=EndpointDialog.test.js.map