"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var yaml_1 = require("../yaml");
var chalk_1 = require("chalk");
var fs = require("fs");
var yamlComment_1 = require("./yamlComment");
var DefinitionMigrator = /** @class */ (function () {
    function DefinitionMigrator(prismaDefinition) {
        this.prismaDefinition = prismaDefinition;
    }
    DefinitionMigrator.prototype.migrate = function (definitionPath) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.migrateEndpoint(definitionPath)];
            });
        });
    };
    DefinitionMigrator.prototype.migrateEndpoint = function (definitionPath) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, definition, rawJson, endpoint, log, splittedCluster, definitionString, backupPath, newDefinitionString;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, yaml_1.readDefinition(definitionPath, {}, this.prismaDefinition.out, this.prismaDefinition.envVars)];
                    case 1:
                        _a = _b.sent(), definition = _a.definition, rawJson = _a.rawJson;
                        if (definition.endpoint) {
                            // we're fine
                            return [2 /*return*/, false];
                        }
                        endpoint = this.prismaDefinition.getEndpoint();
                        if (definition.service &&
                            definition.stage &&
                            definition.cluster &&
                            endpoint) {
                            log = this.prismaDefinition.out
                                ? this.prismaDefinition.out.log.bind(this.prismaDefinition.out)
                                : console.log.bind(console);
                            splittedCluster = definition.cluster.split('/');
                            if (rawJson.service !== definition.service ||
                                rawJson.stage !== definition.stage ||
                                rawJson.cluster !== definition.cluster ||
                                splittedCluster.length === 1) {
                                log(chalk_1.default.yellow('warning') + " prisma.yml: \"cluster\", \"service\" and \"stage\" are deprecated and will be replaced with \"endpoint\".\nTo get the endpoint, run " + chalk_1.default.cyan('prisma info') + ". Read more here: https://bit.ly/migrate-prisma-yml\n");
                                return [2 /*return*/, false];
                            }
                            definitionString = fs.readFileSync(definitionPath, 'utf-8');
                            backupPath = definitionPath + '.backup';
                            if (!fs.existsSync(backupPath)) {
                                fs.copyFileSync(definitionPath, backupPath);
                            }
                            newDefinitionString = yamlComment_1.migrateToEndpoint(definitionString, endpoint);
                            fs.writeFileSync(definitionPath, newDefinitionString);
                            log(chalk_1.default.yellow('warning') + " prisma.yml: \"cluster\", \"service\", \"stage\" is being replaced by \"endpoint\".\nWe did this migration for you in your prisma.yml so you don't have to take care of it.\nThe old prisma.yml has been copied to prisma.yml.backup.\n\nRead more about the migration here: https://bit.ly/migrate-prisma-yml\n");
                            return [2 /*return*/, true];
                        }
                        return [2 /*return*/, false];
                }
            });
        });
    };
    return DefinitionMigrator;
}());
exports.DefinitionMigrator = DefinitionMigrator;
//# sourceMappingURL=DefinitionMigrator.js.map