package com.reactnativenavigation.screens;

import android.support.v7.app.AppCompatActivity;
import android.view.MotionEvent;
import android.widget.ScrollView;

import com.facebook.react.uimanager.RootViewUtil;
import com.reactnativenavigation.params.ScreenParams;
import com.reactnativenavigation.views.CollapsingContentView;
import com.reactnativenavigation.views.LeftButtonOnClickListener;
import com.reactnativenavigation.views.TopBar;
import com.reactnativenavigation.views.collapsingToolbar.CollapseAmount;
import com.reactnativenavigation.views.collapsingToolbar.CollapseCalculator;
import com.reactnativenavigation.views.collapsingToolbar.CollapsingTopBar;
import com.reactnativenavigation.views.collapsingToolbar.CollapsingView;
import com.reactnativenavigation.views.collapsingToolbar.CollapsingViewMeasurer;
import com.reactnativenavigation.views.collapsingToolbar.OnScrollListener;
import com.reactnativenavigation.views.collapsingToolbar.OnScrollViewAddedListener;
import com.reactnativenavigation.views.collapsingToolbar.ScrollListener;
import com.reactnativenavigation.views.collapsingToolbar.behaviours.CollapseBehaviour;

public class CollapsingSingleScreen extends SingleScreen {

    public CollapsingSingleScreen(AppCompatActivity activity, ScreenParams screenParams, LeftButtonOnClickListener titleBarBarBackButtonListener) {
        super(activity, screenParams, titleBarBarBackButtonListener);
    }

    @Override
    public void destroy() {
        super.destroy();
        ((CollapsingContentView) contentView).destroy();
    }

    @Override
    protected TopBar createTopBar() {
        final CollapsingTopBar topBar = new CollapsingTopBar(getContext(), styleParams);
        topBar.setScrollListener(getScrollListener(topBar));
        return topBar;
    }

    @Override
    protected void createContent() {
        contentView = new CollapsingContentView(getContext(), screenParams.screenId, screenParams.navigationParams);
        setViewMeasurer();
        setupCollapseDetection((CollapsingTopBar) topBar);
        post(new Runnable() {
            @Override
            public void run() {
                addView(contentView, createLayoutParams());
            }
        });
    }

    private void setViewMeasurer() {
        if (screenParams.styleParams.drawScreenBelowTopBar || screenParams.styleParams.drawScreenAboveBottomTabs) {
            contentView.setViewMeasurer(new CollapsingViewMeasurer((CollapsingTopBar) topBar, this, screenParams.styleParams));
        }
    }

    private void setupCollapseDetection(final CollapsingTopBar topBar) {
        ((CollapsingContentView) contentView).setupCollapseDetection(getScrollListener(topBar), new OnScrollViewAddedListener() {
            @Override
            public void onScrollViewAdded(ScrollView scrollView) {
                topBar.onScrollViewAdded(scrollView);
            }
        });
    }

    private ScrollListener getScrollListener(final CollapsingTopBar topBar) {
        return new ScrollListener(new CollapseCalculator(topBar, getCollapseBehaviour()),
                new OnScrollListener() {
                    @Override
                    public void onScroll(MotionEvent event, CollapseAmount amount) {
                        if (screenParams.styleParams.drawScreenBelowTopBar) {
                            RootViewUtil.getRootView(contentView).onChildStartedNativeGesture(event);
                            ((CollapsingView) contentView).collapse(amount);
                        }
                        topBar.collapse(amount);
                    }

                    @Override
                    public void onFling(CollapseAmount amount) {
                        if (screenParams.styleParams.drawScreenBelowTopBar) {
                            ((CollapsingView) contentView).fling(amount);
                        }
                        topBar.fling(amount);
                    }
                },
                getCollapseBehaviour()
        );
    }

    private CollapseBehaviour getCollapseBehaviour() {
        return screenParams.styleParams.collapsingTopBarParams.collapseBehaviour;
    }
}
