# Styling the Tab Bar

You can style the tab bar appearance by passing a `tabsStyle` object when the app is originally created (on `startTabBasedApp`).

```js
Navigation.startTabBasedApp({
  tabs: [ ... ],
  tabsStyle: { // optional, **iOS Only** add this if you want to style the tab bar beyond the defaults
    tabBarButtonColor: '#ff0000'
  }
});
```

#### Style object format

```js
{
  tabBarHidden: false, // make the tab bar hidden
  tabBarButtonColor: '#ffff00', // change the color of the tab icons and text (also unselected)
  tabBarSelectedButtonColor: '#ff9900', // change the color of the selected tab icon and text (only selected)
  tabBarBackgroundColor: '#551A8B', // change the background color of the tab bar
  tabBarTranslucent: false, // change the translucent of the tab bar to false
  tabBarTextFontFamily: 'Avenir-Medium', //change the tab font family
  tabBarLabelColor: '#ffb700', // iOS only. change the color of tab text
  tabBarSelectedLabelColor: 'red', // iOS only. change the color of the selected tab text
  forceTitlesDisplay: true, // Android only. If true - Show all bottom tab labels. If false - only the selected tab's label is visible.
  tabBarHideShadow: true // Remove default tab bar top shadow (hairline)
}
```

?> On Android, add BottomTabs styles to `AppStyle`:

```js
Navigation.startTabBasedApp({
  tabs: [...],
  appStyle: {
    tabBarBackgroundColor: '#0f2362',
    tabBarButtonColor: '#ffffff',
    tabBarHideShadow: true,
    tabBarSelectedButtonColor: '#63d7cc',
    tabBarTranslucent: false,
    tabFontFamily: 'Avenir-Medium',  // existing font family name or asset file without extension which can be '.ttf' or '.otf' (searched only if '.ttf' asset not found)
    tabFontSize: 10,
    selectedTabFontSize: 12,
  },
...
}
```
