"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isFunction2 = _interopRequireDefault(require("lodash/isFunction"));

var _isObject2 = _interopRequireDefault(require("lodash/isObject"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

var d3Shape = _interopRequireWildcard(require("d3-shape"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Bar =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Bar, _React$Component);

  function Bar() {
    _classCallCheck(this, Bar);

    return _possibleConstructorReturn(this, (Bar.__proto__ || Object.getPrototypeOf(Bar)).apply(this, arguments));
  }

  _createClass(Bar, [{
    key: "getPosition",
    value: function getPosition(props, width) {
      var x = props.x,
          y = props.y,
          y0 = props.y0,
          horizontal = props.horizontal;
      var alignment = props.alignment || "middle";
      var size = alignment === "middle" ? width / 2 : width;
      var sign = horizontal ? -1 : 1;
      return {
        x0: alignment === "start" ? x : x - sign * size,
        x1: alignment === "end" ? x : x + sign * size,
        y0: y0,
        y1: y
      };
    }
  }, {
    key: "getVerticalBarPath",
    value: function getVerticalBarPath(props, width, cornerRadius) {
      var _getPosition = this.getPosition(props, width),
          x0 = _getPosition.x0,
          x1 = _getPosition.x1,
          y0 = _getPosition.y0,
          y1 = _getPosition.y1;

      var sign = y0 > y1 ? 1 : -1;
      var direction = sign > 0 ? "0 0 1" : "0 0 0";
      var topArc = "".concat(cornerRadius.top, " ").concat(cornerRadius.top, " ").concat(direction);
      var bottomArc = "".concat(cornerRadius.bottom, " ").concat(cornerRadius.bottom, " ").concat(direction);
      return "M ".concat(x0 + cornerRadius.bottom, ", ").concat(y0, "\n      A ").concat(bottomArc, ", ").concat(x0, ", ").concat(y0 - sign * cornerRadius.bottom, "\n      L ").concat(x0, ", ").concat(y1 + sign * cornerRadius.top, "\n      A ").concat(topArc, ", ").concat(x0 + cornerRadius.top, ", ").concat(y1, "\n      L ").concat(x1 - cornerRadius.top, ", ").concat(y1, "\n      A ").concat(topArc, ", ").concat(x1, ", ").concat(y1 + sign * cornerRadius.top, "\n      L ").concat(x1, ", ").concat(y0 - sign * cornerRadius.bottom, "\n      A ").concat(bottomArc, ", ").concat(x1 - cornerRadius.bottom, ", ").concat(y0, "\n      z");
    }
  }, {
    key: "getHorizontalBarPath",
    value: function getHorizontalBarPath(props, width, cornerRadius) {
      var _getPosition2 = this.getPosition(props, width),
          x0 = _getPosition2.x0,
          x1 = _getPosition2.x1,
          y0 = _getPosition2.y0,
          y1 = _getPosition2.y1;

      var sign = y1 > y0 ? 1 : -1;
      var direction = sign > 0 ? "0 0 1" : "0 0 0";
      var topArc = "".concat(cornerRadius.top, " ").concat(cornerRadius.top, " ").concat(direction);
      var bottomArc = "".concat(cornerRadius.bottom, " ").concat(cornerRadius.bottom, " ").concat(direction);
      return "M ".concat(y0, ", ").concat(x1 + sign * cornerRadius.bottom, "\n      A ").concat(bottomArc, ", ").concat(y0 + cornerRadius.bottom, ", ").concat(x1, "\n      L ").concat(y1 - sign * cornerRadius.top, ", ").concat(x1, "\n      A ").concat(topArc, ", ").concat(y1, ", ").concat(x1 + cornerRadius.top, "\n      L ").concat(y1, ", ").concat(x0 - cornerRadius.top, "\n      A ").concat(topArc, ", ").concat(y1 - sign * cornerRadius.top, ", ").concat(x0, "\n      L ").concat(y0 + cornerRadius.bottom, ", ").concat(x0, "\n      A ").concat(bottomArc, ", ").concat(y0, ", ").concat(x0 - sign * cornerRadius.bottom, "\n      z");
    }
  }, {
    key: "transformAngle",
    value: function transformAngle(angle) {
      return -1 * angle + Math.PI / 2;
    }
  }, {
    key: "getAngularWidth",
    value: function getAngularWidth(props, width) {
      var scale = props.scale;
      var range = scale.y.range();
      var r = Math.max.apply(Math, _toConsumableArray(range));
      var angularRange = Math.abs(scale.x.range()[1] - scale.x.range()[0]);
      return width / (2 * Math.PI * r) * angularRange;
    }
  }, {
    key: "getAngle",
    value: function getAngle(props, index) {
      var data = props.data,
          scale = props.scale;
      var x = data[index]._x1 === undefined ? "_x" : "_x1";
      return scale.x(data[index][x]);
    }
  }, {
    key: "getStartAngle",
    value: function getStartAngle(props, index) {
      var data = props.data,
          scale = props.scale,
          alignment = props.alignment;
      var currentAngle = this.getAngle(props, index);
      var angularRange = Math.abs(scale.x.range()[1] - scale.x.range()[0]);
      var previousAngle = index === 0 ? this.getAngle(props, data.length - 1) - Math.PI * 2 : this.getAngle(props, index - 1);

      if (index === 0 && angularRange < 2 * Math.PI) {
        return scale.x.range()[0];
      } else if (alignment === "start" || alignment === "end") {
        return alignment === "start" ? previousAngle : currentAngle;
      } else {
        return (currentAngle + previousAngle) / 2;
      }
    }
  }, {
    key: "getEndAngle",
    value: function getEndAngle(props, index) {
      var data = props.data,
          scale = props.scale,
          alignment = props.alignment;
      var currentAngle = this.getAngle(props, index);
      var angularRange = Math.abs(scale.x.range()[1] - scale.x.range()[0]);
      var lastAngle = scale.x.range()[1] === 2 * Math.PI ? this.getAngle(props, 0) + Math.PI * 2 : scale.x.range()[1];
      var nextAngle = index === data.length - 1 ? this.getAngle(props, 0) + Math.PI * 2 : this.getAngle(props, index + 1);

      if (index === data.length - 1 && angularRange < 2 * Math.PI) {
        return lastAngle;
      } else if (alignment === "start" || alignment === "end") {
        return alignment === "start" ? currentAngle : nextAngle;
      } else {
        return (currentAngle + nextAngle) / 2;
      }
    }
  }, {
    key: "getVerticalPolarBarPath",
    value: function getVerticalPolarBarPath(props, cornerRadius) {
      var _this = this;

      // eslint-disable-line max-statements
      var datum = props.datum,
          scale = props.scale,
          index = props.index,
          alignment = props.alignment;

      var style = _victoryCore.Helpers.evaluateStyle(props.style, datum, props.active);

      var r1 = scale.y(datum._y0 || 0);
      var r2 = scale.y(datum._y1 !== undefined ? datum._y1 : datum._y);
      var currentAngle = scale.x(datum._x1 !== undefined ? datum._x1 : datum._x);
      var start;
      var end;

      if (style.width) {
        var width = this.getAngularWidth(props, style.width);
        var size = alignment === "middle" ? width / 2 : width;
        start = alignment === "start" ? currentAngle : currentAngle - size;
        end = alignment === "end" ? currentAngle : currentAngle + size;
      } else {
        start = this.getStartAngle(props, index);
        end = this.getEndAngle(props, index);
      }

      var getPath = function (edge) {
        var pathFunction = d3Shape.arc().innerRadius(r1).outerRadius(r2).startAngle(_this.transformAngle(start)).endAngle(_this.transformAngle(end)).cornerRadius(cornerRadius[edge]);
        var path = pathFunction();
        var moves = path.match(/[A-Z]/g);
        var middle = moves.indexOf("L");
        var coords = path.split(/[A-Z]/).slice(1);
        var subMoves = edge === "top" ? moves.slice(0, middle) : moves.slice(middle);
        var subCoords = edge === "top" ? coords.slice(0, middle) : coords.slice(middle);
        return subMoves.map(function (m, i) {
          return {
            command: m,
            coords: subCoords[i].split(",")
          };
        });
      };

      var moves = getPath("top").concat(getPath("bottom"));
      return moves.reduce(function (memo, move) {
        memo += "".concat(move.command, " ").concat(move.coords.join());
        return memo;
      }, "");
    }
  }, {
    key: "getBarPath",
    value: function getBarPath(props, width, cornerRadius) {
      return this.props.horizontal ? this.getHorizontalBarPath(props, width, cornerRadius) : this.getVerticalBarPath(props, width, cornerRadius);
    }
  }, {
    key: "getPolarBarPath",
    value: function getPolarBarPath(props, cornerRadius) {
      // TODO Radial bars
      return this.getVerticalPolarBarPath(props, cornerRadius);
    }
  }, {
    key: "getBarWidth",
    value: function getBarWidth(props, style) {
      var active = props.active,
          scale = props.scale,
          data = props.data,
          barWidth = props.barWidth,
          defaultBarWidth = props.defaultBarWidth;

      if (barWidth) {
        return (0, _isFunction2.default)(barWidth) ? _victoryCore.Helpers.evaluateProp(barWidth, active) : barWidth;
      } else if (style.width) {
        return style.width;
      }

      var range = scale.x.range();
      var extent = Math.abs(range[1] - range[0]);
      var bars = data.length + 2;
      var barRatio = props.barRatio || 0.5;
      var defaultWidth = barRatio * (data.length < 2 ? defaultBarWidth : extent / bars);
      return Math.max(1, defaultWidth);
    }
  }, {
    key: "getCornerRadius",
    value: function getCornerRadius(props) {
      var cornerRadius = props.cornerRadius,
          datum = props.datum,
          active = props.active;

      if (!cornerRadius) {
        return {
          top: 0,
          bottom: 0
        };
      } else if ((0, _isObject2.default)(cornerRadius)) {
        return {
          top: _victoryCore.Helpers.evaluateProp(cornerRadius.top, datum, active),
          bottom: _victoryCore.Helpers.evaluateProp(cornerRadius.bottom, datum, active)
        };
      } else {
        return {
          top: _victoryCore.Helpers.evaluateProp(cornerRadius, datum, active),
          bottom: 0
        };
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          role = _props.role,
          datum = _props.datum,
          active = _props.active,
          shapeRendering = _props.shapeRendering,
          className = _props.className,
          origin = _props.origin,
          polar = _props.polar,
          pathComponent = _props.pathComponent,
          events = _props.events,
          clipPath = _props.clipPath;
      var stroke = this.props.style && this.props.style.fill || "black";
      var baseStyle = {
        fill: "black",
        stroke: stroke
      };

      var style = _victoryCore.Helpers.evaluateStyle((0, _assign2.default)(baseStyle, this.props.style), datum, active);

      var width = this.getBarWidth(this.props, style);
      var cornerRadius = this.getCornerRadius(this.props);
      var path = polar ? this.getPolarBarPath(this.props, cornerRadius) : this.getBarPath(this.props, width, cornerRadius);
      var defaultTransform = polar && origin ? "translate(".concat(origin.x, ", ").concat(origin.y, ")") : undefined;
      var transform = this.props.transform || defaultTransform;
      return _react.default.cloneElement(pathComponent, {
        d: path,
        transform: transform,
        className: className,
        style: style,
        role: role,
        shapeRendering: shapeRendering,
        events: events,
        clipPath: clipPath
      });
    }
  }]);

  return Bar;
}(_react.default.Component);

exports.default = Bar;
Object.defineProperty(Bar, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _victoryCore.CommonProps.primitiveProps, {
    alignment: _propTypes.default.oneOf(["start", "middle", "end"]),
    barRatio: _propTypes.default.number,
    barWidth: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    cornerRadius: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func, _propTypes.default.shape({
      top: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
      bottom: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func])
    })]),
    datum: _propTypes.default.object,
    horizontal: _propTypes.default.bool,
    pathComponent: _propTypes.default.element,
    width: _propTypes.default.number,
    x: _propTypes.default.number,
    y: _propTypes.default.number,
    y0: _propTypes.default.number
  })
});
Object.defineProperty(Bar, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    pathComponent: _react.default.createElement(_victoryCore.Path, null),
    defaultBarWidth: 8
  }
});