"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isFunction2 = _interopRequireDefault(require("lodash/isFunction"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Candle =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Candle, _React$Component);

  function Candle() {
    _classCallCheck(this, Candle);

    return _possibleConstructorReturn(this, (Candle.__proto__ || Object.getPrototypeOf(Candle)).apply(this, arguments));
  }

  _createClass(Candle, [{
    key: "getCandleWidth",
    value: function getCandleWidth(props, style) {
      var active = props.active,
          datum = props.datum,
          data = props.data,
          candleWidth = props.candleWidth,
          scale = props.scale,
          defaultCandleWidth = props.defaultCandleWidth;

      if (candleWidth) {
        return (0, _isFunction2.default)(candleWidth) ? _victoryCore.Helpers.evaluateProp(candleWidth, datum, active) : candleWidth;
      } else if (style.width) {
        return style.width;
      }

      var range = scale.x.range();
      var extent = Math.abs(range[1] - range[0]);
      var candles = data.length + 2;
      var candleRatio = props.candleRatio || 0.5;
      var defaultWidth = candleRatio * (data.length < 2 ? defaultCandleWidth : extent / candles);
      return Math.max(1, defaultWidth);
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          x = _props.x,
          high = _props.high,
          low = _props.low,
          open = _props.open,
          close = _props.close,
          datum = _props.datum,
          active = _props.active,
          events = _props.events,
          groupComponent = _props.groupComponent,
          clipPath = _props.clipPath,
          id = _props.id,
          rectComponent = _props.rectComponent,
          lineComponent = _props.lineComponent,
          role = _props.role,
          shapeRendering = _props.shapeRendering,
          className = _props.className,
          wickStrokeWidth = _props.wickStrokeWidth,
          transform = _props.transform;

      var style = _victoryCore.Helpers.evaluateStyle((0, _assign2.default)({
        stroke: "black"
      }, this.props.style), datum, active);

      var wickStyle = (0, _defaults2.default)({
        strokeWidth: wickStrokeWidth
      }, style);
      var candleWidth = this.getCandleWidth(this.props, style);
      var candleHeight = Math.abs(close - open);
      var candleX = x - candleWidth / 2;
      var sharedProps = {
        role: role,
        shapeRendering: shapeRendering,
        className: className,
        events: events,
        transform: transform,
        clipPath: clipPath
      };
      var candleProps = (0, _assign2.default)({
        key: "".concat(id, "-candle"),
        style: style,
        x: candleX,
        y: Math.min(open, close),
        width: candleWidth,
        height: candleHeight
      }, sharedProps);
      var highWickProps = (0, _assign2.default)({
        key: "".concat(id, "-highWick"),
        style: wickStyle,
        x1: x,
        x2: x,
        y1: high,
        y2: Math.min(open, close)
      }, sharedProps);
      var lowWickProps = (0, _assign2.default)({
        key: "".concat(id, "-lowWick"),
        style: wickStyle,
        x1: x,
        x2: x,
        y1: Math.max(open, close),
        y2: low
      }, sharedProps);
      return _react.default.cloneElement(groupComponent, {}, [_react.default.cloneElement(rectComponent, candleProps), _react.default.cloneElement(lineComponent, highWickProps), _react.default.cloneElement(lineComponent, lowWickProps)]);
    }
  }]);

  return Candle;
}(_react.default.Component);

exports.default = Candle;
Object.defineProperty(Candle, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _victoryCore.CommonProps.primitiveProps, {
    candleRatio: _propTypes.default.number,
    candleWidth: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.func]),
    close: _propTypes.default.number,
    datum: _propTypes.default.object,
    defaultCandleWidth: _propTypes.default.number,
    groupComponent: _propTypes.default.element,
    high: _propTypes.default.number,
    lineComponent: _propTypes.default.element,
    low: _propTypes.default.number,
    open: _propTypes.default.number,
    rectComponent: _propTypes.default.element,
    wickStrokeWidth: _propTypes.default.number,
    width: _propTypes.default.number,
    x: _propTypes.default.number
  })
});
Object.defineProperty(Candle, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    defaultCandleWidth: 8,
    groupComponent: _react.default.createElement("g", null),
    lineComponent: _react.default.createElement(_victoryCore.Line, null),
    rectComponent: _react.default.createElement(_victoryCore.Rect, null)
  }
});