"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = _interopRequireDefault(require("../victory-util/helpers"));

var _commonProps = _interopRequireDefault(require("../victory-util/common-props"));

var _line = _interopRequireDefault(require("./line"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Whisker =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Whisker, _React$Component);

  function Whisker() {
    _classCallCheck(this, Whisker);

    return _possibleConstructorReturn(this, (Whisker.__proto__ || Object.getPrototypeOf(Whisker)).apply(this, arguments));
  }

  _createClass(Whisker, [{
    key: "render",
    value: function render() {
      var _props = this.props,
          groupComponent = _props.groupComponent,
          lineComponent = _props.lineComponent,
          events = _props.events,
          className = _props.className,
          majorWhisker = _props.majorWhisker,
          minorWhisker = _props.minorWhisker,
          datum = _props.datum,
          active = _props.active,
          transform = _props.transform,
          clipPath = _props.clipPath;

      var style = _helpers.default.evaluateStyle(this.props.style, datum, active);

      var baseProps = {
        style: style,
        events: events,
        className: className,
        transform: transform,
        clipPath: clipPath
      };
      return _react.default.cloneElement(groupComponent, {}, [_react.default.cloneElement(lineComponent, (0, _assign2.default)({
        key: "major-whisker"
      }, baseProps, majorWhisker)), _react.default.cloneElement(lineComponent, (0, _assign2.default)({
        key: "minor-whisker"
      }, baseProps, minorWhisker))]);
    }
  }]);

  return Whisker;
}(_react.default.Component);

exports.default = Whisker;
Object.defineProperty(Whisker, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _commonProps.default.primitiveProps, {
    groupComponent: _propTypes.default.element,
    lineComponent: _propTypes.default.element,
    majorWhisker: _propTypes.default.shape({
      x1: _propTypes.default.number,
      x2: _propTypes.default.number,
      y1: _propTypes.default.number,
      y2: _propTypes.default.number
    }),
    minorWhisker: _propTypes.default.shape({
      x1: _propTypes.default.number,
      x2: _propTypes.default.number,
      y1: _propTypes.default.number,
      y2: _propTypes.default.number
    })
  })
});
Object.defineProperty(Whisker, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    groupComponent: _react.default.createElement("g", null),
    lineComponent: _react.default.createElement(_line.default, null)
  }
});