"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _uniqueId2 = _interopRequireDefault(require("lodash/uniqueId"));

var _isObject2 = _interopRequireDefault(require("lodash/isObject"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Voronoi =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Voronoi, _React$Component);

  function Voronoi(props) {
    var _this;

    _classCallCheck(this, Voronoi);

    _this = _possibleConstructorReturn(this, (Voronoi.__proto__ || Object.getPrototypeOf(Voronoi)).call(this, props));
    _this.clipId = !(0, _isObject2.default)(props) || props.clipId === undefined ? (0, _uniqueId2.default)("voronoi-clip-") : props.clipId;
    return _this;
  }

  _createClass(Voronoi, [{
    key: "getVoronoiPath",
    value: function getVoronoiPath(props) {
      var polygon = props.polygon;
      return Array.isArray(polygon) && polygon.length ? "M ".concat(props.polygon.join("L"), " Z") : "";
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          datum = _props.datum,
          active = _props.active,
          role = _props.role,
          shapeRendering = _props.shapeRendering,
          className = _props.className,
          events = _props.events,
          x = _props.x,
          y = _props.y,
          transform = _props.transform,
          pathComponent = _props.pathComponent,
          clipPathComponent = _props.clipPathComponent,
          groupComponent = _props.groupComponent,
          circleComponent = _props.circleComponent,
          id = _props.id;
      var voronoiPath = this.getVoronoiPath(this.props);

      var style = _victoryCore.Helpers.evaluateStyle(this.props.style, datum, active);

      var size = _victoryCore.Helpers.evaluateProp(this.props.size, datum, active);

      if (size) {
        var circle = _react.default.cloneElement(circleComponent, {
          key: "".concat(id, "-circle-clip"),
          style: style,
          className: className,
          role: role,
          shapeRendering: shapeRendering,
          events: events,
          clipPath: "url(#".concat(this.clipId, ")"),
          cx: x,
          cy: y,
          r: size
        });

        var voronoiClipPath = _react.default.cloneElement(clipPathComponent, {
          key: "".concat(id, "-voronoi-clip"),
          clipId: this.clipId
        }, _react.default.cloneElement(pathComponent, {
          d: voronoiPath,
          className: className
        }));

        return _react.default.cloneElement(groupComponent, {}, [voronoiClipPath, circle]);
      }

      return _react.default.cloneElement(pathComponent, {
        style: style,
        className: className,
        d: voronoiPath,
        role: role,
        shapeRendering: shapeRendering,
        events: events,
        transform: transform
      });
    }
  }]);

  return Voronoi;
}(_react.default.Component);

exports.default = Voronoi;
Object.defineProperty(Voronoi, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _victoryCore.CommonProps.primitiveProps, {
    circleComponent: _propTypes.default.element,
    clipId: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    clipPathComponent: _propTypes.default.element,
    datum: _propTypes.default.object,
    groupComponent: _propTypes.default.element,
    pathComponent: _propTypes.default.element,
    polygon: _propTypes.default.array,
    size: _propTypes.default.number,
    x: _propTypes.default.number,
    y: _propTypes.default.number
  })
});
Object.defineProperty(Voronoi, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    pathComponent: _react.default.createElement(_victoryCore.Path, null),
    circleComponent: _react.default.createElement(_victoryCore.Circle, null),
    clipPathComponent: _react.default.createElement(_victoryCore.ClipPath, null),
    groupComponent: _react.default.createElement("g", null)
  }
});