/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 * @format
 */

"use strict";
let getDefaultConfig = (() => {
  var _ref3 = _asyncToGenerator(function*(rootPath) {
    // We can add more logic here to get a sensible default configuration, for
    // now we just return a stub.

    return getDefaultValues(rootPath);
  });
  return function getDefaultConfig(_x) {
    return _ref3.apply(this, arguments);
  };
})();
function _asyncToGenerator(fn) {
  return function() {
    var gen = fn.apply(this, arguments);
    return new Promise(function(resolve, reject) {
      function step(key, arg) {
        try {
          var info = gen[key](arg);
          var value = info.value;
        } catch (error) {
          reject(error);
          return;
        }
        if (info.done) {
          resolve(value);
        } else {
          return Promise.resolve(value).then(
            function(value) {
              step("next", value);
            },
            function(err) {
              step("throw", err);
            }
          );
        }
      }
      return step("next");
    });
  };
}
const TerminalReporter = require("metro/src/lib/TerminalReporter");
const blacklist = require("./blacklist");
const getMaxWorkers = require("metro/src/lib/getMaxWorkers");
const os = require("os");
const path = require("path");
var _require = require("./defaults");
const providesModuleNodeModules = _require.providesModuleNodeModules,
  assetExts = _require.assetExts,
  sourceExts = _require.sourceExts,
  platforms = _require.platforms,
  DEFAULT_METRO_MINIFIER_PATH = _require.DEFAULT_METRO_MINIFIER_PATH,
  defaultCreateModuleIdFactory = _require.defaultCreateModuleIdFactory;
var _require2 = require("metro-cache");
const FileStore = _require2.FileStore;
var _require3 = require("metro-core");
const Terminal = _require3.Terminal;
const getDefaultValues = projectRoot => ({
  resolver: {
    assetExts,
    platforms,
    sourceExts,
    providesModuleNodeModules: providesModuleNodeModules.slice(),
    resolverMainFields: ["browser", "main"],
    extraNodeModules: {},
    resolveRequest: null,
    hasteImplModulePath: undefined,
    blacklistRE: blacklist(),
    useWatchman: true
  },
  serializer: {
    polyfillModuleNames: [],
    getRunModuleStatement: moduleId => `__r(${JSON.stringify(moduleId)});`,
    getPolyfills: () => [],
    postProcessBundleSourcemap: _ref => {
      let code = _ref.code,
        map = _ref.map,
        outFileName = _ref.outFileName;
      return { code, map };
    },
    getModulesRunBeforeMainModule: () => [],
    processModuleFilter: module => true,
    createModuleIdFactory: defaultCreateModuleIdFactory,
    experimentalSerializerHook: () => {}
  },
  server: {
    useGlobalHotkey: true,
    port: 8080,
    enableVisualizer: false,
    enhanceMiddleware: middleware => middleware
  },
  transformer: {
    assetPlugins: [],
    asyncRequireModulePath: "metro/src/lib/bundle-modules/asyncRequire",
    assetRegistryPath: "missing-asset-registry-path",
    babelTransformerPath: "metro/src/defaultTransformer",
    dynamicDepsInPackages: "throwAtRuntime",
    enableBabelRCLookup: true,
    enableBabelRuntime: true,
    getTransformOptions: (() => {
      var _ref2 = _asyncToGenerator(function*() {
        return {
          transform: {
            experimentalImportSupport: false,
            inlineRequires: false
          },
          preloadedModules: false,
          ramGroups: []
        };
      });
      return function getTransformOptions() {
        return _ref2.apply(this, arguments);
      };
    })(),
    minifierConfig: {
      mangle: { toplevel: false },
      output: { ascii_only: true, quote_style: 3, wrap_iife: true },
      sourceMap: { includeSources: false },
      toplevel: false,
      compress: {
        // reduce_funcs inlines single-use functions, which cause perf regressions.
        reduce_funcs: false
      }
    },
    minifierPath: DEFAULT_METRO_MINIFIER_PATH,
    optimizationSizeLimit: 150 * 1024, // 150 KiB.
    postMinifyProcess: x => x,
    transformVariants: { default: {} },
    workerPath: "metro/src/DeltaBundler/Worker"
  },
  cacheStores: [new FileStore({ root: path.join(os.tmpdir(), "metro-cache") })],
  cacheVersion: "1.0", // We assume the default project path is two levels up from
  // node_modules/metro/
  projectRoot: projectRoot || path.resolve(__dirname, "../../.."),
  stickyWorkers: true,
  watchFolders: [],
  transformerPath: require.resolve("metro/src/JSTransformer/worker.js"),
  maxWorkers: getMaxWorkers(),
  resetCache: false,
  reporter: new TerminalReporter(new Terminal(process.stdout))
});
module.exports = getDefaultConfig;
module.exports.getDefaultValues = getDefaultValues;
