import { AuthenticateCustomerPayload, Project, SimpleProjectInfo, CloudTokenRequestPayload } from '../types/common';
import { GraphQLClient } from 'graphql-request';
import { Config } from '../Config';
import { Environment, Cluster, FunctionInput } from 'prisma-yml';
import { Output } from '../index';
import { User, Migration, Workspace, Service } from './types';
export declare class Client {
    config: Config;
    env: Environment;
    out: Output;
    clusterClient: GraphQLClient;
    mock: (input: {
        request: any;
        response: any;
    }) => void;
    private mocks;
    private tokenCache;
    constructor(config: Config, environment: Environment, out: Output);
    initClusterClient(cluster: Cluster, serviceName: string, stageName?: string, workspaceSlug?: string | undefined | null): Promise<void>;
    readonly client: GraphQLClient;
    readonly cloudClient: GraphQLClient;
    introspect(serviceName: string, stageName: string, token?: string, workspaceSlug?: string): Promise<any>;
    exec(serviceName: string, stageName: string, query: string, token?: string, workspaceSlug?: string): Promise<any>;
    download(serviceName: string, stage: string, exportData: any, token?: string, workspaceSlug?: string): Promise<any>;
    upload(serviceName: string, stage: string, exportData: any, token?: string, workspaceSlug?: string): Promise<any>;
    reset(serviceName: string, stage: string, token?: string, workspaceSlug?: string): Promise<void>;
    requestCloudToken(): Promise<string>;
    cloudTokenRequest(secret: string): Promise<CloudTokenRequestPayload>;
    ensureAuth(): Promise<void>;
    login(key?: string): Promise<void>;
    logout(): void;
    getAccount(): Promise<User | null>;
    getCloudServices(): Promise<Service[]>;
    generateClusterToken(workspaceSlug: string, clusterName: string, serviceName: string, stageName: string): Promise<string>;
    isAuthenticated(): Promise<boolean>;
    getWorkspaces(): Promise<Workspace[]>;
    addProject(name: string, stage: string, secrets: string[] | null): Promise<SimpleProjectInfo>;
    deleteProject(name: string, stage: string, workspaceSlug: string | null): Promise<void>;
    deploy(name: string, stage: string, types: string, dryRun: boolean, subscriptions: FunctionInput[], secrets: string[] | null, force?: boolean): Promise<any>;
    listProjects(): Promise<Project[]>;
    getProject(name: string, stage: string): Promise<Project | null>;
    getCluster(name: string, stage: string): Promise<Cluster | null>;
    getClusterSafe(name: string, stage: string): Promise<Cluster>;
    waitForLocalDocker(endpoint: string): Promise<void>;
    getMigration(name: string, stage: string): Promise<Migration>;
    authenticateCustomer(endpoint: string, token: string): Promise<AuthenticateCustomerPayload>;
}
