import { Command } from '../Command';
import boolean from './boolean';
import string from './string';
import number from './number';
export interface Flags {
    [name: string]: Flag<any>;
}
export declare type AlphabetUppercase = 'A' | 'B' | 'C' | 'D' | 'E' | 'F' | 'G' | 'H' | 'I' | 'J' | 'K' | 'L' | 'M' | 'N' | 'O' | 'P' | 'Q' | 'R' | 'S' | 'T' | 'U' | 'V' | 'W' | 'X' | 'Y' | 'Z';
export declare type AlphabetLowercase = 'a' | 'b' | 'c' | 'd' | 'e' | 'f' | 'g' | 'h' | 'i' | 'j' | 'k' | 'l' | 'm' | 'n' | 'o' | 'p' | 'q' | 'r' | 's' | 't' | 'u' | 'v' | 'w' | 'x' | 'y' | 'z';
export interface Flag<T> {
    parse?: (flag?: string, cmd?: Command, name?: string) => T;
    char?: AlphabetLowercase | AlphabetUppercase;
    description?: string;
    hidden?: boolean;
    required?: boolean;
    defaultValue?: any;
}
export interface Arg {
    name: string;
    description?: string;
    required?: boolean;
    hidden?: boolean;
}
export declare const flags: {
    boolean: typeof boolean;
    string: typeof string;
    number: typeof number;
};
