"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var SdlExpect = /** @class */ (function () {
    function SdlExpect() {
    }
    /**
     * Assertion helper for fields.
     */
    SdlExpect.field = function (candidate, name, required, list, type, isId, isReadOnly, defaultValue) {
        if (isId === void 0) { isId = false; }
        if (isReadOnly === void 0) { isReadOnly = false; }
        if (defaultValue === void 0) { defaultValue = null; }
        var fieldObj = candidate.fields.filter(function (f) { return f.name === name; })[0];
        expect(fieldObj).toBeDefined();
        expect(fieldObj.isRequired).toEqual(required);
        expect(fieldObj.isList).toEqual(list);
        expect(fieldObj.type).toEqual(type);
        expect(fieldObj.defaultValue).toEqual(defaultValue);
        expect(fieldObj.isId).toEqual(isId);
        expect(fieldObj.isReadOnly).toEqual(isReadOnly);
        expect(fieldObj.defaultValue).toEqual(defaultValue);
        return fieldObj;
    };
    /**
     * Assertion helper for errors.
     */
    SdlExpect.error = function (object) {
        expect(object.comments).toBeDefined();
        if (object.comments !== undefined) {
            expect(object.comments.some(function (x) { return x.isError; }));
        }
    };
    /**
     * Assertion helper for types
     */
    SdlExpect.type = function (types, name, isEnum, isEmbedded) {
        if (isEnum === void 0) { isEnum = false; }
        if (isEmbedded === void 0) { isEmbedded = false; }
        var type = types.filter(function (t) { return t.name === name; })[0];
        expect(type).toBeDefined();
        expect(type.isEnum).toEqual(isEnum);
        expect(type.isEmbedded).toEqual(isEmbedded);
        return type;
    };
    return SdlExpect;
}());
exports.SdlExpect = SdlExpect;
//# sourceMappingURL=index.js.map