import { GraphQLSchema } from 'graphql/type';
export default abstract class AstTools {
    /**
     * Checks if two schemas are equal.
     *
     * A schema A is considered equal to schema B if:
     *  * A has exactly the same types as B.
     *  * For field, the type, name and arguments match exactly.
     * @param original
     * @param toCheck
     */
    static assertTypesEqual(original: GraphQLSchema, toCheck: GraphQLSchema, modelName: string): void;
    private static allTypesFromAInB;
    private static scalarTypeEquals;
    private static allEnumFieldsFromAInB;
    private static allFieldsFromAInB;
    private static allArgsFromAInB;
}
