export interface Rule {
    getPlural(singular: string): string | null;
}
export declare class RegExpRule implements Rule {
    private singular;
    private plural;
    constructor(singular: RegExp, plural: string);
    getPlural(singular: string): string | null;
}
export declare class CategoryRule implements Rule {
    private list;
    private singular;
    private plural;
    constructor(list: string[], singular: string, plural: string);
    getPlural(word: string): string | null;
}
export declare abstract class TwoFormInflector {
    private rules;
    constructor();
    protected getPlural(word: string): string | null;
    protected uncountable(list: string[]): void;
    protected irregular(singular: string, plural: string): void;
    protected irregularFromList(list: Array<[string, string]>): void;
    protected rule(singular: string, plural: string): void;
    protected ruleFromList(list: Array<[string, string]>): void;
    protected categoryRule(list: string[], singular: string, plural: string): void;
}
