"use strict";
/*
 * Copyright 2011 Atteo.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-classes-per-file
var RegExpRule = /** @class */ (function () {
    function RegExpRule(singular, plural) {
        this.singular = singular;
        this.plural = plural;
    }
    RegExpRule.prototype.getPlural = function (singular) {
        // Important: Do not use g flag, we dont want to replace globally, only the first one
        if (this.singular.test(singular)) {
            var plural = singular.replace(this.singular, this.plural);
            return plural;
        }
        else {
            return null;
        }
    };
    return RegExpRule;
}());
exports.RegExpRule = RegExpRule;
var CategoryRule = /** @class */ (function () {
    function CategoryRule(list, singular, plural) {
        this.list = list;
        this.singular = singular;
        this.plural = plural;
    }
    CategoryRule.prototype.getPlural = function (word) {
        var lowerWord = word.toLowerCase();
        for (var _i = 0, _a = this.list; _i < _a.length; _i++) {
            var suffix = _a[_i];
            if (lowerWord.endsWith(suffix)) {
                if (!lowerWord.endsWith(this.singular)) {
                    throw new Error("Internal Error");
                }
                return word.substring(0, word.length - this.singular.length) + this.plural;
            }
        }
        return null;
    };
    return CategoryRule;
}());
exports.CategoryRule = CategoryRule;
var TwoFormInflector = /** @class */ (function () {
    function TwoFormInflector() {
        this.rules = [];
    }
    TwoFormInflector.prototype.getPlural = function (word) {
        for (var _i = 0, _a = this.rules; _i < _a.length; _i++) {
            var rule = _a[_i];
            var result = rule.getPlural(word);
            if (result != null) {
                return result;
            }
        }
        return null;
    };
    TwoFormInflector.prototype.uncountable = function (list) {
        this.rules.push(new CategoryRule(list, "", ""));
    };
    TwoFormInflector.prototype.irregular = function (singular, plural) {
        this.rules.push(new RegExpRule(new RegExp("" + singular.toUpperCase()[0] + singular.substring(1) + "$"), plural.toUpperCase()[0] + plural.substring(1)));
        this.rules.push(new RegExpRule(new RegExp("" + singular.toLowerCase()[0] + singular.substring(1) + "$"), plural.toLowerCase()[0] + plural.substring(1)));
    };
    TwoFormInflector.prototype.irregularFromList = function (list) {
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var _a = list_1[_i], a = _a[0], b = _a[1];
            this.irregular(a, b);
        }
    };
    TwoFormInflector.prototype.rule = function (singular, plural) {
        this.rules.push(new RegExpRule(new RegExp(singular, "i"), plural));
    };
    TwoFormInflector.prototype.ruleFromList = function (list) {
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var _a = list_2[_i], a = _a[0], b = _a[1];
            this.rule(a, b);
        }
    };
    TwoFormInflector.prototype.categoryRule = function (list, singular, plural) {
        this.rules.push(new CategoryRule(list, singular, plural));
    };
    return TwoFormInflector;
}());
exports.TwoFormInflector = TwoFormInflector;
//# sourceMappingURL=twoFormInflector.js.map