"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var english_1 = require("./inflector/english");
function capitalize(name) {
    return name.substring(0, 1).toUpperCase() + name.substring(1);
}
exports.capitalize = capitalize;
function camelCase(name) {
    return name.substring(0, 1).toLowerCase() + name.substring(1);
}
exports.camelCase = camelCase;
function plural(name) {
    var pluralWord = english_1.English.plural(name);
    if (pluralWord === null || pluralWord === name) {
        if (name.endsWith('s')) {
            return name + 'es';
        }
        else {
            return name + 's';
        }
    }
    else {
        return pluralWord;
    }
}
exports.plural = plural;
//# sourceMappingURL=util.js.map