"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Cluster_1 = require("./Cluster");
var fs = require("fs-extra");
var yaml = require("js-yaml");
var ClusterNotFound_1 = require("./errors/ClusterNotFound");
var Variables_1 = require("./Variables");
var Output_1 = require("./Output");
var path = require("path");
require("isomorphic-fetch");
var ClusterNotSet_1 = require("./errors/ClusterNotSet");
var constants_1 = require("./constants");
var getProxyAgent_1 = require("./utils/getProxyAgent");
var debug = require('debug')('Environment');
var Environment = /** @class */ (function () {
    function Environment(home, out) {
        if (out === void 0) { out = new Output_1.Output(); }
        this.sharedClusters = ['prisma-eu1', 'prisma-us1'];
        this.clusterEndpointMap = constants_1.clusterEndpointMap;
        this.globalRC = {};
        this.out = out;
        this.home = home;
        this.rcPath = path.join(this.home, '.prisma/config.yml');
        fs.mkdirpSync(path.dirname(this.rcPath));
    }
    Environment.prototype.load = function (loadClusters) {
        if (loadClusters === void 0) { loadClusters = true; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.loadGlobalRC()];
                    case 1:
                        _a.sent();
                        if (!loadClusters) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.getClusters()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    Object.defineProperty(Environment.prototype, "cloudSessionKey", {
        get: function () {
            return process.env.PRISMA_CLOUD_SESSION_KEY || this.globalRC.cloudSessionKey;
        },
        enumerable: true,
        configurable: true
    });
    Environment.prototype.renewToken = function () {
        return __awaiter(this, void 0, void 0, function () {
            var res, json, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.cloudSessionKey) return [3 /*break*/, 5];
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 4, , 5]);
                        return [4 /*yield*/, fetch('https://api.cloud.prisma.sh', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    Authorization: "Bearer " + this.cloudSessionKey,
                                },
                                body: JSON.stringify({
                                    query: "\n          mutation {\n            renewToken\n          }\n        ",
                                }),
                                proxy: getProxyAgent_1.getProxyAgent('https://api.cloud.prisma.sh'),
                            })];
                    case 2:
                        res = _a.sent();
                        return [4 /*yield*/, res.json()];
                    case 3:
                        json = _a.sent();
                        if (json && json.data && json.data.renewToken) {
                            this.globalRC.cloudSessionKey = json.data.renewToken;
                            this.saveGlobalRC();
                        }
                        return [3 /*break*/, 5];
                    case 4:
                        e_1 = _a.sent();
                        debug(e_1);
                        return [3 /*break*/, 5];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    Environment.prototype.getClusters = function () {
        return __awaiter(this, void 0, void 0, function () {
            var res, json, euIndex, usIndex, e_2;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.cloudSessionKey) return [3 /*break*/, 5];
                        this.renewToken();
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 4, , 5]);
                        return [4 /*yield*/, Promise.race([
                                fetch('https://api.cloud.prisma.sh', {
                                    method: 'POST',
                                    headers: {
                                        'Content-Type': 'application/json',
                                        Authorization: "Bearer " + this.cloudSessionKey,
                                    },
                                    body: JSON.stringify({
                                        query: "\n          {\n            me {\n              memberships {\n                workspace {\n                  id\n                  slug\n                  clusters {\n                    id\n                    name\n                    connectInfo {\n                      endpoint\n                    }\n                    customConnectionInfo {\n                      endpoint\n                    }\n                  }\n                }\n              }\n            }\n          }\n        ",
                                    }),
                                    agent: getProxyAgent_1.getProxyAgent('https://api.cloud.prisma.sh'),
                                }),
                                new Promise(function (_, r) { return setTimeout(function () { return r(); }, 6000); }),
                            ])];
                    case 2:
                        res = (_a.sent());
                        if (!res) {
                            return [2 /*return*/];
                        }
                        return [4 /*yield*/, res.json()];
                    case 3:
                        json = _a.sent();
                        if (json &&
                            json.data &&
                            json.data.me &&
                            json.data.me.memberships &&
                            Array.isArray(json.data.me.memberships)) {
                            euIndex = this.clusters.findIndex(function (c) { return c.name === 'prisma-eu1'; });
                            this.clusters.splice(euIndex, 1);
                            usIndex = this.clusters.findIndex(function (c) { return c.name === 'prisma-us1'; });
                            this.clusters.splice(usIndex, 1);
                            json.data.me.memberships.forEach(function (m) {
                                m.workspace.clusters.forEach(function (cluster) {
                                    var endpoint = cluster.connectInfo
                                        ? cluster.connectInfo.endpoint
                                        : cluster.customConnectionInfo
                                            ? cluster.customConnectionInfo.endpoint
                                            : _this.clusterEndpointMap[cluster.name];
                                    _this.addCluster(new Cluster_1.Cluster(_this.out, cluster.name, endpoint, _this.globalRC.cloudSessionKey, false, ['prisma-eu1', 'prisma-us1'].includes(cluster.name), !['prisma-eu1', 'prisma-us1'].includes(cluster.name), m.workspace.slug));
                                });
                            });
                        }
                        return [3 /*break*/, 5];
                    case 4:
                        e_2 = _a.sent();
                        debug(e_2);
                        return [3 /*break*/, 5];
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    Environment.prototype.clusterByName = function (name, throws) {
        if (throws === void 0) { throws = false; }
        var cluster = this.clusters.find(function (c) { return c.name === name; });
        if (!throws) {
            return cluster;
        }
        if (!cluster) {
            if (!name) {
                throw new ClusterNotSet_1.ClusterNotSet();
            }
            throw new ClusterNotFound_1.ClusterNotFound(name);
        }
        return cluster;
    };
    Environment.prototype.setToken = function (token) {
        this.globalRC.cloudSessionKey = token;
    };
    Environment.prototype.addCluster = function (cluster) {
        var existingClusterIndex = this.clusters.findIndex(function (c) {
            if (cluster.workspaceSlug) {
                return (c.workspaceSlug === cluster.workspaceSlug && c.name === cluster.name);
            }
            else {
                return c.name === cluster.name;
            }
        });
        if (existingClusterIndex > -1) {
            this.clusters.splice(existingClusterIndex, 1);
        }
        this.clusters.push(cluster);
    };
    Environment.prototype.removeCluster = function (name) {
        this.clusters = this.clusters.filter(function (c) { return c.name !== name; });
    };
    Environment.prototype.saveGlobalRC = function () {
        var rc = {
            cloudSessionKey: this.globalRC.cloudSessionKey
                ? this.globalRC.cloudSessionKey.trim()
                : undefined,
            clusters: this.getLocalClusterConfig(),
        };
        // parse & stringify to rm undefined for yaml parser
        debug('saving global rc');
        var rcString = yaml.safeDump(JSON.parse(JSON.stringify(rc)));
        fs.writeFileSync(this.rcPath, rcString);
    };
    Environment.prototype.setActiveCluster = function (cluster) {
        this.activeCluster = cluster;
    };
    Environment.prototype.loadGlobalRC = function () {
        return __awaiter(this, void 0, void 0, function () {
            var globalFile;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        globalFile = this.rcPath && fs.pathExistsSync(this.rcPath)
                            ? fs.readFileSync(this.rcPath, 'utf-8')
                            : undefined;
                        return [4 /*yield*/, this.parseGlobalRC(globalFile)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Environment.prototype.parseGlobalRC = function (globalFile) {
        return __awaiter(this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!globalFile) return [3 /*break*/, 2];
                        _a = this;
                        return [4 /*yield*/, this.loadYaml(globalFile, this.rcPath)];
                    case 1:
                        _a.globalRC = _b.sent();
                        _b.label = 2;
                    case 2:
                        this.clusters = this.initClusters(this.globalRC);
                        return [2 /*return*/];
                }
            });
        });
    };
    Environment.prototype.loadYaml = function (file, filePath) {
        if (filePath === void 0) { filePath = null; }
        return __awaiter(this, void 0, void 0, function () {
            var content, variables;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!file) return [3 /*break*/, 2];
                        content = void 0;
                        try {
                            content = yaml.safeLoad(file);
                        }
                        catch (e) {
                            throw new Error("Yaml parsing error in " + filePath + ": " + e.message);
                        }
                        variables = new Variables_1.Variables(filePath || 'no filepath provided', this.args, this.out);
                        return [4 /*yield*/, variables.populateJson(content)];
                    case 1:
                        content = _a.sent();
                        return [2 /*return*/, content];
                    case 2: return [2 /*return*/, {}];
                }
            });
        });
    };
    Environment.prototype.initClusters = function (rc) {
        var sharedClusters = this.getSharedClusters(rc);
        return sharedClusters.slice();
    };
    Environment.prototype.getSharedClusters = function (rc) {
        var _this = this;
        return this.sharedClusters.map(function (clusterName) {
            return new Cluster_1.Cluster(_this.out, clusterName, _this.clusterEndpointMap[clusterName], rc && rc.cloudSessionKey, false, true);
        });
    };
    Environment.prototype.getLocalClusterConfig = function () {
        var _this = this;
        return this.clusters
            .filter(function (c) {
            return !c.shared && c.clusterSecret !== _this.cloudSessionKey && !c.isPrivate;
        })
            .reduce(function (acc, cluster) {
            var _a;
            return __assign({}, acc, (_a = {}, _a[cluster.name] = {
                host: cluster.baseUrl,
                clusterSecret: cluster.clusterSecret,
            }, _a));
        }, {});
    };
    return Environment;
}());
exports.Environment = Environment;
exports.isLocal = function (hostname) {
    return hostname.includes('localhost') || hostname.includes('127.0.0.1');
};
//# sourceMappingURL=Environment.js.map