import { PrismaDefinition } from 'prisma-json-schema';
import { Args } from './types/common';
import { Environment } from './Environment';
import { IOutput } from './Output';
import { Cluster } from './Cluster';
import { FunctionInput } from './types/rc';
export interface EnvVars {
    [key: string]: string | undefined;
}
export declare type HookType = 'post-deploy';
export declare class PrismaDefinitionClass {
    definition?: PrismaDefinition;
    rawJson?: any;
    typesString?: string;
    secrets: string[] | null;
    definitionPath?: string | null;
    definitionDir: string;
    env: Environment;
    out?: IOutput;
    envVars: any;
    rawEndpoint?: string;
    private definitionString;
    constructor(env: Environment, definitionPath?: string | null, envVars?: EnvVars, out?: IOutput);
    load(args: Args, envPath?: string, graceful?: boolean): Promise<void>;
    private loadDefinition;
    readonly endpoint: string | undefined;
    readonly clusterBaseUrl: string | undefined;
    readonly service: string | undefined;
    readonly stage: string | undefined;
    readonly cluster: string | undefined;
    validate(): void;
    getToken(serviceName: string, stageName: string): string | undefined;
    getCluster(throws?: boolean): Cluster | undefined;
    getTypesString(definition: PrismaDefinition): string;
    getClusterName(): string | null;
    getWorkspace(): string | null;
    getDeployName(): string;
    getSubscriptions(): FunctionInput[];
    replaceEndpoint(newEndpoint: any): void;
    addDatamodel(datamodel: any): void;
    getEndpoint(serviceInput?: string, stageInput?: string): string | null;
    getHooks(hookType: HookType): string[];
}
export declare function concatName(cluster: Cluster, name: string, workspace: string | null): string;
export declare function getEndpointFromRawProps(clusterWorkspace: string, service: string, stage: string): void;
