"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var PrismaDefinition_1 = require("./PrismaDefinition");
var fs = require("fs-extra");
var path = require("path");
var getTmpDir_1 = require("./test/getTmpDir");
var Environment_test_1 = require("./Environment.test");
var defaultGlobalRC = "prisma-1.0:\n  clusters:\n    local:\n      host: 'http://localhost:4466'\n    remote:\n      host: 'https://remote.graph.cool'\n      clusterSecret: 'here-is-a-token'\n";
function makeDefinition(yml, datamodel, args, globalRC, envVars) {
    if (args === void 0) { args = {}; }
    if (globalRC === void 0) { globalRC = defaultGlobalRC; }
    if (envVars === void 0) { envVars = process.env; }
    var definitionDir = getTmpDir_1.getTmpDir();
    var definitionPath = path.join(definitionDir, 'prisma.yml');
    var modelPath = path.join(definitionDir, 'datamodel.prisma');
    var env = Environment_test_1.makeEnv(defaultGlobalRC);
    var definition = new PrismaDefinition_1.PrismaDefinitionClass(env, definitionPath, envVars);
    fs.writeFileSync(modelPath, datamodel);
    fs.writeFileSync(definitionPath, yml);
    return { env: env, definition: definition };
}
function loadDefinition(yml, datamodel, args, envPath, globalRC) {
    if (args === void 0) { args = {}; }
    if (globalRC === void 0) { globalRC = defaultGlobalRC; }
    return __awaiter(this, void 0, void 0, function () {
        var _a, env, definition;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = makeDefinition(yml, datamodel, args, globalRC), env = _a.env, definition = _a.definition;
                    return [4 /*yield*/, env.load()];
                case 1:
                    _b.sent();
                    return [4 /*yield*/, definition.load(args, envPath)];
                case 2:
                    _b.sent();
                    return [2 /*return*/, { env: env, definition: definition }];
            }
        });
    });
}
describe('prisma definition', function () {
    test('load basic yml, provide cluster', function () { return __awaiter(_this, void 0, void 0, function () {
        var yml, datamodel, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nsecret: some-secret\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    expect(e_1).toMatchSnapshot();
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    }); });
    test('load yml with secret and env var', function () { return __awaiter(_this, void 0, void 0, function () {
        var secret, yml, datamodel, e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    secret = 'this-is-a-long-secret';
                    process.env.MY_TEST_SECRET = secret;
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nsecret: ${env:MY_TEST_SECRET}\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 2:
                    _a.sent();
                    return [3 /*break*/, 4];
                case 3:
                    e_2 = _a.sent();
                    expect(e_2).toMatchSnapshot();
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    }); });
    test('load yml with secret and env var in .env', function () { return __awaiter(_this, void 0, void 0, function () {
        var secret, yml, datamodel, _a, definition, env, envPath, e_3;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    secret = 'this-is-a-long-secret';
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nsecret: ${env:MY_DOT_ENV_SECRET}\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a = makeDefinition(yml, datamodel, {}), definition = _a.definition, env = _a.env;
                    envPath = path.join(definition.definitionDir, '.env');
                    fs.outputFileSync(envPath, "MY_DOT_ENV_SECRET=this-is-very-secret,and-comma,seperated");
                    return [4 /*yield*/, env.load()];
                case 1:
                    _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 3:
                    _b.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_3 = _b.sent();
                    expect(e_3).toMatchSnapshot();
                    return [3 /*break*/, 5];
                case 5: return [2 /*return*/];
            }
        });
    }); });
    test('load yml with injected env var', function () { return __awaiter(_this, void 0, void 0, function () {
        var secret, yml, datamodel, envVars, _a, definition, env, e_4;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    secret = 'this-is-a-long-secret';
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nsecret: ${env:MY_INJECTED_ENV_SECRET}\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    envVars = {
                        MY_INJECTED_ENV_SECRET: 'some-secret',
                    };
                    _a = makeDefinition(yml, datamodel, {}, defaultGlobalRC, envVars), definition = _a.definition, env = _a.env;
                    return [4 /*yield*/, env.load()];
                case 1:
                    _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 3:
                    _b.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_4 = _b.sent();
                    expect(e_4).toMatchSnapshot();
                    return [3 /*break*/, 5];
                case 5: return [2 /*return*/];
            }
        });
    }); });
    /**
     * This test ensures, that GRAPHCOOL_SECRET can't be injected anymore
     */
    test('dont load yml with secret and env var in args', function () { return __awaiter(_this, void 0, void 0, function () {
        var yml, datamodel, definitionDir, definitionPath, modelPath, env, definition, error, e_5;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    definitionDir = getTmpDir_1.getTmpDir();
                    definitionPath = path.join(definitionDir, 'prisma.yml');
                    modelPath = path.join(definitionDir, 'datamodel.prisma');
                    env = Environment_test_1.makeEnv(defaultGlobalRC);
                    definition = new PrismaDefinition_1.PrismaDefinitionClass(env, definitionPath, {
                        GRAPHCOOL_SECRET: 'this-is-secret',
                    });
                    fs.writeFileSync(modelPath, datamodel);
                    fs.writeFileSync(definitionPath, yml);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, , 5]);
                    return [4 /*yield*/, env.load()];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, definition.load({})];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_5 = _a.sent();
                    error = e_5;
                    return [3 /*break*/, 5];
                case 5:
                    expect(error).toMatchSnapshot();
                    return [2 /*return*/];
            }
        });
    }); });
    test('load yml with disableAuth: true', function () { return __awaiter(_this, void 0, void 0, function () {
        var secret, yml, datamodel, _a, definition, env, envPath, e_6;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    secret = 'this-is-a-long-secret';
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\ndisableAuth: true\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a = makeDefinition(yml, datamodel), definition = _a.definition, env = _a.env;
                    envPath = path.join(definition.definitionDir, '.env');
                    fs.outputFileSync(envPath, "MY_DOT_ENV_SECRET=this-is-very-secret,and-comma,seperated");
                    return [4 /*yield*/, env.load()];
                case 1:
                    _b.sent();
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 3:
                    _b.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_6 = _b.sent();
                    expect(e_6).toMatchSnapshot();
                    return [3 /*break*/, 5];
                case 5: return [2 /*return*/];
            }
        });
    }); });
    test('throw when no secret or disable auth provided', function () { return __awaiter(_this, void 0, void 0, function () {
        var yml, datamodel, error, definition, e_7;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nschema: schemas/database.graphql\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 2:
                    definition = (_a.sent()).definition;
                    return [3 /*break*/, 4];
                case 3:
                    e_7 = _a.sent();
                    error = e_7;
                    return [3 /*break*/, 4];
                case 4:
                    expect(error).toMatchSnapshot();
                    return [2 /*return*/];
            }
        });
    }); });
    test('throws when stages key apparent', function () { return __awaiter(_this, void 0, void 0, function () {
        var yml, datamodel, error, definition, e_8;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    yml = "service: jj\nstage: dev\ncluster: local\n\ndatamodel:\n- datamodel.prisma\n\nschema: schemas/database.graphql\n\nstages:\n  dev: local\n    ";
                    datamodel = "\ntype User @model {\n  id: ID! @isUnique\n  name: String!\n  lol: Int\n  what: String\n}\n";
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, loadDefinition(yml, datamodel)];
                case 2:
                    definition = (_a.sent()).definition;
                    return [3 /*break*/, 4];
                case 3:
                    e_8 = _a.sent();
                    error = e_8;
                    return [3 /*break*/, 4];
                case 4:
                    expect(error).toMatchSnapshot();
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=PrismaDefinition.test.js.map