"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var SVGPathData = (function () {
    function SVGPathData(content) {
        if ("string" === typeof content) {
            this.commands = SVGPathData.parse(content);
        }
        else {
            this.commands = content;
        }
    }
    SVGPathData.prototype.encode = function () {
        return SVGPathData.encode(this.commands);
    };
    SVGPathData.prototype.round = function (x) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.ROUND(x));
    };
    SVGPathData.prototype.toAbs = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.TO_ABS());
    };
    SVGPathData.prototype.toRel = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.TO_REL());
    };
    SVGPathData.prototype.normalizeHVZ = function (a, b, c) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.NORMALIZE_HVZ(a, b, c));
    };
    SVGPathData.prototype.normalizeST = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.NORMALIZE_ST());
    };
    SVGPathData.prototype.qtToC = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.QT_TO_C());
    };
    SVGPathData.prototype.aToC = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.A_TO_C());
    };
    SVGPathData.prototype.sanitize = function (eps) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.SANITIZE(eps));
    };
    SVGPathData.prototype.translate = function (x, y) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.TRANSLATE(x, y));
    };
    SVGPathData.prototype.scale = function (x, y) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.SCALE(x, y));
    };
    SVGPathData.prototype.rotate = function (a, x, y) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.ROTATE(a, x, y));
    };
    SVGPathData.prototype.matrix = function (a, b, c, d, e, f) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.MATRIX(a, b, c, d, e, f));
    };
    SVGPathData.prototype.skewX = function (a) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.SKEW_X(a));
    };
    SVGPathData.prototype.skewY = function (a) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.SKEW_Y(a));
    };
    SVGPathData.prototype.xSymmetry = function (xOffset) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.X_AXIS_SYMMETRY(xOffset));
    };
    SVGPathData.prototype.ySymmetry = function (yOffset) {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.Y_AXIS_SYMMETRY(yOffset));
    };
    SVGPathData.prototype.annotateArcs = function () {
        return this.transform(SVGPathDataTransformer_1.SVGPathDataTransformer.ANNOTATE_ARCS());
    };
    SVGPathData.prototype.getBounds = function () {
        var boundsTransform = SVGPathDataTransformer_1.SVGPathDataTransformer.CALCULATE_BOUNDS();
        this.transform(boundsTransform);
        return boundsTransform;
    };
    SVGPathData.prototype.transform = function (transformFunction) {
        var newCommands = [];
        for (var _i = 0, _a = this.commands; _i < _a.length; _i++) {
            var command = _a[_i];
            var transformedCommand = transformFunction(command);
            if (transformedCommand instanceof Array) {
                newCommands.push.apply(newCommands, transformedCommand);
            }
            else {
                newCommands.push(transformedCommand);
            }
        }
        this.commands = newCommands;
        return this;
    };
    SVGPathData.encode = function (commands) {
        var content = "";
        var encoder = new SVGPathDataEncoder_1.SVGPathDataEncoder();
        encoder.on("readable", function () {
            var str;
            while (null !== (str = encoder.read())) {
                content += str;
            }
        });
        encoder.write(commands);
        encoder.end();
        return content;
    };
    SVGPathData.parse = function (content) {
        var commands = [];
        var parser = new SVGPathDataParser_1.SVGPathDataParser();
        parser.on("readable", function () {
            var command;
            while (null !== (command = parser.read())) {
                commands.push(command);
            }
        });
        parser.write(content);
        parser.end();
        return commands;
    };
    SVGPathData.CLOSE_PATH = 1;
    SVGPathData.MOVE_TO = 2;
    SVGPathData.HORIZ_LINE_TO = 4;
    SVGPathData.VERT_LINE_TO = 8;
    SVGPathData.LINE_TO = 16;
    SVGPathData.CURVE_TO = 32;
    SVGPathData.SMOOTH_CURVE_TO = 64;
    SVGPathData.QUAD_TO = 128;
    SVGPathData.SMOOTH_QUAD_TO = 256;
    SVGPathData.ARC = 512;
    SVGPathData.LINE_COMMANDS = SVGPathData.LINE_TO | SVGPathData.HORIZ_LINE_TO | SVGPathData.VERT_LINE_TO;
    SVGPathData.DRAWING_COMMANDS = SVGPathData.HORIZ_LINE_TO | SVGPathData.VERT_LINE_TO | SVGPathData.LINE_TO |
        SVGPathData.CURVE_TO | SVGPathData.SMOOTH_CURVE_TO | SVGPathData.QUAD_TO |
        SVGPathData.SMOOTH_QUAD_TO | SVGPathData.ARC;
    return SVGPathData;
}());
exports.SVGPathData = SVGPathData;
var SVGPathDataEncoder_1 = require("./SVGPathDataEncoder");
exports.SVGPathDataEncoder = SVGPathDataEncoder_1.SVGPathDataEncoder;
var SVGPathDataParser_1 = require("./SVGPathDataParser");
exports.SVGPathDataParser = SVGPathDataParser_1.SVGPathDataParser;
var SVGPathDataTransformer_1 = require("./SVGPathDataTransformer");
exports.SVGPathDataTransformer = SVGPathDataTransformer_1.SVGPathDataTransformer;
//# sourceMappingURL=SVGPathData.js.map